/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.entry;

import android.support.annotation.Nullable;
import com.liuxiangdong.jsonview.ConfigurationProvider;
import com.liuxiangdong.jsonview.OnCopyJsonStringListener;
import com.liuxiangdong.jsonview.entry.JsonEntry;
import com.liuxiangdong.jsonview.entry.JsonEntryFactory;
import com.liuxiangdong.jsonview.entry.JsonParent;
import com.liuxiangdong.jsonview.entry.converter.JsonEntryConverterRegistry;
import com.liuxiangdong.jsonview.vm.JsonViewModel;
import java.util.ArrayList;
import java.util.List;

public abstract class JsonCompoundEntry<T>
extends JsonEntry<T>
implements JsonParent {
    private List<JsonEntry<?>> children;
    private boolean collapsed = true;
    private List<JsonViewModel> collapsedViewModels;
    private OnStateChangeListener onStateChangeListener;
    private OnCopyJsonStringListener onCopyJsonStringListener;
    private ConfigurationProvider provider;

    JsonCompoundEntry(String key, T value, int depth, int index, JsonEntryConverterRegistry registry) {
        super(key, value, depth, index, registry);
    }

    JsonEntry<?> createJsonEntry(String key, Object value, int index) {
        return JsonEntryFactory.createJsonEntry(key, value, this.getDepth() + 1, index, this.getRegistry());
    }

    void addChild(JsonEntry<?> child) {
        if (child != null) {
            child.setParent(this);
            this.children.add(child);
            if (child instanceof JsonCompoundEntry) {
                JsonCompoundEntry compoundItem = (JsonCompoundEntry)child;
                compoundItem.onStateChangeListener = this.onStateChangeListener;
                compoundItem.onCopyJsonStringListener = this.onCopyJsonStringListener;
                compoundItem.setConfigurationProvider(this.provider);
            }
        }
    }

    public void setConfigurationProvider(ConfigurationProvider provider) {
        this.provider = provider;
        if (provider != null) {
            if (provider.shouldCollapse(this)) {
                this.setCollapsed(true);
            } else {
                this.setCollapsed(false);
            }
        }
    }

    public void setOnStateChangeListener(OnStateChangeListener listener) {
        this.onStateChangeListener = listener;
        if (this.children != null && !this.children.isEmpty()) {
            for (JsonEntry<?> child : this.children) {
                if (!(child instanceof JsonCompoundEntry)) continue;
                ((JsonCompoundEntry)child).setOnStateChangeListener(this.onStateChangeListener);
            }
        }
    }

    public void setOnCopyJsonStringListener(OnCopyJsonStringListener listener) {
        this.onCopyJsonStringListener = listener;
        if (this.children != null && !this.children.isEmpty()) {
            for (JsonEntry<?> child : this.children) {
                if (!(child instanceof JsonCompoundEntry)) continue;
                ((JsonCompoundEntry)child).setOnCopyJsonStringListener(this.onCopyJsonStringListener);
            }
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void copyJsonString() {
        if (this.onCopyJsonStringListener != null) {
            this.onCopyJsonStringListener.onCopy(this.getValue().toString());
        }
    }

    public void expandAll() {
        this.setCollapsedInternal(false);
        boolean notifyStateChange = true;
        if (this.children != null && !this.children.isEmpty()) {
            for (JsonEntry<?> child : this.children) {
                if (!(child instanceof JsonCompoundEntry)) continue;
                ((JsonCompoundEntry)child).expandAll();
                notifyStateChange = false;
            }
        }
        if (notifyStateChange) {
            this.notifyStateChange();
        }
    }

    public void collapseAll() {
        this.setCollapsedInternal(true);
        boolean notifyStateChange = true;
        if (this.children != null && !this.children.isEmpty()) {
            for (JsonEntry<?> child : this.children) {
                if (!(child instanceof JsonCompoundEntry)) continue;
                ((JsonCompoundEntry)child).collapseAll();
                notifyStateChange = false;
            }
        }
        if (notifyStateChange) {
            this.notifyStateChange();
        }
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.setCollapsedInternal(collapsed);
        this.notifyStateChange();
    }

    private void setCollapsedInternal(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        if (!collapsed && this.children == null) {
            this.children = new ArrayList();
            this.inflateChildren();
        }
    }

    private void notifyStateChange() {
        this.invalidateViewModels();
        if (this.onStateChangeListener != null) {
            this.onStateChangeListener.onStateChange();
        }
    }

    protected abstract void inflateChildren();

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Nullable
    public JsonEntry<?> getChildAt(int position) {
        if (position >= 0 && position < this.getChildCount()) {
            return this.children.get(position);
        }
        return null;
    }

    @Override
    public void invalidateViewModels() {
        this.viewModels = null;
        if (this.getParent() != null) {
            this.getParent().invalidateViewModels();
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChange();
    }
}

