/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview;

import android.support.annotation.NonNull;
import android.view.ViewGroup;
import com.liuxiangdong.jsonview.DefaultElementProvider;
import com.liuxiangdong.jsonview.ElementProvider;
import com.liuxiangdong.jsonview.JsonAdapter;
import com.liuxiangdong.jsonview.renderer.JsonArrayBeginRenderer;
import com.liuxiangdong.jsonview.renderer.JsonArrayCollapsedRenderer;
import com.liuxiangdong.jsonview.renderer.JsonArrayEndRenderer;
import com.liuxiangdong.jsonview.renderer.JsonBooleanRenderer;
import com.liuxiangdong.jsonview.renderer.JsonDoubleRenderer;
import com.liuxiangdong.jsonview.renderer.JsonIntegerRenderer;
import com.liuxiangdong.jsonview.renderer.JsonLongRenderer;
import com.liuxiangdong.jsonview.renderer.JsonNullRenderer;
import com.liuxiangdong.jsonview.renderer.JsonObjectBeginRenderer;
import com.liuxiangdong.jsonview.renderer.JsonObjectCollapsedRenderer;
import com.liuxiangdong.jsonview.renderer.JsonObjectEndRenderer;
import com.liuxiangdong.jsonview.renderer.JsonStringRenderer;
import com.liuxiangdong.jsonview.renderer.Renderer;
import com.liuxiangdong.jsonview.renderer.RendererRegistry;
import com.liuxiangdong.jsonview.vh.JsonViewHolder;
import com.liuxiangdong.jsonview.vm.JsonViewModel;

public class DefaultJsonAdapter
extends JsonAdapter {
    private ElementProvider elementProvider = new DefaultElementProvider();
    private final RendererRegistry rendererRegistry = new RendererRegistry();

    public DefaultJsonAdapter() {
        this.registerAllRenderers();
    }

    private void registerAllRenderers() {
        this.registerRender(new JsonBooleanRenderer());
        this.registerRender(new JsonDoubleRenderer());
        this.registerRender(new JsonIntegerRenderer());
        this.registerRender(new JsonLongRenderer());
        this.registerRender(new JsonNullRenderer());
        this.registerRender(new JsonStringRenderer());
        this.registerRender(new JsonArrayBeginRenderer());
        this.registerRender(new JsonArrayEndRenderer());
        this.registerRender(new JsonArrayCollapsedRenderer());
        this.registerRender(new JsonObjectBeginRenderer());
        this.registerRender(new JsonObjectEndRenderer());
        this.registerRender(new JsonObjectCollapsedRenderer());
    }

    public <VM extends JsonViewModel, VH extends JsonViewHolder<VM>> void registerRender(Renderer<VM, VH> renderer) {
        this.rendererRegistry.registerRender(renderer);
    }

    public void setElementProvider(ElementProvider elementProvider) {
        if (elementProvider != null) {
            this.elementProvider = elementProvider;
        }
    }

    @NonNull
    public JsonViewHolder<? extends JsonViewModel> onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        Renderer renderer = this.rendererRegistry.getRenderer(i);
        if (renderer == null) {
            throw new IllegalStateException("No renderer for view type " + i);
        }
        return renderer.onCreateViewHolder(viewGroup, this.elementProvider);
    }

    public void onBindViewHolder(@NonNull JsonViewHolder<? extends JsonViewModel> jsonViewHolder, int i) {
        int viewType = this.getItemViewType(i);
        this.onBindViewHolderInternal(viewType, jsonViewHolder, this.getItem(i));
    }

    public int getItemViewType(int position) {
        Class<?> clazz = this.getItem(position).getClass();
        int viewType = this.rendererRegistry.getItemViewType(clazz);
        if (viewType == 0) {
            throw new IllegalStateException("Invalid view type for " + clazz.getSimpleName());
        }
        return viewType;
    }

    private <VM extends JsonViewModel, VH extends JsonViewHolder<VM>> void onBindViewHolderInternal(int viewType, JsonViewHolder<VM> viewHolder, JsonViewModel viewModel) {
        Renderer<JsonViewModel, JsonViewHolder<VM>> renderer = this.rendererRegistry.getRenderer(viewType);
        if (renderer == null) {
            throw new IllegalStateException("No renderer for view type " + viewType);
        }
        JsonViewHolder<VM> vh = viewHolder;
        JsonViewModel vm = viewModel;
        renderer.onBindViewHolder(vh, vm);
    }
}

