/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.liuxiangdong.jsonview.ElementProvider;
import com.liuxiangdong.jsonview.R;
import com.liuxiangdong.jsonview.vm.JsonViewModel;

public class DefaultElementProvider
implements ElementProvider {
    private static final int DISPLAYABLE_ENTRY_COUNT = 5;

    @Override
    public View createExpandView(ViewGroup parent) {
        Context context = parent.getContext();
        ImageView imageView = new ImageView(context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_item_height), context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_item_height));
        imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
        int padding = context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_icon_padding);
        imageView.setPadding(padding, padding, padding, padding);
        imageView.setImageResource(R.drawable.json_view_expand);
        return imageView;
    }

    @Override
    public View createCollapseView(ViewGroup parent) {
        Context context = parent.getContext();
        ImageView imageView = new ImageView(context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_item_height), context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_item_height));
        imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
        int padding = context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_icon_padding);
        imageView.setPadding(padding, padding, padding, padding);
        imageView.setImageResource(R.drawable.json_view_collapse);
        return imageView;
    }

    @Override
    public View createCopyView(ViewGroup parent) {
        Context context = parent.getContext();
        ImageView imageView = new ImageView(context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_item_height), context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_item_height));
        imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
        int padding = context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_icon_padding);
        imageView.setPadding(padding, padding, padding, padding);
        imageView.setImageResource(R.drawable.json_view_copy);
        return imageView;
    }

    @Override
    public TextView createKeyView(ViewGroup parent) {
        Context context = parent.getContext();
        TextView textView = new TextView(context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_item_height));
        textView.setLayoutParams((ViewGroup.LayoutParams)lp);
        textView.setGravity(16);
        textView.setMaxLines(1);
        textView.setSingleLine(true);
        textView.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.json_view_key_color));
        textView.setTextIsSelectable(true);
        textView.setTextSize(0, (float)context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_text_size));
        textView.setTypeface(Typeface.DEFAULT_BOLD);
        return textView;
    }

    @Override
    public TextView createOpeningBraceView(ViewGroup parent) {
        return this.createKeyView(parent);
    }

    @Override
    public TextView createClosingBraceView(ViewGroup parent) {
        return this.createKeyView(parent);
    }

    @Override
    public TextView createOpeningBracketView(ViewGroup parent) {
        return this.createKeyView(parent);
    }

    @Override
    public TextView createClosingBracketView(ViewGroup parent) {
        return this.createKeyView(parent);
    }

    @Override
    public TextView createStringValueView(ViewGroup parent) {
        return DefaultElementProvider.createValueView(parent);
    }

    @Override
    public TextView createIntegerValueView(ViewGroup parent) {
        return DefaultElementProvider.createValueView(parent);
    }

    @Override
    public TextView createBooleanValueView(ViewGroup parent) {
        return DefaultElementProvider.createValueView(parent);
    }

    @Override
    public TextView createDoubleValueView(ViewGroup parent) {
        return DefaultElementProvider.createValueView(parent);
    }

    @Override
    public TextView createLongValueView(ViewGroup parent) {
        return DefaultElementProvider.createValueView(parent);
    }

    @Override
    public TextView createNullValueView(ViewGroup parent) {
        return DefaultElementProvider.createValueView(parent);
    }

    @Override
    public TextView createCollapsedObjectInfoView(ViewGroup parent) {
        return DefaultElementProvider.createValueView(parent);
    }

    @Override
    public TextView createCollapsedArrayInfoView(ViewGroup parent) {
        return DefaultElementProvider.createValueView(parent);
    }

    private static TextView createValueView(ViewGroup parent) {
        Context context = parent.getContext();
        TextView textView = new TextView(context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_item_height));
        lp.leftMargin = context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_margin_left);
        textView.setLayoutParams((ViewGroup.LayoutParams)lp);
        textView.setGravity(16);
        textView.setMaxLines(1);
        textView.setSingleLine(true);
        textView.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.json_view_value_color));
        textView.setTextIsSelectable(true);
        textView.setTextSize(0, (float)context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_text_size));
        return textView;
    }

    @Override
    public int indentationWidth(Context context) {
        return context.getResources().getDimensionPixelSize(R.dimen.json_view_indentation);
    }

    @Override
    public int indentationViewLineWidth(Context context) {
        return 1;
    }

    @Override
    public int indentationViewLineColor(Context context) {
        return ContextCompat.getColor((Context)context, (int)R.color.json_view_key_color);
    }

    @Override
    @Nullable
    public TextView createIndexView(ViewGroup parent) {
        Context context = parent.getContext();
        TextView textView = new TextView(context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        lp.rightMargin = context.getResources().getDimensionPixelSize(R.dimen.json_view_primary_margin_left);
        lp.gravity = 16;
        textView.setLayoutParams((ViewGroup.LayoutParams)lp);
        textView.setMaxLines(1);
        textView.setSingleLine(true);
        textView.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.json_view_index_text_color));
        textView.setTextSize(0, (float)context.getResources().getDimensionPixelSize(R.dimen.json_view_caption_text_size));
        ViewCompat.setBackground((View)textView, (Drawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.json_view_index_background));
        int padding = context.getResources().getDimensionPixelSize(R.dimen.json_view_index_padding);
        textView.setPadding(padding, padding, padding, padding);
        return textView;
    }

    @Override
    public <T extends JsonViewModel> boolean shouldDisplayIndex(Context context, T viewModel) {
        return viewModel.getParentEntryCount() >= 5;
    }
}

