/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.vh;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.liuxiangdong.jsonview.ElementProvider;
import com.liuxiangdong.jsonview.vh.CopyJsonStringViewHolder;
import com.liuxiangdong.jsonview.vm.JsonObjectCollapsedViewModel;

public class JsonObjectCollapsedViewHolder
extends CopyJsonStringViewHolder<JsonObjectCollapsedViewModel>
implements View.OnLongClickListener {
    private final TextView keyTextView;
    private final View expandView;
    private final TextView collapsedInfo;

    public JsonObjectCollapsedViewHolder(Context context, ElementProvider elementProvider) {
        super(context, elementProvider);
        this.keyTextView = elementProvider.createKeyView((ViewGroup)this.linearLayout);
        this.linearLayout.addView((View)this.keyTextView);
        this.expandView = elementProvider.createExpandView((ViewGroup)this.linearLayout);
        if (this.expandView != null) {
            this.linearLayout.addView(this.expandView);
            this.expandView.setOnClickListener((View.OnClickListener)this);
            this.expandView.setOnLongClickListener((View.OnLongClickListener)this);
        }
        if (this.copyView != null) {
            this.linearLayout.addView(this.copyView);
        }
        this.collapsedInfo = elementProvider.createCollapsedObjectInfoView((ViewGroup)this.linearLayout);
        this.linearLayout.addView((View)this.collapsedInfo);
    }

    @Override
    public void onBind(JsonObjectCollapsedViewModel jsonObjectCollapsedViewModel) {
        super.onBind(jsonObjectCollapsedViewModel);
        CharSequence key = jsonObjectCollapsedViewModel.getKey(this.keyTextView.getContext());
        if (TextUtils.isEmpty((CharSequence)key)) {
            this.keyTextView.setVisibility(8);
        } else {
            this.keyTextView.setText(key);
            this.keyTextView.setVisibility(0);
        }
        this.collapsedInfo.setText(jsonObjectCollapsedViewModel.getCollapsedInfo(this.collapsedInfo.getContext()));
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v == this.expandView) {
            ((JsonObjectCollapsedViewModel)this.getViewModel()).expand();
        }
    }

    public boolean onLongClick(View v) {
        if (v == this.expandView) {
            ((JsonObjectCollapsedViewModel)this.getViewModel()).expandAll();
            return true;
        }
        return false;
    }
}

