/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.entry;

import com.liuxiangdong.jsonview.ConfigurationProvider;
import com.liuxiangdong.jsonview.OnCopyJsonStringListener;
import com.liuxiangdong.jsonview.entry.JsonEntry;
import com.liuxiangdong.jsonview.entry.JsonParent;
import com.liuxiangdong.jsonview.vm.JsonViewModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class JsonCompoundEntry<T>
extends JsonEntry<T>
implements JsonParent {
    private List<JsonEntry<?>> children;
    private boolean collapsed = true;
    private List<JsonViewModel> collapsedViewModels;
    private OnStateChangeListener onStateChangeListener;
    private OnCopyJsonStringListener onCopyJsonStringListener;
    private ConfigurationProvider provider;

    JsonCompoundEntry(String key, T value, int depth, int index) {
        super(key, value, depth, index);
    }

    void addChild(JsonEntry<?> child) {
        if (child != null) {
            child.setParent(this);
            this.children.add(child);
            if (child instanceof JsonCompoundEntry) {
                JsonCompoundEntry compoundItem = (JsonCompoundEntry)child;
                compoundItem.onStateChangeListener = this.onStateChangeListener;
                compoundItem.onCopyJsonStringListener = this.onCopyJsonStringListener;
                compoundItem.setConfigurationProvider(this.provider);
            }
        }
    }

    public void setConfigurationProvider(ConfigurationProvider provider) {
        this.provider = provider;
        if (provider != null) {
            if (provider.shouldCollapse(this)) {
                this.setCollapsed(true);
            } else {
                this.setCollapsed(false);
            }
        }
    }

    public void setOnStateChangeListener(OnStateChangeListener listener) {
        this.onStateChangeListener = listener;
        if (this.children != null && !this.children.isEmpty()) {
            for (JsonEntry<?> child : this.children) {
                if (!(child instanceof JsonCompoundEntry)) continue;
                ((JsonCompoundEntry)child).setOnStateChangeListener(this.onStateChangeListener);
            }
        }
    }

    public void setOnCopyJsonStringListener(OnCopyJsonStringListener listener) {
        this.onCopyJsonStringListener = listener;
        if (this.children != null && !this.children.isEmpty()) {
            for (JsonEntry<?> child : this.children) {
                if (!(child instanceof JsonCompoundEntry)) continue;
                ((JsonCompoundEntry)child).setOnCopyJsonStringListener(this.onCopyJsonStringListener);
            }
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void copyJsonString() {
        if (this.onCopyJsonStringListener != null) {
            this.onCopyJsonStringListener.onCopy(this.getValue().toString());
        }
    }

    public void expandAll() {
        this.setCollapsedInternal(false);
        boolean notifyStateChange = true;
        if (this.children != null && !this.children.isEmpty()) {
            for (JsonEntry<?> child : this.children) {
                if (!(child instanceof JsonCompoundEntry)) continue;
                ((JsonCompoundEntry)child).expandAll();
                notifyStateChange = false;
            }
        }
        if (notifyStateChange) {
            this.notifyStateChange();
        }
    }

    public void collapseAll() {
        this.setCollapsedInternal(true);
        boolean notifyStateChange = true;
        if (this.children != null && !this.children.isEmpty()) {
            for (JsonEntry<?> child : this.children) {
                if (!(child instanceof JsonCompoundEntry)) continue;
                ((JsonCompoundEntry)child).collapseAll();
                notifyStateChange = false;
            }
        }
        if (notifyStateChange) {
            this.notifyStateChange();
        }
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.setCollapsedInternal(collapsed);
        this.notifyStateChange();
    }

    private void setCollapsedInternal(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        if (!collapsed && this.children == null) {
            this.children = new ArrayList();
            this.inflateChildren();
        }
    }

    private void notifyStateChange() {
        this.invalidateViewModels();
        if (this.onStateChangeListener != null) {
            this.onStateChangeListener.onStateChange();
        }
    }

    protected abstract void inflateChildren();

    @Override
    public void invalidateViewModels() {
        this.viewModels = null;
        if (this.getParent() != null) {
            this.getParent().invalidateViewModels();
        }
    }

    @Override
    public List<JsonViewModel> getViewModels() {
        if (this.collapsed) {
            return this.getCollapsedViewModels();
        }
        return super.getViewModels();
    }

    private List<JsonViewModel> getCollapsedViewModels() {
        if (this.collapsedViewModels == null) {
            this.collapsedViewModels = new ArrayList<JsonViewModel>();
            JsonViewModel viewModel = this.provideCollapsedViewModel();
            if (viewModel != null) {
                this.collapsedViewModels.add(viewModel);
            }
        }
        return Collections.unmodifiableList(this.collapsedViewModels);
    }

    @Override
    protected List<? extends JsonViewModel> provideViewModels() {
        ArrayList<JsonViewModel> result = new ArrayList<JsonViewModel>();
        result.add(this.provideExpandedBeginViewModel());
        for (int i = 0; i < this.children.size(); ++i) {
            result.addAll(this.children.get(i).getViewModels());
        }
        result.add(this.provideExpandedEndViewModel());
        return result;
    }

    public abstract JsonViewModel provideExpandedBeginViewModel();

    public abstract JsonViewModel provideExpandedEndViewModel();

    public abstract JsonViewModel provideCollapsedViewModel();

    public static interface OnStateChangeListener {
        public void onStateChange();
    }
}

