/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.entry;

import com.liuxiangdong.jsonview.entry.JsonCompoundEntry;
import com.liuxiangdong.jsonview.entry.JsonEntry;
import com.liuxiangdong.jsonview.entry.JsonEntryFactory;
import com.liuxiangdong.jsonview.vm.JsonArrayBeginViewModel;
import com.liuxiangdong.jsonview.vm.JsonArrayCollapsedViewModel;
import com.liuxiangdong.jsonview.vm.JsonArrayEndViewModel;
import com.liuxiangdong.jsonview.vm.JsonViewModel;
import org.json.JSONArray;

public class JsonArrayEntry
extends JsonCompoundEntry<JSONArray> {
    public JsonArrayEntry(String key, JSONArray value, int depth, int index) {
        super(key, value, depth, index);
    }

    @Override
    protected void inflateChildren() {
        JSONArray jsonArray = (JSONArray)this.getValue();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JsonEntry<?> child = JsonEntryFactory.createJsonEntry("", jsonArray.opt(i), this.getDepth() + 1, i);
            if (child == null) continue;
            this.addChild(child);
        }
    }

    @Override
    public JsonViewModel provideExpandedBeginViewModel() {
        return new JsonArrayBeginViewModel(this.getKey(), this, this.getDepth(), this.getParentEntryCount(), this.getIndex());
    }

    @Override
    public JsonViewModel provideExpandedEndViewModel() {
        return new JsonArrayEndViewModel(this.getDepth(), this.getParentEntryCount(), this.getIndex());
    }

    @Override
    public JsonViewModel provideCollapsedViewModel() {
        return new JsonArrayCollapsedViewModel(this.getKey(), this, this.getDepth(), this.getParentEntryCount(), this.getIndex());
    }

    @Override
    public int getEntryCount() {
        return ((JSONArray)this.getValue()).length();
    }
}

