/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.liuxiangdong.jsonview.ConfigurationProvider;
import com.liuxiangdong.jsonview.JsonAdapter;
import com.liuxiangdong.jsonview.OnCopyJsonStringListener;
import com.liuxiangdong.jsonview.entry.JsonArrayEntry;
import com.liuxiangdong.jsonview.entry.JsonCompoundEntry;
import com.liuxiangdong.jsonview.entry.JsonObjectEntry;
import com.liuxiangdong.jsonview.vm.JsonViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonView
extends RecyclerView
implements JsonCompoundEntry.OnStateChangeListener {
    private final Collection<JsonViewModel> mViewModels = new ArrayList<JsonViewModel>();
    private JsonCompoundEntry<?> mJsonEntryRoot;
    private OnCopyJsonStringListener mOnCopyJsonStringListener;
    private ConfigurationProvider mConfigurationProvider;

    public JsonView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public JsonView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public JsonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        super.setLayoutManager((RecyclerView.LayoutManager)new HorizontalScrollLinearLayoutManager(context));
    }

    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layout) {
        throw new IllegalStateException("LayoutManager cannot be changed.");
    }

    public void setJson(String jsonString) {
        try {
            JSONTokener tokener = new JSONTokener(jsonString);
            Object object = tokener.nextValue();
            if (object instanceof JSONObject) {
                this.setJsonObject((JSONObject)object);
            } else if (object instanceof JSONArray) {
                this.setJsonArray((JSONArray)object);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void setJsonObject(JSONObject jsonObject) {
        if (jsonObject != null) {
            this.mJsonEntryRoot = new JsonObjectEntry("", jsonObject, 0, 0);
            this.initJsonItemRoot();
        }
    }

    public void setJsonArray(JSONArray jsonArray) {
        if (jsonArray != null) {
            this.mJsonEntryRoot = new JsonArrayEntry("", jsonArray, 0, 0);
            this.initJsonItemRoot();
        }
    }

    private void initJsonItemRoot() {
        this.mJsonEntryRoot.setOnCopyJsonStringListener(this.mOnCopyJsonStringListener);
        this.mJsonEntryRoot.setConfigurationProvider(this.mConfigurationProvider);
        this.mJsonEntryRoot.setOnStateChangeListener(this);
        this.invalidateViewModels();
    }

    public void setOnCopyJsonStringListener(OnCopyJsonStringListener listener) {
        this.mOnCopyJsonStringListener = listener;
        if (this.mJsonEntryRoot != null) {
            this.mJsonEntryRoot.setOnCopyJsonStringListener(this.mOnCopyJsonStringListener);
        }
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.mConfigurationProvider = configurationProvider;
    }

    private void invalidateViewModels() {
        RecyclerView.Adapter adapter;
        List<JsonViewModel> viewModels;
        this.mViewModels.clear();
        if (this.mJsonEntryRoot != null && (viewModels = this.mJsonEntryRoot.getViewModels()) != null && !viewModels.isEmpty()) {
            this.mViewModels.addAll(viewModels);
        }
        if ((adapter = this.getAdapter()) instanceof JsonAdapter) {
            ((JsonAdapter)adapter).setViewModels(this.mViewModels);
            this.requestLayout();
        }
    }

    @Override
    public void onStateChange() {
        this.invalidateViewModels();
    }

    private static class HorizontalScrollLinearLayoutManager
    extends LinearLayoutManager {
        private int mCurrentLeft;

        HorizontalScrollLinearLayoutManager(Context context) {
            super(context);
        }

        public void layoutDecoratedWithMargins(@NonNull View child, int left, int top, int right, int bottom) {
            super.layoutDecoratedWithMargins(child, left, top, right, bottom);
            ViewCompat.offsetLeftAndRight((View)child, (int)(this.mCurrentLeft - child.getLeft()));
        }

        public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
            int childCount = this.getChildCount();
            if (childCount == 0 || dx == 0) {
                return 0;
            }
            int scrolled = 0;
            if (dx > 0) {
                int i;
                int maxRightDiff = 0;
                for (i = 0; i < childCount; ++i) {
                    int rightDiff = this.getChildAt(i).getRight() - this.getWidth();
                    if (rightDiff <= maxRightDiff) continue;
                    maxRightDiff = rightDiff;
                }
                if (maxRightDiff > 0) {
                    scrolled = Math.min(dx, maxRightDiff);
                    for (i = 0; i < childCount; ++i) {
                        ViewCompat.offsetLeftAndRight((View)this.getChildAt(i), (int)(-scrolled));
                    }
                }
            } else {
                int i;
                int minLeft = 0;
                for (i = 0; i < childCount; ++i) {
                    if (this.getChildAt(i).getLeft() >= minLeft) continue;
                    minLeft = this.getChildAt(i).getLeft();
                }
                if (minLeft < 0) {
                    scrolled = Math.max(dx, minLeft);
                    for (i = 0; i < childCount; ++i) {
                        ViewCompat.offsetLeftAndRight((View)this.getChildAt(i), (int)(-scrolled));
                    }
                }
            }
            this.mCurrentLeft = this.getChildAt(0).getLeft();
            return scrolled;
        }

        public boolean canScrollHorizontally() {
            return true;
        }
    }
}

