/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.entry;

import com.liuxiangdong.jsonview.entry.JsonCompoundEntry;
import com.liuxiangdong.jsonview.entry.JsonEntry;
import com.liuxiangdong.jsonview.entry.JsonEntryFactory;
import com.liuxiangdong.jsonview.vm.JsonObjectBeginViewModel;
import com.liuxiangdong.jsonview.vm.JsonObjectCollapsedViewModel;
import com.liuxiangdong.jsonview.vm.JsonObjectEndViewModel;
import com.liuxiangdong.jsonview.vm.JsonViewModel;
import java.util.Iterator;
import org.json.JSONObject;

public class JsonObjectEntry
extends JsonCompoundEntry<JSONObject> {
    public JsonObjectEntry(String key, JSONObject value, int depth, int index) {
        super(key, value, depth, index);
    }

    @Override
    protected void inflateChildren() {
        JSONObject jsonObject = (JSONObject)this.getValue();
        Iterator keys = jsonObject.keys();
        int index = 0;
        while (keys.hasNext()) {
            String k = (String)keys.next();
            JsonEntry<?> child = JsonEntryFactory.createJsonEntry(k, jsonObject.opt(k), this.getDepth() + 1, index);
            if (child != null) {
                this.addChild(child);
            }
            ++index;
        }
    }

    @Override
    public JsonViewModel provideExpandedBeginViewModel() {
        return new JsonObjectBeginViewModel(this.getKey(), this, this.getDepth(), this.getParentEntryCount(), this.getIndex());
    }

    @Override
    public JsonViewModel provideExpandedEndViewModel() {
        return new JsonObjectEndViewModel(this.getDepth(), this.getParentEntryCount(), this.getIndex());
    }

    @Override
    public JsonViewModel provideCollapsedViewModel() {
        return new JsonObjectCollapsedViewModel(this.getKey(), this, this.getDepth(), this.getParentEntryCount(), this.getIndex());
    }

    @Override
    public int getEntryCount() {
        return ((JSONObject)this.getValue()).length();
    }
}

