/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import com.liuxiangdong.jsonview.ConfigurationProvider;
import com.liuxiangdong.jsonview.JsonAdapter;
import com.liuxiangdong.jsonview.OnCopyJsonStringListener;
import com.liuxiangdong.jsonview.entry.JsonArrayEntry;
import com.liuxiangdong.jsonview.entry.JsonCompoundEntry;
import com.liuxiangdong.jsonview.entry.JsonObjectEntry;
import com.liuxiangdong.jsonview.vm.JsonViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonView
extends RecyclerView
implements JsonCompoundEntry.OnStateChangeListener {
    private final Collection<JsonViewModel> mViewModels = new ArrayList<JsonViewModel>();
    private JsonCompoundEntry<?> mJsonEntryRoot;
    private OnCopyJsonStringListener mOnCopyJsonStringListener;
    private ConfigurationProvider mConfigurationProvider;

    public JsonView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public JsonView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public JsonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
    }

    public void setJson(String jsonString) {
        try {
            JSONTokener tokener = new JSONTokener(jsonString);
            Object object = tokener.nextValue();
            if (object instanceof JSONObject) {
                this.setJsonObject((JSONObject)object);
            } else if (object instanceof JSONArray) {
                this.setJsonArray((JSONArray)object);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void setJsonObject(JSONObject jsonObject) {
        if (jsonObject != null) {
            this.mJsonEntryRoot = new JsonObjectEntry("", jsonObject, 0, 0);
            this.initJsonItemRoot();
        }
    }

    public void setJsonArray(JSONArray jsonArray) {
        if (jsonArray != null) {
            this.mJsonEntryRoot = new JsonArrayEntry("", jsonArray, 0, 0);
            this.initJsonItemRoot();
        }
    }

    private void initJsonItemRoot() {
        this.mJsonEntryRoot.setOnCopyJsonStringListener(this.mOnCopyJsonStringListener);
        this.mJsonEntryRoot.setConfigurationProvider(this.mConfigurationProvider);
        this.mJsonEntryRoot.setOnStateChangeListener(this);
        this.invalidateViewModels();
    }

    public void setOnCopyJsonStringListener(OnCopyJsonStringListener listener) {
        this.mOnCopyJsonStringListener = listener;
        if (this.mJsonEntryRoot != null) {
            this.mJsonEntryRoot.setOnCopyJsonStringListener(this.mOnCopyJsonStringListener);
        }
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.mConfigurationProvider = configurationProvider;
    }

    private void invalidateViewModels() {
        RecyclerView.Adapter adapter;
        List<JsonViewModel> viewModels;
        this.mViewModels.clear();
        if (this.mJsonEntryRoot != null && (viewModels = this.mJsonEntryRoot.getViewModels()) != null && !viewModels.isEmpty()) {
            this.mViewModels.addAll(viewModels);
        }
        if ((adapter = this.getAdapter()) instanceof JsonAdapter) {
            ((JsonAdapter)adapter).setViewModels(this.mViewModels);
            this.requestLayout();
        }
    }

    @Override
    public void onStateChange() {
        this.invalidateViewModels();
    }
}

