/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.liuxiangdong.jsonview.R;

public class IndentationView
extends View {
    private Paint paint;
    private int indentation;
    private int depth;

    public IndentationView(Context context) {
        super(context);
        this.init(context);
    }

    public IndentationView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public IndentationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public IndentationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(1.0f);
        this.indentation = context.getResources().getDimensionPixelSize(R.dimen.json_view_indentation);
    }

    public void setLineColor(@ColorInt int color2) {
        this.paint.setColor(color2);
    }

    public void setLineWidth(int width) {
        this.paint.setStrokeWidth((float)width);
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        lp.width = depth * this.indentation;
        this.setLayoutParams(lp);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float startY = 0.0f;
        float stopY = this.getMeasuredHeight();
        float startX = this.paint.getStrokeWidth() / 2.0f;
        for (int i = 0; i < this.depth; ++i) {
            canvas.drawLine(startX, startY, startX, stopY, this.paint);
            startX += (float)this.indentation;
        }
    }
}

