/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.magicprogresswidget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import cn.dreamtobe.percentsmoothhandler.ISmoothTarget;
import cn.dreamtobe.percentsmoothhandler.SmoothHandler;
import com.liulishuo.magicprogresswidget.R;
import java.lang.ref.WeakReference;

public class MagicProgressBar
extends View
implements ISmoothTarget {
    private int fillColor;
    private int backgroundColor;
    private Paint fillPaint;
    private Paint backgroundPaint;
    private float percent;
    private boolean isFlat;
    private SmoothHandler smoothHandler;
    private final RectF rectF = new RectF();

    public MagicProgressBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public MagicProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MagicProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MagicProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        if (context == null || attrs == null) {
            return;
        }
        TypedArray typedArray = null;
        try {
            typedArray = context.obtainStyledAttributes(attrs, R.styleable.MagicProgressBar);
            this.percent = typedArray.getFloat(R.styleable.MagicProgressBar_mpb_percent, 0.0f);
            this.fillColor = typedArray.getColor(R.styleable.MagicProgressBar_mpb_fill_color, 0);
            this.backgroundColor = typedArray.getColor(R.styleable.MagicProgressBar_mpb_background_color, 0);
            this.isFlat = typedArray.getBoolean(R.styleable.MagicProgressBar_mpb_flat, false);
        }
        finally {
            if (typedArray != null) {
                typedArray.recycle();
            }
        }
        this.fillPaint = new Paint();
        this.fillPaint.setColor(this.fillColor);
        this.fillPaint.setAntiAlias(true);
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setColor(this.backgroundColor);
        this.backgroundPaint.setAntiAlias(true);
    }

    public void setFillColor(int fillColor) {
        if (this.fillColor != fillColor) {
            this.fillColor = fillColor;
            this.fillPaint.setColor(fillColor);
            this.invalidate();
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        if (this.backgroundColor != backgroundColor) {
            this.backgroundColor = backgroundColor;
            this.backgroundPaint.setColor(backgroundColor);
            this.invalidate();
        }
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public float getPercent() {
        return this.percent;
    }

    public void setPercent(float percent) {
        percent = Math.min(1.0f, percent);
        percent = Math.max(0.0f, percent);
        if (this.smoothHandler != null) {
            this.smoothHandler.commitPercent(percent);
        }
        if (this.percent != percent) {
            this.percent = percent;
            this.invalidate();
        }
    }

    public void setSmoothPercent(float percent) {
        this.getSmoothHandler().loopSmooth(percent);
    }

    public void setSmoothPercent(float percent, long durationMillis) {
        this.getSmoothHandler().loopSmooth(percent, durationMillis);
    }

    private SmoothHandler getSmoothHandler() {
        if (this.smoothHandler == null) {
            this.smoothHandler = new SmoothHandler(new WeakReference<MagicProgressBar>(this));
        }
        return this.smoothHandler;
    }

    public void setFlat(boolean flat) {
        if (this.isFlat != flat) {
            this.isFlat = flat;
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float drawPercent = this.percent;
        canvas.save();
        int height = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int width = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        float fillWidth = drawPercent * (float)width;
        float radius = (float)height / 2.0f;
        this.rectF.left = 0.0f;
        this.rectF.top = 0.0f;
        this.rectF.right = width;
        this.rectF.bottom = height;
        if (this.backgroundColor != 0) {
            canvas.drawRoundRect(this.rectF, radius, radius, this.backgroundPaint);
        }
        try {
            if (this.fillColor != 0 && fillWidth > 0.0f) {
                if (fillWidth == (float)width) {
                    this.rectF.right = fillWidth;
                    canvas.drawRoundRect(this.rectF, radius, radius, this.fillPaint);
                    return;
                }
                if (this.isFlat) {
                    canvas.save();
                    this.rectF.right = fillWidth > radius ? radius : fillWidth;
                    canvas.clipRect(this.rectF);
                    this.rectF.right = radius * 2.0f;
                    canvas.drawRoundRect(this.rectF, radius, radius, this.fillPaint);
                    canvas.restore();
                    if (fillWidth <= radius) {
                        return;
                    }
                    float leftAreaWidth = (float)width - radius;
                    float centerX = fillWidth > leftAreaWidth ? leftAreaWidth : fillWidth;
                    this.rectF.left = radius;
                    this.rectF.right = centerX;
                    canvas.drawRect(this.rectF, this.fillPaint);
                    if (fillWidth <= leftAreaWidth) {
                        return;
                    }
                    this.rectF.left = leftAreaWidth - radius;
                    this.rectF.right = fillWidth;
                    canvas.clipRect(this.rectF);
                    this.rectF.right = width;
                    canvas.drawArc(this.rectF, -90.0f, 180.0f, true, this.fillPaint);
                } else if (fillWidth <= radius * 2.0f) {
                    this.rectF.right = fillWidth;
                    canvas.clipRect(this.rectF);
                    this.rectF.right = radius * 2.0f;
                    canvas.drawRoundRect(this.rectF, radius, radius, this.fillPaint);
                } else {
                    this.rectF.right = fillWidth;
                    canvas.drawRoundRect(this.rectF, radius, radius, this.fillPaint);
                }
            }
        }
        finally {
            canvas.restore();
        }
    }
}

