/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import android.os.Parcel;
import com.liulishuo.filedownloader.message.IFlowDirectly;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import java.io.Serializable;

public abstract class SmallMessageSnapshot
extends MessageSnapshot {
    SmallMessageSnapshot(int id) {
        super(id);
        this.isLargeFile = false;
    }

    SmallMessageSnapshot(Parcel in) {
        super(in);
    }

    @Override
    public long getLargeTotalBytes() {
        return this.getSmallTotalBytes();
    }

    @Override
    public long getLargeSofarBytes() {
        return this.getSmallSofarBytes();
    }

    public static class PausedSnapshot
    extends PendingMessageSnapshot {
        PausedSnapshot(int id, int sofarBytes, int totalBytes) {
            super(id, sofarBytes, totalBytes);
        }

        @Override
        public byte getStatus() {
            return -2;
        }
    }

    public static class WarnMessageSnapshot
    extends PendingMessageSnapshot
    implements MessageSnapshot.IWarnMessageSnapshot {
        WarnMessageSnapshot(int id, int sofarBytes, int totalBytes) {
            super(id, sofarBytes, totalBytes);
        }

        WarnMessageSnapshot(Parcel in) {
            super(in);
        }

        @Override
        public MessageSnapshot turnToPending() {
            return new PendingMessageSnapshot(this);
        }

        @Override
        public byte getStatus() {
            return -4;
        }
    }

    public static class WarnFlowDirectlySnapshot
    extends WarnMessageSnapshot
    implements IFlowDirectly {
        WarnFlowDirectlySnapshot(int id, int sofarBytes, int totalBytes) {
            super(id, sofarBytes, totalBytes);
        }

        WarnFlowDirectlySnapshot(Parcel in) {
            super(in);
        }
    }

    public static class RetryMessageSnapshot
    extends ErrorMessageSnapshot {
        private final int retryingTimes;

        RetryMessageSnapshot(int id, int sofarBytes, Throwable throwable, int retryingTimes) {
            super(id, sofarBytes, throwable);
            this.retryingTimes = retryingTimes;
        }

        @Override
        public int getRetryingTimes() {
            return this.retryingTimes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.retryingTimes);
        }

        RetryMessageSnapshot(Parcel in) {
            super(in);
            this.retryingTimes = in.readInt();
        }

        @Override
        public byte getStatus() {
            return 5;
        }
    }

    public static class ErrorMessageSnapshot
    extends SmallMessageSnapshot {
        private final int sofarBytes;
        private final Throwable throwable;

        ErrorMessageSnapshot(int id, int sofarBytes, Throwable throwable) {
            super(id);
            this.sofarBytes = sofarBytes;
            this.throwable = throwable;
        }

        @Override
        public int getSmallSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public byte getStatus() {
            return -1;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.sofarBytes);
            dest.writeSerializable((Serializable)this.throwable);
        }

        ErrorMessageSnapshot(Parcel in) {
            super(in);
            this.sofarBytes = in.readInt();
            this.throwable = (Throwable)in.readSerializable();
        }
    }

    public static class CompletedSnapshot
    extends SmallMessageSnapshot {
        private final boolean reusedDownloadedFile;
        private final int totalBytes;

        CompletedSnapshot(int id, boolean reusedDownloadedFile, int totalBytes) {
            super(id);
            this.reusedDownloadedFile = reusedDownloadedFile;
            this.totalBytes = totalBytes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte(this.reusedDownloadedFile ? (byte)1 : 0);
            dest.writeInt(this.totalBytes);
        }

        CompletedSnapshot(Parcel in) {
            super(in);
            this.reusedDownloadedFile = in.readByte() != 0;
            this.totalBytes = in.readInt();
        }

        @Override
        public byte getStatus() {
            return -3;
        }

        @Override
        public int getSmallTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public boolean isReusedDownloadedFile() {
            return this.reusedDownloadedFile;
        }
    }

    public static class CompletedFlowDirectlySnapshot
    extends CompletedSnapshot
    implements IFlowDirectly {
        CompletedFlowDirectlySnapshot(int id, boolean reusedDownloadedFile, int totalBytes) {
            super(id, reusedDownloadedFile, totalBytes);
        }

        CompletedFlowDirectlySnapshot(Parcel in) {
            super(in);
        }
    }

    public static class ProgressMessageSnapshot
    extends SmallMessageSnapshot {
        private final int sofarBytes;

        ProgressMessageSnapshot(int id, int sofarBytes) {
            super(id);
            this.sofarBytes = sofarBytes;
        }

        @Override
        public byte getStatus() {
            return 3;
        }

        @Override
        public int getSmallSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.sofarBytes);
        }

        ProgressMessageSnapshot(Parcel in) {
            super(in);
            this.sofarBytes = in.readInt();
        }
    }

    public static class ConnectedMessageSnapshot
    extends SmallMessageSnapshot {
        private final boolean resuming;
        private final int totalBytes;
        private final String etag;
        private final String fileName;

        ConnectedMessageSnapshot(int id, boolean resuming, int totalBytes, String etag, String fileName) {
            super(id);
            this.resuming = resuming;
            this.totalBytes = totalBytes;
            this.etag = etag;
            this.fileName = fileName;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte(this.resuming ? (byte)1 : 0);
            dest.writeInt(this.totalBytes);
            dest.writeString(this.etag);
            dest.writeString(this.fileName);
        }

        ConnectedMessageSnapshot(Parcel in) {
            super(in);
            this.resuming = in.readByte() != 0;
            this.totalBytes = in.readInt();
            this.etag = in.readString();
            this.fileName = in.readString();
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public byte getStatus() {
            return 2;
        }

        @Override
        public boolean isResuming() {
            return this.resuming;
        }

        @Override
        public int getSmallTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public String getEtag() {
            return this.etag;
        }
    }

    public static class PendingMessageSnapshot
    extends SmallMessageSnapshot {
        private final int sofarBytes;
        private final int totalBytes;

        PendingMessageSnapshot(PendingMessageSnapshot snapshot) {
            this(snapshot.getId(), snapshot.getSmallSofarBytes(), snapshot.getSmallTotalBytes());
        }

        PendingMessageSnapshot(int id, int sofarBytes, int totalBytes) {
            super(id);
            this.sofarBytes = sofarBytes;
            this.totalBytes = totalBytes;
        }

        PendingMessageSnapshot(Parcel in) {
            super(in);
            this.sofarBytes = in.readInt();
            this.totalBytes = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.sofarBytes);
            dest.writeInt(this.totalBytes);
        }

        @Override
        public byte getStatus() {
            return 1;
        }

        @Override
        public int getSmallSofarBytes() {
            return this.sofarBytes;
        }

        @Override
        public int getSmallTotalBytes() {
            return this.totalBytes;
        }
    }
}

