/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.app.ActivityManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.Process;
import android.os.StatFs;
import android.text.TextUtils;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadSecurityException;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileDownloadUtils {
    private static int minProgressStep = 65536;
    private static long minProgressTime = 2000L;
    private static String defaultSaveRootPath;
    private static Boolean isDownloaderProcess;
    private static final String INTERNAL_DOCUMENT_NAME = "filedownloader";
    private static final String OLD_FILE_CONVERTED_FILE_NAME = ".old_file_converted";
    private static Boolean filenameConverted;
    private static final Pattern CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN;
    private static final Pattern CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN;
    private static final String FILEDOWNLOADER_PREFIX = "FileDownloader";

    public static void setMinProgressStep(int minProgressStep) throws IllegalAccessException {
        if (!FileDownloadUtils.isDownloaderProcess(FileDownloadHelper.getAppContext())) {
            throw new IllegalAccessException("This value is used in the :filedownloader process, so set this value in your process is without effect. You can add 'process.non-separate=true' in 'filedownloader.properties' to share the main process to FileDownloadService. Or you can configure this value in 'filedownloader.properties' by 'download.min-progress-step'.");
        }
        FileDownloadUtils.minProgressStep = minProgressStep;
    }

    public static void setMinProgressTime(long minProgressTime) throws IllegalAccessException {
        if (!FileDownloadUtils.isDownloaderProcess(FileDownloadHelper.getAppContext())) {
            throw new IllegalAccessException("This value is used in the :filedownloader process, so set this value in your process is without effect. You can add 'process.non-separate=true' in 'filedownloader.properties' to share the main process to FileDownloadService. Or you can configure this value in 'filedownloader.properties' by 'download.min-progress-time'.");
        }
        FileDownloadUtils.minProgressTime = minProgressTime;
    }

    public static int getMinProgressStep() {
        return minProgressStep;
    }

    public static long getMinProgressTime() {
        return minProgressTime;
    }

    public static boolean isFilenameValid(String filename) {
        return true;
    }

    public static String getDefaultSaveRootPath() {
        if (!TextUtils.isEmpty((CharSequence)defaultSaveRootPath)) {
            return defaultSaveRootPath;
        }
        if (FileDownloadHelper.getAppContext().getExternalCacheDir() == null) {
            return Environment.getDownloadCacheDirectory().getAbsolutePath();
        }
        return FileDownloadHelper.getAppContext().getExternalCacheDir().getAbsolutePath();
    }

    public static String getDefaultSaveFilePath(String url) {
        return FileDownloadUtils.generateFilePath(FileDownloadUtils.getDefaultSaveRootPath(), FileDownloadUtils.generateFileName(url));
    }

    public static String generateFileName(String url) {
        return FileDownloadUtils.md5(url);
    }

    public static String generateFilePath(String directory, String filename) {
        if (filename == null) {
            throw new IllegalStateException("can't generate real path, the file name is null");
        }
        if (directory == null) {
            throw new IllegalStateException("can't generate real path, the directory is null");
        }
        return FileDownloadUtils.formatString("%s%s%s", directory, File.separator, filename);
    }

    public static void setDefaultSaveRootPath(String path) {
        defaultSaveRootPath = path;
    }

    public static String getTempPath(String targetPath) {
        return FileDownloadUtils.formatString("%s.temp", targetPath);
    }

    public static int generateId(String url, String path) {
        return CustomComponentHolder.getImpl().getIdGeneratorInstance().generateId(url, path, false);
    }

    public static int generateId(String url, String path, boolean pathAsDirectory) {
        return CustomComponentHolder.getImpl().getIdGeneratorInstance().generateId(url, path, pathAsDirectory);
    }

    public static String md5(String string2) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string2.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Huh, MD5 should be supported?", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh, UTF-8 should be supported?", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String getStack() {
        return FileDownloadUtils.getStack(true);
    }

    public static String getStack(boolean printLine) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return FileDownloadUtils.getStack(stackTrace, printLine);
    }

    public static String getStack(StackTraceElement[] stackTrace, boolean printLine) {
        if (stackTrace == null || stackTrace.length < 4) {
            return "";
        }
        StringBuilder t = new StringBuilder();
        for (int i = 3; i < stackTrace.length; ++i) {
            if (!stackTrace[i].getClassName().contains("com.liulishuo.filedownloader")) continue;
            t.append("[");
            t.append(stackTrace[i].getClassName().substring("com.liulishuo.filedownloader".length()));
            t.append(":");
            t.append(stackTrace[i].getMethodName());
            if (printLine) {
                t.append("(").append(stackTrace[i].getLineNumber()).append(")]");
                continue;
            }
            t.append("]");
        }
        return t.toString();
    }

    public static boolean isDownloaderProcess(Context context) {
        if (isDownloaderProcess != null) {
            return isDownloaderProcess;
        }
        boolean result = false;
        if (FileDownloadProperties.getImpl().processNonSeparate) {
            result = true;
        } else {
            int pid = Process.myPid();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                FileDownloadLog.w(FileDownloadUtils.class, "fail to get the activity manager!", new Object[0]);
                return false;
            }
            List runningAppProcessInfoList = activityManager.getRunningAppProcesses();
            if (null == runningAppProcessInfoList || runningAppProcessInfoList.isEmpty()) {
                FileDownloadLog.w(FileDownloadUtils.class, "The running app process info list from ActivityManager is null or empty, maybe current App is not running.", new Object[0]);
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo processInfo : runningAppProcessInfoList) {
                if (processInfo.pid != pid) continue;
                result = processInfo.processName.endsWith(":filedownloader");
                break;
            }
        }
        isDownloaderProcess = result;
        return isDownloaderProcess;
    }

    public static String[] convertHeaderString(String nameAndValuesString) {
        String[] lineString = nameAndValuesString.split("\n");
        String[] namesAndValues = new String[lineString.length * 2];
        for (int i = 0; i < lineString.length; ++i) {
            String[] nameAndValue = lineString[i].split(": ");
            namesAndValues[i * 2] = nameAndValue[0];
            namesAndValues[i * 2 + 1] = nameAndValue[1];
        }
        return namesAndValues;
    }

    public static long getFreeSpaceBytes(String path) {
        StatFs statFs = new StatFs(path);
        long freeSpaceBytes = Build.VERSION.SDK_INT >= 18 ? statFs.getAvailableBytes() : (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
        return freeSpaceBytes;
    }

    public static String formatString(String msg, Object ... args) {
        return String.format(Locale.ENGLISH, msg, args);
    }

    public static void markConverted(Context context) {
        File file = FileDownloadUtils.getConvertedMarkedFile(context);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isFilenameConverted(Context context) {
        if (filenameConverted == null) {
            filenameConverted = FileDownloadUtils.getConvertedMarkedFile(context).exists();
        }
        return filenameConverted;
    }

    public static File getConvertedMarkedFile(Context context) {
        return new File(context.getFilesDir().getAbsolutePath() + File.separator + INTERNAL_DOCUMENT_NAME, OLD_FILE_CONVERTED_FILE_NAME);
    }

    public static long parseContentRangeFoInstanceLength(String contentRange) {
        if (contentRange == null) {
            return -1L;
        }
        String[] session = contentRange.split("/");
        if (session.length >= 2) {
            try {
                return Long.parseLong(session[1]);
            }
            catch (NumberFormatException e) {
                FileDownloadLog.w(FileDownloadUtils.class, "parse instance length failed with %s", contentRange);
            }
        }
        return -1L;
    }

    public static String parseContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return null;
        }
        try {
            Matcher m = CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                String charset = m.group(1);
                String encodeFileName = m.group(2);
                return URLDecoder.decode(encodeFileName, charset);
            }
            m = CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (UnsupportedEncodingException | IllegalStateException exception) {
            // empty catch block
        }
        return null;
    }

    public static String getTargetFilePath(String path, boolean pathAsDirectory, String filename) {
        if (path == null) {
            return null;
        }
        if (pathAsDirectory) {
            if (filename == null) {
                return null;
            }
            return FileDownloadUtils.generateFilePath(path, filename);
        }
        return path;
    }

    public static String getParent(String path) {
        int index;
        int length = path.length();
        int firstInPath = 0;
        if (File.separatorChar == '\\' && length > 2 && path.charAt(1) == ':') {
            firstInPath = 2;
        }
        if ((index = path.lastIndexOf(File.separatorChar)) == -1 && firstInPath > 0) {
            index = 2;
        }
        if (index == -1 || path.charAt(length - 1) == File.separatorChar) {
            return null;
        }
        if (path.indexOf(File.separatorChar) == index && path.charAt(firstInPath) == File.separatorChar) {
            return path.substring(0, index + 1);
        }
        return path.substring(0, index);
    }

    public static String getThreadPoolName(String name) {
        return "FileDownloader-" + name;
    }

    public static boolean isNetworkNotOnWifiType() {
        ConnectivityManager manager = (ConnectivityManager)FileDownloadHelper.getAppContext().getSystemService("connectivity");
        if (manager == null) {
            FileDownloadLog.w(FileDownloadUtils.class, "failed to get connectivity manager!", new Object[0]);
            return true;
        }
        NetworkInfo info = manager.getActiveNetworkInfo();
        return info == null || info.getType() != 1;
    }

    public static boolean checkPermission(String permission2) {
        int perm = FileDownloadHelper.getAppContext().checkCallingOrSelfPermission(permission2);
        return perm == 0;
    }

    public static long convertContentLengthString(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static String findEtag(int id, FileDownloadConnection connection) {
        if (connection == null) {
            throw new RuntimeException("connection is null when findEtag");
        }
        String newEtag = connection.getResponseHeaderField("Etag");
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(FileDownloadUtils.class, "etag find %s for task(%d)", newEtag, id);
        }
        return newEtag;
    }

    public static boolean isAcceptRange(int responseCode, FileDownloadConnection connection) {
        if (responseCode == 206 || responseCode == 1) {
            return true;
        }
        String acceptRanges = connection.getResponseHeaderField("Accept-Ranges");
        return "bytes".equals(acceptRanges);
    }

    public static long findInstanceLengthForTrial(FileDownloadConnection connection) {
        long length = FileDownloadUtils.findInstanceLengthFromContentRange(connection);
        if (length < 0L) {
            length = -1L;
            FileDownloadLog.w(FileDownloadUtils.class, "don't get instance length fromContent-Range header", new Object[0]);
        }
        if (length == 0L && FileDownloadProperties.getImpl().trialConnectionHeadMethod) {
            length = -1L;
        }
        return length;
    }

    public static long findInstanceLengthFromContentRange(FileDownloadConnection connection) {
        return FileDownloadUtils.parseContentRangeFoInstanceLength(FileDownloadUtils.getContentRangeHeader(connection));
    }

    private static String getContentRangeHeader(FileDownloadConnection connection) {
        return connection.getResponseHeaderField("Content-Range");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long findContentLength(int id, FileDownloadConnection connection) {
        long contentLength = FileDownloadUtils.convertContentLengthString(connection.getResponseHeaderField("Content-Length"));
        String transferEncoding = connection.getResponseHeaderField("Transfer-Encoding");
        if (contentLength >= 0L) return contentLength;
        if (transferEncoding != null && transferEncoding.equals("chunked")) {
            return -1L;
        }
        boolean bl = false;
        boolean isEncodingChunked = bl;
        if (isEncodingChunked) return -1L;
        if (!FileDownloadProperties.getImpl().httpLenient) throw new FileDownloadGiveUpRetryException("can't know the size of the download file, and its Transfer-Encoding is not Chunked either.\nyou can ignore such exception by add http.lenient=true to the filedownloader.properties");
        contentLength = -1L;
        if (!FileDownloadLog.NEED_LOG) return contentLength;
        FileDownloadLog.d(FileDownloadUtils.class, "%d response header is not legal but HTTP lenient is true, so handle as the case of transfer encoding chunk", id);
        return contentLength;
    }

    public static long findContentLengthFromContentRange(FileDownloadConnection connection) {
        String contentRange = FileDownloadUtils.getContentRangeHeader(connection);
        long contentLength = FileDownloadUtils.parseContentLengthFromContentRange(contentRange);
        if (contentLength < 0L) {
            contentLength = -1L;
        }
        return contentLength;
    }

    public static long parseContentLengthFromContentRange(String contentRange) {
        if (contentRange == null || contentRange.length() == 0) {
            return -1L;
        }
        String pattern = "bytes (\\d+)-(\\d+)/\\d+";
        try {
            Pattern r = Pattern.compile("bytes (\\d+)-(\\d+)/\\d+");
            Matcher m = r.matcher(contentRange);
            if (m.find()) {
                long rangeStart = Long.parseLong(m.group(1));
                long rangeEnd = Long.parseLong(m.group(2));
                return rangeEnd - rangeStart + 1L;
            }
        }
        catch (Exception e) {
            FileDownloadLog.e(FileDownloadUtils.class, e, "parse content length from content range error", new Object[0]);
        }
        return -1L;
    }

    public static String findFilename(FileDownloadConnection connection, String url) throws FileDownloadSecurityException {
        String filename = FileDownloadUtils.parseContentDisposition(connection.getResponseHeaderField("Content-Disposition"));
        if (TextUtils.isEmpty((CharSequence)filename)) {
            filename = FileDownloadUtils.generateFileName(url);
        } else if (filename.contains("../")) {
            throw new FileDownloadSecurityException(FileDownloadUtils.formatString("The filename [%s] from the response is not allowable, because it contains '../', which can raise the directory traversal vulnerability", filename));
        }
        return filename;
    }

    public static FileDownloadOutputStream createOutputStream(String path) throws IOException {
        if (TextUtils.isEmpty((CharSequence)path)) {
            throw new RuntimeException("found invalid internal destination path, empty");
        }
        if (!FileDownloadUtils.isFilenameValid(path)) {
            throw new RuntimeException(FileDownloadUtils.formatString("found invalid internal destination filename %s", path));
        }
        File file = new File(path);
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeException(FileDownloadUtils.formatString("found invalid internal destination path[%s], & path is directory[%B]", path, file.isDirectory()));
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException(FileDownloadUtils.formatString("create new file error  %s", file.getAbsolutePath()));
        }
        return CustomComponentHolder.getImpl().createOutputStream(file);
    }

    public static boolean isBreakpointAvailable(int id, FileDownloadModel model) {
        return FileDownloadUtils.isBreakpointAvailable(id, model, null);
    }

    public static boolean isBreakpointAvailable(int id, FileDownloadModel model, Boolean outputStreamSupportSeek) {
        if (model == null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d model == null", id);
            }
            return false;
        }
        if (model.getTempFilePath() == null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d temp path == null", id);
            }
            return false;
        }
        return FileDownloadUtils.isBreakpointAvailable(id, model, model.getTempFilePath(), outputStreamSupportSeek);
    }

    public static boolean isBreakpointAvailable(int id, FileDownloadModel model, String path, Boolean outputStreamSupportSeek) {
        boolean result = false;
        if (path == null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d path = null", id);
            }
        } else {
            File file = new File(path);
            boolean isExists = file.exists();
            boolean isDirectory = file.isDirectory();
            if (!isExists || isDirectory) {
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d file not suit, exists[%B], directory[%B]", id, isExists, isDirectory);
                }
            } else {
                long fileLength = file.length();
                long currentOffset = model.getSoFar();
                if (model.getConnectionCount() <= 1 && currentOffset == 0L) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d the downloaded-record is zero.", id);
                    }
                } else {
                    long totalLength = model.getTotal();
                    if (fileLength < currentOffset || totalLength != -1L && (fileLength > totalLength || currentOffset >= totalLength)) {
                        if (FileDownloadLog.NEED_LOG) {
                            FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d dirty data fileLength[%d] sofar[%d] total[%d]", id, fileLength, currentOffset, totalLength);
                        }
                    } else if (outputStreamSupportSeek != null && !outputStreamSupportSeek.booleanValue() && totalLength == fileLength) {
                        if (FileDownloadLog.NEED_LOG) {
                            FileDownloadLog.d(FileDownloadUtils.class, "can't continue %d, because of the output stream doesn't support seek, but the task has already pre-allocated, so we only can download it from the very beginning.", id);
                        }
                    } else {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    public static void deleteTaskFiles(String targetFilepath, String tempFilePath) {
        FileDownloadUtils.deleteTempFile(tempFilePath);
        FileDownloadUtils.deleteTargetFile(targetFilepath);
    }

    public static void deleteTempFile(String tempFilePath) {
        File tempFile;
        if (tempFilePath != null && (tempFile = new File(tempFilePath)).exists()) {
            tempFile.delete();
        }
    }

    public static void deleteTargetFile(String targetFilePath) {
        File targetFile;
        if (targetFilePath != null && (targetFile = new File(targetFilePath)).exists()) {
            targetFile.delete();
        }
    }

    public static boolean isNeedSync(long bytesDelta, long timestampDelta) {
        return bytesDelta > (long)FileDownloadUtils.getMinProgressStep() && timestampDelta > FileDownloadUtils.getMinProgressTime();
    }

    public static String defaultUserAgent() {
        return FileDownloadUtils.formatString("FileDownloader/%s", "1.7.5");
    }

    private static boolean isAppOnForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getApplicationContext().getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        if (pm == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT > 19 ? !pm.isInteractive() : !pm.isScreenOn()) {
            return false;
        }
        String packageName = context.getApplicationContext().getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static boolean needMakeServiceForeground(Context context) {
        return Build.VERSION.SDK_INT >= 26 && !FileDownloadUtils.isAppOnForeground(context);
    }

    static {
        filenameConverted = null;
        CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN = Pattern.compile("attachment;\\s*filename\\*\\s*=\\s*\"*([^\"]*)'\\S*'([^\"]*)\"*");
        CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*\"*([^\"\\n]*)\"*");
    }
}

