/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.services.FDServiceSeparateHandler;
import com.liulishuo.filedownloader.services.FDServiceSharedHandler;
import com.liulishuo.filedownloader.services.FileDownloadManager;
import com.liulishuo.filedownloader.services.ForegroundServiceConfig;
import com.liulishuo.filedownloader.services.IFileDownloadServiceHandler;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.lang.ref.WeakReference;

@SuppressLint(value={"Registered"})
public class FileDownloadService
extends Service {
    private IFileDownloadServiceHandler handler;

    public void onCreate() {
        super.onCreate();
        FileDownloadHelper.holdContext((Context)this);
        try {
            FileDownloadUtils.setMinProgressStep(FileDownloadProperties.getImpl().downloadMinProgressStep);
            FileDownloadUtils.setMinProgressTime(FileDownloadProperties.getImpl().downloadMinProgressTime);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        FileDownloadManager manager = new FileDownloadManager();
        this.handler = FileDownloadProperties.getImpl().processNonSeparate ? new FDServiceSharedHandler(new WeakReference<FileDownloadService>(this), manager) : new FDServiceSeparateHandler(new WeakReference<FileDownloadService>(this), manager);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.handler.onStartCommand(intent, flags, startId);
        if (FileDownloadUtils.needMakeServiceForeground((Context)this)) {
            this.makeServiceForeground();
        }
        return 1;
    }

    @TargetApi(value=26)
    private void makeServiceForeground() {
        ForegroundServiceConfig config = CustomComponentHolder.getImpl().getForegroundConfigInstance();
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d((Object)this, "make service foreground: %s", config);
        }
        if (config.isNeedRecreateChannelId()) {
            NotificationChannel notificationChannel = new NotificationChannel(config.getNotificationChannelId(), (CharSequence)config.getNotificationChannelName(), 2);
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            if (notificationManager == null) {
                return;
            }
            notificationManager.createNotificationChannel(notificationChannel);
        }
        this.startForeground(config.getNotificationId(), config.getNotification((Context)this));
    }

    public void onDestroy() {
        this.handler.onDestroy();
        this.stopForeground(true);
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return this.handler.onBind(intent);
    }

    public static class SeparateProcessService
    extends FileDownloadService {
    }

    public static class SharedMainProcessService
    extends FileDownloadService {
    }
}

