/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.text.TextUtils;
import com.liulishuo.filedownloader.IThreadPoolMonitor;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.download.DownloadLaunchRunnable;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.services.FileDownloadThreadPool;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.List;

class FileDownloadManager
implements IThreadPoolMonitor {
    private final FileDownloadDatabase mDatabase;
    private final FileDownloadThreadPool mThreadPool;

    FileDownloadManager() {
        CustomComponentHolder holder = CustomComponentHolder.getImpl();
        this.mDatabase = holder.getDatabaseInstance();
        this.mThreadPool = new FileDownloadThreadPool(holder.getMaxNetworkThreadCount());
    }

    public synchronized void start(String url, String path, boolean pathAsDirectory, int callbackProgressTimes, int callbackProgressMinIntervalMillis, int autoRetryTimes, boolean forceReDownload, FileDownloadHeader header, boolean isWifiRequired) {
        boolean needUpdate2DB;
        String tempFilePath;
        String targetFilePath;
        int dirCaseId;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "request start the task with url(%s) path(%s) isDirectory(%B)", url, path, pathAsDirectory);
        }
        int id = FileDownloadUtils.generateId(url, path, pathAsDirectory);
        FileDownloadModel model = this.mDatabase.find(id);
        List<ConnectionModel> dirConnectionModelList = null;
        if (!pathAsDirectory && model == null && (model = this.mDatabase.find(dirCaseId = FileDownloadUtils.generateId(url, FileDownloadUtils.getParent(path), true))) != null && path.equals(model.getTargetFilePath())) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "task[%d] find model by dirCaseId[%d]", id, dirCaseId);
            }
            dirConnectionModelList = this.mDatabase.findConnectionModel(dirCaseId);
        }
        if (FileDownloadHelper.inspectAndInflowDownloading(id, model, this, true)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "has already started download %d", id);
            }
            return;
        }
        String string2 = targetFilePath = model != null ? model.getTargetFilePath() : FileDownloadUtils.getTargetFilePath(path, pathAsDirectory, null);
        if (FileDownloadHelper.inspectAndInflowDownloaded(id, targetFilePath, forceReDownload, true)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "has already completed downloading %d", id);
            }
            return;
        }
        long sofar = model != null ? model.getSoFar() : 0L;
        String string3 = tempFilePath = model != null ? model.getTempFilePath() : FileDownloadUtils.getTempPath(targetFilePath);
        if (FileDownloadHelper.inspectAndInflowConflictPath(id, sofar, tempFilePath, targetFilePath, this)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "there is an another task with the same target-file-path %d %s", id, targetFilePath);
            }
            if (model != null) {
                this.mDatabase.remove(id);
                this.mDatabase.removeConnections(id);
            }
            return;
        }
        if (model != null && (model.getStatus() == -2 || model.getStatus() == -1 || model.getStatus() == 1 || model.getStatus() == 6 || model.getStatus() == 2)) {
            if (model.getId() != id) {
                this.mDatabase.remove(model.getId());
                this.mDatabase.removeConnections(model.getId());
                model.setId(id);
                model.setPath(path, pathAsDirectory);
                if (dirConnectionModelList != null) {
                    for (ConnectionModel connectionModel : dirConnectionModelList) {
                        connectionModel.setId(id);
                        this.mDatabase.insertConnectionModel(connectionModel);
                    }
                }
                needUpdate2DB = true;
            } else if (!TextUtils.equals((CharSequence)url, (CharSequence)model.getUrl())) {
                model.setUrl(url);
                needUpdate2DB = true;
            } else {
                needUpdate2DB = false;
            }
        } else {
            if (model == null) {
                model = new FileDownloadModel();
            }
            model.setUrl(url);
            model.setPath(path, pathAsDirectory);
            model.setId(id);
            model.setSoFar(0L);
            model.setTotal(0L);
            model.setStatus((byte)1);
            model.setConnectionCount(1);
            needUpdate2DB = true;
        }
        if (needUpdate2DB) {
            this.mDatabase.update(model);
        }
        DownloadLaunchRunnable.Builder builder = new DownloadLaunchRunnable.Builder();
        DownloadLaunchRunnable runnable = builder.setModel(model).setHeader(header).setThreadPoolMonitor(this).setMinIntervalMillis(callbackProgressMinIntervalMillis).setCallbackProgressMaxCount(callbackProgressTimes).setForceReDownload(forceReDownload).setWifiRequired(isWifiRequired).setMaxRetryTimes(autoRetryTimes).build();
        this.mThreadPool.execute(runnable);
    }

    public boolean isDownloading(String url, String path) {
        return this.isDownloading(FileDownloadUtils.generateId(url, path));
    }

    public boolean isDownloading(int id) {
        return this.isDownloading(this.mDatabase.find(id));
    }

    public boolean pause(int id) {
        FileDownloadModel model;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "request pause the task %d", id);
        }
        if ((model = this.mDatabase.find(id)) == null) {
            return false;
        }
        model.setStatus((byte)-2);
        this.mThreadPool.cancel(id);
        return true;
    }

    public void pauseAll() {
        List<Integer> list = this.mThreadPool.getAllExactRunningDownloadIds();
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "pause all tasks %d", list.size());
        }
        for (Integer id : list) {
            this.pause(id);
        }
    }

    public long getSoFar(int id) {
        FileDownloadModel model = this.mDatabase.find(id);
        if (model == null) {
            return 0L;
        }
        int connectionCount = model.getConnectionCount();
        if (connectionCount <= 1) {
            return model.getSoFar();
        }
        List<ConnectionModel> modelList = this.mDatabase.findConnectionModel(id);
        if (modelList == null || modelList.size() != connectionCount) {
            return 0L;
        }
        return ConnectionModel.getTotalOffset(modelList);
    }

    public long getTotal(int id) {
        FileDownloadModel model = this.mDatabase.find(id);
        if (model == null) {
            return 0L;
        }
        return model.getTotal();
    }

    public byte getStatus(int id) {
        FileDownloadModel model = this.mDatabase.find(id);
        if (model == null) {
            return 0;
        }
        return model.getStatus();
    }

    public boolean isIdle() {
        return this.mThreadPool.exactSize() <= 0;
    }

    public synchronized boolean setMaxNetworkThreadCount(int count) {
        return this.mThreadPool.setMaxNetworkThreadCount(count);
    }

    @Override
    public boolean isDownloading(FileDownloadModel model) {
        boolean isDownloading;
        if (model == null) {
            return false;
        }
        boolean isInPool = this.mThreadPool.isInThreadPool(model.getId());
        if (FileDownloadStatus.isOver(model.getStatus())) {
            isDownloading = isInPool;
        } else if (isInPool) {
            isDownloading = true;
        } else {
            FileDownloadLog.e((Object)this, "%d status is[%s](not finish) & but not in the pool", model.getId(), model.getStatus());
            isDownloading = false;
        }
        return isDownloading;
    }

    @Override
    public int findRunningTaskIdBySameTempPath(String tempFilePath, int excludeId) {
        return this.mThreadPool.findRunningTaskIdBySameTempPath(tempFilePath, excludeId);
    }

    public boolean clearTaskData(int id) {
        if (id == 0) {
            FileDownloadLog.w(this, "The task[%d] id is invalid, can't clear it.", id);
            return false;
        }
        if (this.isDownloading(id)) {
            FileDownloadLog.w(this, "The task[%d] is downloading, can't clear it.", id);
            return false;
        }
        this.mDatabase.remove(id);
        this.mDatabase.removeConnections(id);
        return true;
    }

    public void clearAllTaskData() {
        this.mDatabase.clear();
    }
}

