/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.app.Notification;
import android.os.IBinder;
import android.os.RemoteException;
import com.liulishuo.filedownloader.i.IFileDownloadIPCCallback;
import com.liulishuo.filedownloader.i.IFileDownloadIPCService;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.services.BaseFileServiceUIGuard;
import com.liulishuo.filedownloader.services.FileDownloadService;
import com.liulishuo.filedownloader.util.DownloadServiceNotConnectedHelper;

class FileDownloadServiceUIGuard
extends BaseFileServiceUIGuard<FileDownloadServiceCallback, IFileDownloadIPCService> {
    FileDownloadServiceUIGuard() {
        super(FileDownloadService.SeparateProcessService.class);
    }

    @Override
    protected FileDownloadServiceCallback createCallback() {
        return new FileDownloadServiceCallback();
    }

    @Override
    protected IFileDownloadIPCService asInterface(IBinder service) {
        return IFileDownloadIPCService.Stub.asInterface(service);
    }

    @Override
    protected void registerCallback(IFileDownloadIPCService service, FileDownloadServiceCallback fileDownloadServiceCallback) throws RemoteException {
        service.registerCallback(fileDownloadServiceCallback);
    }

    @Override
    protected void unregisterCallback(IFileDownloadIPCService service, FileDownloadServiceCallback fileDownloadServiceCallback) throws RemoteException {
        service.unregisterCallback(fileDownloadServiceCallback);
    }

    @Override
    public boolean start(String url, String path, boolean pathAsDirectory, int callbackProgressTimes, int callbackProgressMinIntervalMillis, int autoRetryTimes, boolean forceReDownload, FileDownloadHeader header, boolean isWifiRequired) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.start(url, path, pathAsDirectory);
        }
        try {
            ((IFileDownloadIPCService)this.getService()).start(url, path, pathAsDirectory, callbackProgressTimes, callbackProgressMinIntervalMillis, autoRetryTimes, forceReDownload, header, isWifiRequired);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean pause(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.pause(id);
        }
        try {
            return ((IFileDownloadIPCService)this.getService()).pause(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isDownloading(String url, String path) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.isDownloading(url, path);
        }
        try {
            return ((IFileDownloadIPCService)this.getService()).checkDownloading(url, path);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public long getSofar(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getSofar(id);
        }
        long val = 0L;
        try {
            val = ((IFileDownloadIPCService)this.getService()).getSofar(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return val;
    }

    @Override
    public long getTotal(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getTotal(id);
        }
        long val = 0L;
        try {
            val = ((IFileDownloadIPCService)this.getService()).getTotal(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return val;
    }

    @Override
    public byte getStatus(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getStatus(id);
        }
        byte status = 0;
        try {
            status = ((IFileDownloadIPCService)this.getService()).getStatus(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return status;
    }

    @Override
    public void pauseAllTasks() {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.pauseAllTasks();
            return;
        }
        try {
            ((IFileDownloadIPCService)this.getService()).pauseAllTasks();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isIdle() {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.isIdle();
        }
        try {
            ((IFileDownloadIPCService)this.getService()).isIdle();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void startForeground(int notificationId, Notification notification) {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.startForeground(notificationId, notification);
            return;
        }
        try {
            ((IFileDownloadIPCService)this.getService()).startForeground(notificationId, notification);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopForeground(boolean removeNotification) {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.stopForeground(removeNotification);
            return;
        }
        try {
            ((IFileDownloadIPCService)this.getService()).stopForeground(removeNotification);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean setMaxNetworkThreadCount(int count) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.setMaxNetworkThreadCount(count);
        }
        try {
            return ((IFileDownloadIPCService)this.getService()).setMaxNetworkThreadCount(count);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean clearTaskData(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.clearTaskData(id);
        }
        try {
            return ((IFileDownloadIPCService)this.getService()).clearTaskData(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void clearAllTaskData() {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.clearAllTaskData();
            return;
        }
        try {
            ((IFileDownloadIPCService)this.getService()).clearAllTaskData();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    protected static class FileDownloadServiceCallback
    extends IFileDownloadIPCCallback.Stub {
        protected FileDownloadServiceCallback() {
        }

        @Override
        public void callback(MessageSnapshot snapshot) throws RemoteException {
            MessageSnapshotFlow.getImpl().inflow(snapshot);
        }
    }
}

