/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.log;

import android.util.Log;

public final class OrmLog {
    public static boolean isPrint = false;
    private static String defaultTag = "OrmLog";

    private OrmLog() {
    }

    public static void setTag(String tag) {
        defaultTag = tag;
    }

    public static int i(Object o) {
        return isPrint && o != null ? Log.i((String)defaultTag, (String)o.toString()) : -1;
    }

    public static int i(String m) {
        return isPrint && m != null ? Log.i((String)defaultTag, (String)m) : -1;
    }

    public static int v(String tag, String msg) {
        return isPrint && msg != null ? Log.v((String)tag, (String)msg) : -1;
    }

    public static int d(String tag, String msg) {
        return isPrint && msg != null ? Log.d((String)tag, (String)msg) : -1;
    }

    public static int i(String tag, String msg) {
        return isPrint && msg != null ? Log.i((String)tag, (String)msg) : -1;
    }

    public static int w(String tag, String msg) {
        return isPrint && msg != null ? Log.w((String)tag, (String)msg) : -1;
    }

    public static int e(String tag, String msg) {
        return isPrint && msg != null ? Log.e((String)tag, (String)msg) : -1;
    }

    public static int v(String tag, Object ... msg) {
        return isPrint ? Log.v((String)tag, (String)OrmLog.getLogMessage(msg)) : -1;
    }

    public static int d(String tag, Object ... msg) {
        return isPrint ? Log.d((String)tag, (String)OrmLog.getLogMessage(msg)) : -1;
    }

    public static int i(String tag, Object ... msg) {
        return isPrint ? Log.i((String)tag, (String)OrmLog.getLogMessage(msg)) : -1;
    }

    public static int w(String tag, Object ... msg) {
        return isPrint ? Log.w((String)tag, (String)OrmLog.getLogMessage(msg)) : -1;
    }

    public static int e(String tag, Object ... msg) {
        return isPrint ? Log.e((String)tag, (String)OrmLog.getLogMessage(msg)) : -1;
    }

    private static String getLogMessage(Object ... msg) {
        if (msg != null && msg.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (Object s : msg) {
                if (s == null) continue;
                sb.append(s.toString());
            }
            return sb.toString();
        }
        return "";
    }

    public static int v(String tag, String msg, Throwable tr) {
        return isPrint && msg != null ? Log.v((String)tag, (String)msg, (Throwable)tr) : -1;
    }

    public static int d(String tag, String msg, Throwable tr) {
        return isPrint && msg != null ? Log.d((String)tag, (String)msg, (Throwable)tr) : -1;
    }

    public static int i(String tag, String msg, Throwable tr) {
        return isPrint && msg != null ? Log.i((String)tag, (String)msg, (Throwable)tr) : -1;
    }

    public static int w(String tag, String msg, Throwable tr) {
        return isPrint && msg != null ? Log.w((String)tag, (String)msg, (Throwable)tr) : -1;
    }

    public static int e(String tag, String msg, Throwable tr) {
        return isPrint && msg != null ? Log.e((String)tag, (String)msg, (Throwable)tr) : -1;
    }

    public static int v(Object tag, String msg) {
        return isPrint ? Log.v((String)tag.getClass().getSimpleName(), (String)msg) : -1;
    }

    public static int d(Object tag, String msg) {
        return isPrint ? Log.d((String)tag.getClass().getSimpleName(), (String)msg) : -1;
    }

    public static int i(Object tag, String msg) {
        return isPrint ? Log.i((String)tag.getClass().getSimpleName(), (String)msg) : -1;
    }

    public static int w(Object tag, String msg) {
        return isPrint ? Log.w((String)tag.getClass().getSimpleName(), (String)msg) : -1;
    }

    public static int e(Object tag, String msg) {
        return isPrint ? Log.e((String)tag.getClass().getSimpleName(), (String)msg) : -1;
    }
}

