/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.db.utils;

import android.annotation.TargetApi;
import android.database.Cursor;
import com.litesuits.orm.db.assit.Checker;
import com.litesuits.orm.db.model.EntityTable;
import com.litesuits.orm.db.model.Property;
import com.litesuits.orm.log.OrmLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DataUtil
implements Serializable {
    public static final String TAG = DataUtil.class.getSimpleName();
    public static final String NULL = " NULL ";
    public static final String INTEGER = " INTEGER ";
    public static final String REAL = " REAL ";
    public static final String TEXT = " TEXT ";
    public static final String BLOB = " BLOB ";
    public static final int FIELD_TYPE_NULL = 0;
    public static final int FIELD_TYPE_LONG = 1;
    public static final int FIELD_TYPE_REAL = 2;
    public static final int FIELD_TYPE_STRING = 3;
    public static final int FIELD_TYPE_BLOB = 4;
    public static final int FIELD_TYPE_DATE = 5;
    public static final int FIELD_TYPE_SERIALIZABLE = 6;
    public static final int CLASS_TYPE_NONE = 0;
    public static final int CLASS_TYPE_STRING = 1;
    public static final int CLASS_TYPE_BOOLEAN = 2;
    public static final int CLASS_TYPE_DOUBLE = 3;
    public static final int CLASS_TYPE_FLOAT = 4;
    public static final int CLASS_TYPE_LONG = 5;
    public static final int CLASS_TYPE_INT = 6;
    public static final int CLASS_TYPE_SHORT = 7;
    public static final int CLASS_TYPE_BYTE = 8;
    public static final int CLASS_TYPE_BYTE_ARRAY = 9;
    public static final int CLASS_TYPE_CHAR = 10;
    public static final int CLASS_TYPE_DATE = 11;
    public static final int CLASS_TYPE_SERIALIZABLE = 12;
    public static final int CLASS_TYPE_UNKNOWN = 13;
    private static final long serialVersionUID = 6668874253056236676L;

    public static int getType(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence || obj instanceof Boolean || obj instanceof Character) {
            return 3;
        }
        if (obj instanceof Float || obj instanceof Double) {
            return 2;
        }
        if (obj instanceof Number) {
            return 1;
        }
        if (obj instanceof Date) {
            return 5;
        }
        if (obj instanceof byte[]) {
            return 4;
        }
        if (obj instanceof Serializable) {
            return 6;
        }
        return 0;
    }

    public static String getSQLDataType(int classType) {
        switch (classType) {
            case 1: 
            case 2: 
            case 10: {
                return TEXT;
            }
            case 3: 
            case 4: {
                return REAL;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                return INTEGER;
            }
        }
        return BLOB;
    }

    public static void injectDataToObject(Cursor c, Object entity, EntityTable table) throws Exception {
        int size = c.getColumnCount();
        block14: for (int i = 0; i < size; ++i) {
            String col = c.getColumnName(i);
            Property p = null;
            if (!Checker.isEmpty(table.pmap)) {
                p = table.pmap.get(col);
            }
            if (p == null && table.key != null && col.equals(table.key.column)) {
                p = table.key;
            }
            if (p == null) {
                if (!OrmLog.isPrint) continue;
                OrmLog.w(TAG, "\u6570\u636e\u5e93\u5b57\u6bb5[" + col + "]\u5df2\u5728\u5b9e\u4f53\u4e2d\u88ab\u79fb\u9664");
                continue;
            }
            Field f = p.field;
            f.setAccessible(true);
            switch (p.classType) {
                case 1: {
                    f.set(entity, c.getString(i));
                    continue block14;
                }
                case 2: {
                    f.set(entity, Boolean.parseBoolean(c.getString(i)));
                    continue block14;
                }
                case 5: {
                    f.set(entity, c.getLong(i));
                    continue block14;
                }
                case 6: {
                    f.set(entity, c.getInt(i));
                    continue block14;
                }
                case 3: {
                    f.set(entity, c.getDouble(i));
                    continue block14;
                }
                case 4: {
                    f.set(entity, Float.valueOf(c.getFloat(i)));
                    continue block14;
                }
                case 7: {
                    f.set(entity, c.getShort(i));
                    continue block14;
                }
                case 8: {
                    if (c.getString(i) == null) continue block14;
                    f.set(entity, Byte.parseByte(c.getString(i)));
                    continue block14;
                }
                case 9: {
                    f.set(entity, c.getBlob(i));
                    continue block14;
                }
                case 10: {
                    String value = c.getString(i);
                    if (Checker.isEmpty(value)) continue block14;
                    f.set(entity, Character.valueOf(value.charAt(0)));
                    continue block14;
                }
                case 11: {
                    Long time = c.getLong(i);
                    if (time == null) continue block14;
                    f.set(entity, new Date(time));
                    continue block14;
                }
                case 12: {
                    byte[] bytes = c.getBlob(i);
                    if (bytes == null) continue block14;
                    f.set(entity, DataUtil.byteToObject(bytes));
                    continue block14;
                }
            }
        }
    }

    public static int getFieldClassType(Field f) {
        Class<?> type = f.getType();
        if (CharSequence.class.isAssignableFrom(type)) {
            return 1;
        }
        if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return 2;
        }
        if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return 3;
        }
        if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return 4;
        }
        if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
            return 5;
        }
        if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            return 6;
        }
        if (Short.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
            return 7;
        }
        if (Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
            return 8;
        }
        if (byte[].class.isAssignableFrom(type) || Byte[].class.isAssignableFrom(type)) {
            return 9;
        }
        if (Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return 10;
        }
        if (Date.class.isAssignableFrom(type)) {
            return 11;
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return 12;
        }
        return 13;
    }

    public static Object byteToObject(byte[] bytes) throws Exception {
        try (ObjectInputStream ois = null;){
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = ois.readObject();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByte(Object obj) throws IOException {
        try (ObjectOutputStream oos = null;){
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static List<?> arrayToList(Object[] array) {
        return Arrays.asList(array);
    }

    public static Object[] arrayToList(Collection<?> coll) {
        return coll.toArray();
    }

    @TargetApi(value=9)
    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    @TargetApi(value=9)
    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }
}

