/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.db.impl;

import android.database.sqlite.SQLiteDatabase;
import com.litesuits.orm.LiteOrm;
import com.litesuits.orm.db.DataBaseConfig;
import com.litesuits.orm.db.TableManager;
import com.litesuits.orm.db.assit.Checker;
import com.litesuits.orm.db.assit.CollSpliter;
import com.litesuits.orm.db.assit.QueryBuilder;
import com.litesuits.orm.db.assit.SQLBuilder;
import com.litesuits.orm.db.assit.SQLStatement;
import com.litesuits.orm.db.assit.WhereBuilder;
import com.litesuits.orm.db.impl.CascadeSQLiteImpl;
import com.litesuits.orm.db.model.ColumnsValue;
import com.litesuits.orm.db.model.ConflictAlgorithm;
import com.litesuits.orm.db.model.EntityTable;
import com.litesuits.orm.log.OrmLog;
import java.util.ArrayList;
import java.util.Collection;

public final class SingleSQLiteImpl
extends LiteOrm {
    public static final String TAG = SingleSQLiteImpl.class.getSimpleName();

    protected SingleSQLiteImpl(LiteOrm dataBase) {
        super(dataBase);
    }

    private SingleSQLiteImpl(DataBaseConfig config) {
        super(config);
    }

    public static synchronized LiteOrm newInstance(DataBaseConfig config) {
        return new SingleSQLiteImpl(config);
    }

    @Override
    public LiteOrm single() {
        return this;
    }

    @Override
    public LiteOrm cascade() {
        if (this.otherDatabase == null) {
            this.otherDatabase = new CascadeSQLiteImpl(this);
        }
        return this.otherDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long save(Object entity) {
        this.acquireReference();
        try {
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            this.mTableManager.checkOrCreateTable(db, entity);
            long l = SQLBuilder.buildReplaceSql(entity).execInsert(db, entity);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int save(Collection<T> collection) {
        this.acquireReference();
        try {
            if (!Checker.isEmpty(collection)) {
                SQLiteDatabase db = this.mHelper.getWritableDatabase();
                T entity = collection.iterator().next();
                this.mTableManager.checkOrCreateTable(db, entity);
                SQLStatement stmt = SQLBuilder.buildReplaceAllSql(entity);
                int n = stmt.execInsertCollection(db, collection);
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    @Override
    public long insert(Object entity) {
        OrmLog.i("insert entity " + entity);
        return this.insert(entity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Object entity, ConflictAlgorithm conflictAlgorithm) {
        OrmLog.i("insert ");
        this.acquireReference();
        try {
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            OrmLog.i("db " + db);
            this.mTableManager.checkOrCreateTable(db, entity);
            long insert = SQLBuilder.buildInsertSql(entity, conflictAlgorithm).execInsert(db, entity);
            OrmLog.i("insert " + insert);
            long l = insert;
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            OrmLog.e(e.getMessage(), new Object[0]);
        }
        finally {
            this.releaseReference();
        }
        return -1L;
    }

    @Override
    public <T> int insert(Collection<T> collection) {
        return this.insert(collection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int insert(Collection<T> collection, ConflictAlgorithm conflictAlgorithm) {
        this.acquireReference();
        try {
            if (!Checker.isEmpty(collection)) {
                SQLiteDatabase db = this.mHelper.getWritableDatabase();
                T entity = collection.iterator().next();
                SQLStatement stmt = SQLBuilder.buildInsertAllSql(entity, conflictAlgorithm);
                this.mTableManager.checkOrCreateTable(db, entity);
                int n = stmt.execInsertCollection(db, collection);
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    @Override
    public int update(Object entity) {
        return this.update(entity, null, null);
    }

    @Override
    public int update(Object entity, ConflictAlgorithm conflictAlgorithm) {
        return this.update(entity, null, conflictAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(Object entity, ColumnsValue cvs, ConflictAlgorithm conflictAlgorithm) {
        this.acquireReference();
        try {
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            this.mTableManager.checkOrCreateTable(db, entity);
            int n = SQLBuilder.buildUpdateSql(entity, cvs, conflictAlgorithm).execUpdate(db);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    @Override
    public <T> int update(Collection<T> collection) {
        return this.update(collection, null, null);
    }

    @Override
    public <T> int update(Collection<T> collection, ConflictAlgorithm conflictAlgorithm) {
        return this.update(collection, null, conflictAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int update(Collection<T> collection, ColumnsValue cvs, ConflictAlgorithm conflictAlgorithm) {
        this.acquireReference();
        try {
            if (!Checker.isEmpty(collection)) {
                SQLiteDatabase db = this.mHelper.getWritableDatabase();
                T entity = collection.iterator().next();
                this.mTableManager.checkOrCreateTable(db, entity);
                SQLStatement stmt = SQLBuilder.buildUpdateAllSql(entity, cvs, conflictAlgorithm);
                int n = stmt.execUpdateCollection(db, collection, cvs);
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Object entity) {
        EntityTable table = TableManager.getTable(entity);
        if (this.mTableManager.isSQLTableCreated(table.name)) {
            this.acquireReference();
            try {
                SQLiteDatabase db = this.mHelper.getWritableDatabase();
                int n = SQLBuilder.buildDeleteSql(entity).execDelete(db);
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.releaseReference();
            }
        }
        return -1;
    }

    @Override
    public <T> int delete(Class<T> claxx) {
        return this.deleteAll(claxx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int delete(Collection<T> collection) {
        block8: {
            this.acquireReference();
            try {
                int rows;
                if (Checker.isEmpty(collection)) break block8;
                EntityTable table = TableManager.getTable(collection.iterator().next());
                if (!this.mTableManager.isSQLTableCreated(table.name)) break block8;
                final SQLiteDatabase db = this.mHelper.getWritableDatabase();
                db.beginTransaction();
                try {
                    rows = CollSpliter.split(collection, 999, new CollSpliter.Spliter<T>(){

                        @Override
                        public int oneSplit(ArrayList<T> list) throws Exception {
                            return SQLBuilder.buildDeleteSql(list).execDeleteCollection(db, list);
                        }
                    });
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
                int n = rows;
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.releaseReference();
            }
        }
        return -1;
    }

    @Override
    @Deprecated
    public <T> int delete(Class<T> claxx, WhereBuilder where) {
        return this.delete(where);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(WhereBuilder where) {
        EntityTable table = TableManager.getTable(where.getTableClass(), false);
        if (this.mTableManager.isSQLTableCreated(table.name)) {
            this.acquireReference();
            try {
                SQLiteDatabase db = this.mHelper.getWritableDatabase();
                int n = where.createStatementDelete().execDelete(db);
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.releaseReference();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int deleteAll(Class<T> claxx) {
        EntityTable table = TableManager.getTable(claxx, false);
        if (this.mTableManager.isSQLTableCreated(table.name)) {
            this.acquireReference();
            try {
                SQLiteDatabase db = this.mHelper.getWritableDatabase();
                SQLStatement stmt = SQLBuilder.buildDeleteAllSql(claxx);
                int n = stmt.execDelete(db);
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.releaseReference();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int delete(Class<T> claxx, long start, long end, String orderAscColumn) {
        EntityTable table = TableManager.getTable(claxx, false);
        if (this.mTableManager.isSQLTableCreated(table.name)) {
            this.acquireReference();
            try {
                if (start < 0L || end < start) {
                    throw new RuntimeException("start must >=0 and smaller than end");
                }
                if (start != 0L) {
                    --start;
                }
                end = end == Integer.MAX_VALUE ? -1L : end - start;
                SQLStatement stmt = SQLBuilder.buildDeleteSql(claxx, start, end, orderAscColumn);
                SQLiteDatabase db = this.mHelper.getWritableDatabase();
                int n = stmt.execDelete(db);
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.releaseReference();
            }
        }
        return -1;
    }

    @Override
    public <T> ArrayList<T> query(Class<T> claxx) {
        return this.query(new QueryBuilder<T>(claxx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ArrayList<T> query(QueryBuilder<T> qb) {
        EntityTable table = TableManager.getTable(qb.getQueryClass(), false);
        if (this.mTableManager.isSQLTableCreated(table.name)) {
            this.acquireReference();
            try {
                ArrayList<T> arrayList = qb.createStatement().query(this.mHelper.getReadableDatabase(), qb.getQueryClass());
                return arrayList;
            }
            finally {
                this.releaseReference();
            }
        }
        return new ArrayList();
    }

    @Override
    public <T> T queryById(long id, Class<T> claxx) {
        return this.queryById(String.valueOf(id), claxx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T queryById(String id, Class<T> claxx) {
        EntityTable table = TableManager.getTable(claxx, false);
        if (this.mTableManager.isSQLTableCreated(table.name)) {
            this.acquireReference();
            try {
                SQLStatement stmt = new QueryBuilder<T>(claxx).where(table.key.column + "=?", id).createStatement();
                ArrayList<T> list = stmt.query(this.mHelper.getReadableDatabase(), claxx);
                if (!Checker.isEmpty(list)) {
                    T t = list.get(0);
                    return t;
                }
            }
            finally {
                this.releaseReference();
            }
        }
        return null;
    }
}

