/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.db.impl;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.litesuits.orm.LiteOrm;
import com.litesuits.orm.db.DataBaseConfig;
import com.litesuits.orm.db.TableManager;
import com.litesuits.orm.db.assit.Checker;
import com.litesuits.orm.db.assit.Querier;
import com.litesuits.orm.db.assit.QueryBuilder;
import com.litesuits.orm.db.assit.SQLBuilder;
import com.litesuits.orm.db.assit.SQLStatement;
import com.litesuits.orm.db.assit.Transaction;
import com.litesuits.orm.db.assit.WhereBuilder;
import com.litesuits.orm.db.impl.SingleSQLiteImpl;
import com.litesuits.orm.db.model.ColumnsValue;
import com.litesuits.orm.db.model.ConflictAlgorithm;
import com.litesuits.orm.db.model.EntityTable;
import com.litesuits.orm.db.model.MapProperty;
import com.litesuits.orm.db.model.Property;
import com.litesuits.orm.db.model.RelationKey;
import com.litesuits.orm.db.utils.ClassUtil;
import com.litesuits.orm.db.utils.DataUtil;
import com.litesuits.orm.db.utils.FieldUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class CascadeSQLiteImpl
extends LiteOrm {
    public static final String TAG = CascadeSQLiteImpl.class.getSimpleName();
    public static final int TYPE_INSERT = 1;
    public static final int TYPE_UPDATE = 2;
    public static final int TYPE_DELETE = 3;

    protected CascadeSQLiteImpl(LiteOrm dataBase) {
        super(dataBase);
    }

    private CascadeSQLiteImpl(DataBaseConfig config) {
        super(config);
    }

    public static synchronized LiteOrm newInstance(DataBaseConfig config) {
        return new CascadeSQLiteImpl(config);
    }

    public static Object[] getDeleteStatementArgs(Object entity) throws IllegalAccessException {
        EntityTable table = TableManager.getTable(entity);
        if (table.key != null) {
            return new String[]{String.valueOf(FieldUtil.get(table.key.field, entity))};
        }
        if (!Checker.isEmpty(table.pmap)) {
            Object[] args = new Object[table.pmap.size()];
            int i = 0;
            for (Property p : table.pmap.values()) {
                args[i++] = FieldUtil.get(p.field, entity);
            }
            return args;
        }
        return null;
    }

    @Override
    public LiteOrm single() {
        if (this.otherDatabase == null) {
            this.otherDatabase = new SingleSQLiteImpl(this);
        }
        return this.otherDatabase;
    }

    @Override
    public LiteOrm cascade() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long save(final Object entity) {
        this.acquireReference();
        try {
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            Long rowID = Transaction.execute(db, new Transaction.Worker<Long>(){

                @Override
                public Long doTransaction(SQLiteDatabase db) throws Exception {
                    HashMap handleMap = new HashMap();
                    return CascadeSQLiteImpl.this.checkTableAndSaveRecursive(entity, db, handleMap);
                }
            });
            long l = rowID == null ? -1L : rowID;
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    @Override
    public <T> int save(Collection<T> collection) {
        this.acquireReference();
        try {
            int n = this.saveCollection(collection);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    @Override
    public long insert(Object entity) {
        return this.insert(entity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(final Object entity, final ConflictAlgorithm conflictAlgorithm) {
        this.acquireReference();
        try {
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            Long rowID = Transaction.execute(db, new Transaction.Worker<Long>(){

                @Override
                public Long doTransaction(SQLiteDatabase db) throws Exception {
                    CascadeSQLiteImpl.this.mTableManager.checkOrCreateTable(db, entity);
                    return CascadeSQLiteImpl.this.insertRecursive(SQLBuilder.buildInsertSql(entity, conflictAlgorithm), entity, db, new HashMap());
                }
            });
            long l = rowID == null ? -1L : rowID;
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1L;
    }

    @Override
    public <T> int insert(Collection<T> collection) {
        return this.insert(collection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int insert(Collection<T> collection, ConflictAlgorithm conflictAlgorithm) {
        this.acquireReference();
        try {
            int n = this.insertCollection(collection, conflictAlgorithm);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    @Override
    public int update(Object entity) {
        return this.update(entity, null, null);
    }

    @Override
    public int update(Object entity, ConflictAlgorithm conflictAlgorithm) {
        return this.update(entity, null, conflictAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(final Object entity, final ColumnsValue cvs, final ConflictAlgorithm conflictAlgorithm) {
        this.acquireReference();
        try {
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            Integer rowID = Transaction.execute(db, new Transaction.Worker<Integer>(){

                @Override
                public Integer doTransaction(SQLiteDatabase db) throws Exception {
                    HashMap handleMap = new HashMap();
                    SQLStatement stmt = SQLBuilder.buildUpdateSql(entity, cvs, conflictAlgorithm);
                    CascadeSQLiteImpl.this.mTableManager.checkOrCreateTable(db, entity);
                    return CascadeSQLiteImpl.this.updateRecursive(stmt, entity, db, handleMap);
                }
            });
            int n = rowID == null ? -1 : rowID;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    @Override
    public <T> int update(Collection<T> collection) {
        return this.update(collection, null, null);
    }

    @Override
    public <T> int update(Collection<T> collection, ConflictAlgorithm conflictAlgorithm) {
        return this.update(collection, null, conflictAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int update(Collection<T> collection, ColumnsValue cvs, ConflictAlgorithm conflictAlgorithm) {
        this.acquireReference();
        try {
            int n = this.updateCollection(collection, cvs, conflictAlgorithm);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(final Object entity) {
        this.acquireReference();
        try {
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            Integer rowID = Transaction.execute(db, new Transaction.Worker<Integer>(){

                @Override
                public Integer doTransaction(SQLiteDatabase db) throws Exception {
                    HashMap handleMap = new HashMap();
                    return CascadeSQLiteImpl.this.checkTableAndDeleteRecursive(entity, db, handleMap);
                }
            });
            if (rowID != null) {
                int n = rowID;
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    @Override
    public <T> int delete(Class<T> claxx) {
        return this.deleteAll(claxx);
    }

    @Override
    public <T> int delete(Collection<T> collection) {
        this.acquireReference();
        try {
            int n = this.deleteCollectionIfTableHasCreated(collection);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int delete(Class<T> claxx, WhereBuilder where) {
        this.acquireReference();
        try {
            EntityTable table = TableManager.getTable(claxx);
            ArrayList<T> list = this.query(QueryBuilder.create(claxx).columns(new String[]{table.key.column}).where(where));
            this.delete(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(WhereBuilder where) {
        this.acquireReference();
        try {
            EntityTable table = TableManager.getTable(where.getTableClass());
            ArrayList list = this.query(QueryBuilder.create(where.getTableClass()).columns(new String[]{table.key.column}).where(where));
            this.deleteCollectionIfTableHasCreated(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int deleteAll(Class<T> claxx) {
        this.acquireReference();
        try {
            EntityTable table = TableManager.getTable(claxx);
            ArrayList<T> list = this.query(QueryBuilder.create(claxx).columns(new String[]{table.key.column}));
            int n = this.delete(list);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int delete(Class<T> claxx, long start, long end, String orderAscColumn) {
        this.acquireReference();
        try {
            if (start < 0L || end < start) {
                throw new RuntimeException("start must >=0 and smaller than end");
            }
            if (start != 0L) {
                --start;
            }
            end = end == Integer.MAX_VALUE ? -1L : end - start;
            EntityTable table = TableManager.getTable(claxx);
            ArrayList<T> list = this.query(QueryBuilder.create(claxx).limit(start + "," + end).appendOrderAscBy(orderAscColumn).columns(new String[]{table.key.column}));
            int n = this.delete(list);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    @Override
    public <T> ArrayList<T> query(Class<T> claxx) {
        return this.checkTableAndQuery(claxx, new QueryBuilder<T>(claxx));
    }

    @Override
    public <T> ArrayList<T> query(QueryBuilder<T> qb) {
        return this.checkTableAndQuery(qb.getQueryClass(), qb);
    }

    @Override
    public <T> T queryById(long id, Class<T> claxx) {
        return this.queryById(String.valueOf(id), claxx);
    }

    @Override
    public <T> T queryById(String id, Class<T> claxx) {
        EntityTable table = TableManager.getTable(claxx);
        ArrayList<T> list = this.checkTableAndQuery(claxx, new QueryBuilder<T>(claxx).whereEquals(table.key.column, String.valueOf(id)));
        if (!Checker.isEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ArrayList<T> checkTableAndQuery(final Class<T> claxx, QueryBuilder builder) {
        this.acquireReference();
        final ArrayList list = new ArrayList();
        try {
            final EntityTable table = TableManager.getTable(claxx, false);
            if (this.mTableManager.isSQLTableCreated(table.name)) {
                final HashMap<String, Object> entityMap = new HashMap<String, Object>();
                HashMap<String, Integer> queryMap = new HashMap<String, Integer>();
                SQLiteDatabase db = this.mHelper.getReadableDatabase();
                Querier.doQuery(db, builder.createStatement(), new Querier.CursorParser(){

                    @Override
                    public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                        Object t = ClassUtil.newInstance(claxx);
                        DataUtil.injectDataToObject(c, t, table);
                        list.add(t);
                        entityMap.put(table.name + FieldUtil.get(table.key.field, t), t);
                    }
                });
                for (Object t : list) {
                    this.queryForMappingRecursive(t, db, queryMap, entityMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return list;
    }

    private void queryForMappingRecursive(Object obj1, SQLiteDatabase db, HashMap<String, Integer> queryMap, HashMap<String, Object> entityMap) throws IllegalAccessException, InstantiationException {
        EntityTable table1 = TableManager.getTable(obj1);
        Object key1 = FieldUtil.getAssignedKeyObject(table1.key, obj1);
        String key = table1.name + key1;
        if (queryMap.get(key) == null) {
            queryMap.put(key, 1);
            if (table1.mappingList != null) {
                for (MapProperty mp : table1.mappingList) {
                    if (mp.isToOne()) {
                        this.queryMapToOne(table1, key1, obj1, mp.field, db, queryMap, entityMap);
                        continue;
                    }
                    if (!mp.isToMany()) continue;
                    this.queryMapToMany(table1, key1, obj1, mp.field, db, queryMap, entityMap);
                }
            }
        }
    }

    private void queryMapToOne(final EntityTable table1, Object key1, Object obj1, Field field, SQLiteDatabase db, HashMap<String, Integer> queryMap, HashMap<String, Object> entityMap) throws IllegalAccessException, InstantiationException {
        final EntityTable table2 = TableManager.getTable(field.getType());
        if (this.mTableManager.isSQLMapTableCreated(table1.name, table2.name)) {
            SQLStatement relationSql = SQLBuilder.buildQueryRelationSql(table1, table2, key1);
            final RelationKey relation = new RelationKey();
            Querier.doQuery(db, relationSql, new Querier.CursorParser(){

                @Override
                public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                    relation.key1 = c.getString(c.getColumnIndex(table1.name));
                    relation.key2 = c.getString(c.getColumnIndex(table2.name));
                    this.stopParse();
                }
            });
            if (relation.isOK()) {
                String key = table2.name + relation.key2;
                Object obj2 = entityMap.get(key);
                if (obj2 == null) {
                    SQLStatement entitySql = SQLBuilder.buildQueryMapEntitySql(table2, relation.key2);
                    obj2 = entitySql.queryOneEntity(db, table2.claxx);
                    entityMap.put(key, obj2);
                }
                if (obj2 != null) {
                    FieldUtil.set(field, obj1, obj2);
                    this.queryForMappingRecursive(obj2, db, queryMap, entityMap);
                }
            }
        }
    }

    private void queryMapToMany(EntityTable table1, Object key1, Object obj1, Field field, SQLiteDatabase db, HashMap<String, Integer> queryMap, final HashMap<String, Object> entityMap) throws IllegalAccessException, InstantiationException {
        Class<?> class2;
        if (Collection.class.isAssignableFrom(field.getType())) {
            class2 = FieldUtil.getGenericType(field);
        } else if (field.getType().isArray()) {
            class2 = FieldUtil.getComponentType(field);
        } else {
            throw new RuntimeException("OneToMany and ManyToMany Relation, you must use collection or array object");
        }
        final EntityTable table2 = TableManager.getTable(class2);
        if (this.mTableManager.isSQLMapTableCreated(table1.name, table2.name)) {
            SQLStatement relationSql = SQLBuilder.buildQueryRelationSql(table1, table2, key1);
            final ArrayList key2List = new ArrayList();
            Querier.doQuery(db, relationSql, new Querier.CursorParser(){

                @Override
                public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                    key2List.add(c.getString(c.getColumnIndex(table2.name)));
                }
            });
            if (!Checker.isEmpty(key2List)) {
                int i;
                final ArrayList<Object> allList2 = new ArrayList<Object>();
                for (i = key2List.size() - 1; i >= 0; --i) {
                    Object obj2 = entityMap.get(table2.name + (String)key2List.get(i));
                    if (obj2 == null) continue;
                    allList2.add(obj2);
                    key2List.remove(i);
                }
                i = 0;
                int start = 0;
                while (start < key2List.size()) {
                    int next = ++i * 999;
                    int end = Math.min(key2List.size(), next);
                    List list = key2List.subList(start, end);
                    start = next;
                    SQLStatement entitySql = QueryBuilder.create(class2).whereIn(table2.key.column, list.toArray(new String[list.size()])).createStatement();
                    Querier.doQuery(db, entitySql, new Querier.CursorParser(){

                        @Override
                        public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                            Object t = ClassUtil.newInstance(class2);
                            DataUtil.injectDataToObject(c, t, table2);
                            allList2.add(t);
                            entityMap.put(table2.name + FieldUtil.get(table2.key.field, t), t);
                        }
                    });
                }
                if (!Checker.isEmpty(allList2)) {
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        Collection coll = (Collection)ClassUtil.newCollectionForField(field);
                        coll.addAll(allList2);
                        FieldUtil.set(field, obj1, coll);
                    } else if (field.getType().isArray()) {
                        Object[] arrObj = (Object[])ClassUtil.newArray(class2, allList2.size());
                        arrObj = allList2.toArray(arrObj);
                        FieldUtil.set(field, obj1, arrObj);
                    } else {
                        throw new RuntimeException("OneToMany and ManyToMany Relation, you must use collection or array object");
                    }
                    for (Object e : allList2) {
                        this.queryForMappingRecursive(e, db, queryMap, entityMap);
                    }
                }
            }
        }
    }

    private <T> int saveCollection(final Collection<T> collection) {
        SQLiteDatabase db;
        Integer rowID;
        if (!Checker.isEmpty(collection) && (rowID = Transaction.execute(db = this.mHelper.getWritableDatabase(), new Transaction.Worker<Integer>(){

            @Override
            public Integer doTransaction(SQLiteDatabase db) throws Exception {
                HashMap handleMap = new HashMap();
                Iterator iterator = collection.iterator();
                Object entity = iterator.next();
                SQLStatement stmt = SQLBuilder.buildReplaceSql(entity);
                CascadeSQLiteImpl.this.mTableManager.checkOrCreateTable(db, entity);
                CascadeSQLiteImpl.this.insertRecursive(stmt, entity, db, handleMap);
                while (iterator.hasNext()) {
                    entity = iterator.next();
                    stmt.bindArgs = SQLBuilder.buildInsertSqlArgsOnly(entity);
                    CascadeSQLiteImpl.this.insertRecursive(stmt, entity, db, handleMap);
                }
                return collection.size();
            }
        })) != null) {
            return rowID;
        }
        return -1;
    }

    private <T> int insertCollection(final Collection<T> collection, final ConflictAlgorithm conflictAlgorithm) {
        SQLiteDatabase db;
        Integer rowID;
        if (!Checker.isEmpty(collection) && (rowID = Transaction.execute(db = this.mHelper.getWritableDatabase(), new Transaction.Worker<Integer>(){

            @Override
            public Integer doTransaction(SQLiteDatabase db) throws Exception {
                HashMap handleMap = new HashMap();
                Iterator iterator = collection.iterator();
                Object entity = iterator.next();
                SQLStatement stmt = SQLBuilder.buildInsertSql(entity, conflictAlgorithm);
                CascadeSQLiteImpl.this.mTableManager.checkOrCreateTable(db, entity);
                CascadeSQLiteImpl.this.insertRecursive(stmt, entity, db, handleMap);
                while (iterator.hasNext()) {
                    entity = iterator.next();
                    stmt.bindArgs = SQLBuilder.buildInsertSqlArgsOnly(entity);
                    CascadeSQLiteImpl.this.insertRecursive(stmt, entity, db, handleMap);
                }
                return collection.size();
            }
        })) != null) {
            return rowID;
        }
        return -1;
    }

    private <T> int updateCollection(final Collection<T> collection, final ColumnsValue cvs, final ConflictAlgorithm conflictAlgorithm) {
        SQLiteDatabase db;
        Integer rowID;
        if (!Checker.isEmpty(collection) && (rowID = Transaction.execute(db = this.mHelper.getWritableDatabase(), new Transaction.Worker<Integer>(){

            @Override
            public Integer doTransaction(SQLiteDatabase db) throws Exception {
                HashMap handleMap = new HashMap();
                Iterator iterator = collection.iterator();
                Object entity = iterator.next();
                SQLStatement stmt = SQLBuilder.buildUpdateSql(entity, cvs, conflictAlgorithm);
                CascadeSQLiteImpl.this.mTableManager.checkOrCreateTable(db, entity);
                CascadeSQLiteImpl.this.updateRecursive(stmt, entity, db, handleMap);
                while (iterator.hasNext()) {
                    entity = iterator.next();
                    stmt.bindArgs = SQLBuilder.buildUpdateSqlArgsOnly(entity, cvs);
                    CascadeSQLiteImpl.this.updateRecursive(stmt, entity, db, handleMap);
                }
                return collection.size();
            }
        })) != null) {
            return rowID;
        }
        return -1;
    }

    private <T> int deleteCollectionIfTableHasCreated(final Collection<T> collection) {
        if (!Checker.isEmpty(collection)) {
            SQLiteDatabase db;
            Integer rowID;
            final Iterator<T> iterator = collection.iterator();
            final T entity = iterator.next();
            EntityTable table = TableManager.getTable(entity);
            if (this.mTableManager.isSQLTableCreated(table.name) && (rowID = Transaction.execute(db = this.mHelper.getWritableDatabase(), new Transaction.Worker<Integer>(){

                @Override
                public Integer doTransaction(SQLiteDatabase db) throws Exception {
                    HashMap handleMap = new HashMap();
                    SQLStatement stmt = SQLBuilder.buildDeleteSql(entity);
                    CascadeSQLiteImpl.this.deleteRecursive(stmt, entity, db, handleMap);
                    while (iterator.hasNext()) {
                        Object next = iterator.next();
                        stmt.bindArgs = CascadeSQLiteImpl.getDeleteStatementArgs(next);
                        CascadeSQLiteImpl.this.deleteRecursive(stmt, next, db, handleMap);
                    }
                    return collection.size();
                }
            })) != null) {
                return rowID;
            }
        }
        return -1;
    }

    private long handleEntityRecursive(int type, SQLStatement stmt, Object obj1, SQLiteDatabase db, HashMap<String, Integer> handleMap) throws Exception {
        EntityTable table1 = TableManager.getTable(obj1);
        Object key1 = FieldUtil.get(table1.key.field, obj1);
        if (handleMap.get(table1.name + key1) != null) {
            return -1L;
        }
        long rowID = -1L;
        switch (type) {
            case 1: {
                rowID = stmt.execInsert(db, obj1);
                key1 = FieldUtil.get(table1.key.field, obj1);
                break;
            }
            case 2: {
                rowID = stmt.execUpdate(db);
                break;
            }
            case 3: {
                rowID = stmt.execDelete(db);
                break;
            }
        }
        handleMap.put(table1.name + key1, 1);
        boolean insertNew = type != 3;
        this.handleMapping(key1, obj1, db, insertNew, handleMap);
        return rowID;
    }

    private int updateRecursive(SQLStatement stmt, Object obj1, SQLiteDatabase db, HashMap<String, Integer> handleMap) throws Exception {
        EntityTable table1 = TableManager.getTable(obj1);
        Object key1 = FieldUtil.get(table1.key.field, obj1);
        if (handleMap.get(table1.name + key1) != null) {
            return -1;
        }
        int rowID = stmt.execUpdate(db);
        key1 = FieldUtil.get(table1.key.field, obj1);
        handleMap.put(table1.name + key1, 1);
        this.handleMapping(key1, obj1, db, true, handleMap);
        return rowID;
    }

    private int deleteRecursive(SQLStatement stmt, Object obj1, SQLiteDatabase db, HashMap<String, Integer> handleMap) throws Exception {
        EntityTable table1 = TableManager.getTable(obj1);
        Object key1 = FieldUtil.get(table1.key.field, obj1);
        if (handleMap.get(table1.name + key1) != null) {
            return -1;
        }
        int rowID = stmt.execDelete(db);
        handleMap.put(table1.name + key1, 1);
        this.handleMapping(key1, obj1, db, false, handleMap);
        return rowID;
    }

    private long insertRecursive(SQLStatement stmt, Object obj1, SQLiteDatabase db, HashMap<String, Integer> handleMap) throws Exception {
        EntityTable table1 = TableManager.getTable(obj1);
        Object key1 = FieldUtil.get(table1.key.field, obj1);
        if (handleMap.get(table1.name + key1) != null) {
            return -1L;
        }
        long rowID = stmt.execInsert(db, obj1);
        key1 = FieldUtil.get(table1.key.field, obj1);
        handleMap.put(table1.name + key1, 1);
        this.handleMapping(key1, obj1, db, true, handleMap);
        return rowID;
    }

    private long checkTableAndSaveRecursive(Object obj1, SQLiteDatabase db, HashMap<String, Integer> handleMap) throws Exception {
        this.mTableManager.checkOrCreateTable(db, obj1);
        return this.insertRecursive(SQLBuilder.buildReplaceSql(obj1), obj1, db, handleMap);
    }

    private int checkTableAndDeleteRecursive(Object obj1, SQLiteDatabase db, HashMap<String, Integer> handleMap) throws Exception {
        EntityTable table = TableManager.getTable(obj1);
        if (this.mTableManager.isSQLTableCreated(table.name)) {
            return this.deleteRecursive(SQLBuilder.buildDeleteSql(obj1), obj1, db, handleMap);
        }
        return -1;
    }

    private void handleMapping(Object key1, Object obj1, SQLiteDatabase db, boolean insertNew, HashMap<String, Integer> handleMap) throws Exception {
        EntityTable table1 = TableManager.getTable(obj1);
        if (table1.mappingList != null) {
            for (MapProperty map : table1.mappingList) {
                EntityTable table2;
                if (map.isToOne()) {
                    Object obj2 = FieldUtil.get(map.field, obj1);
                    table2 = TableManager.getTable(map.field.getType());
                    this.handleMapToOne(table1, table2, key1, obj2, db, insertNew, handleMap);
                    continue;
                }
                if (!map.isToMany()) continue;
                Object array = FieldUtil.get(map.field, obj1);
                if (ClassUtil.isCollection(map.field.getType())) {
                    table2 = TableManager.getTable(FieldUtil.getGenericType(map.field));
                    this.handleMapToMany(table1, table2, key1, (Collection)array, db, insertNew, handleMap);
                    continue;
                }
                if (ClassUtil.isArray(map.field.getType())) {
                    table2 = TableManager.getTable(FieldUtil.getComponentType(map.field));
                    List<Object> coll = null;
                    if (array != null) {
                        coll = Arrays.asList((Object[])array);
                    }
                    this.handleMapToMany(table1, table2, key1, coll, db, insertNew, handleMap);
                    continue;
                }
                throw new RuntimeException("OneToMany and ManyToMany Relation, you must use collection or array object");
            }
        }
    }

    private void handleMapToOne(EntityTable table1, EntityTable table2, Object key1, Object obj2, SQLiteDatabase db, boolean insertNew, HashMap<String, Integer> handleMap) throws Exception {
        Object key2;
        if (obj2 != null) {
            if (insertNew) {
                this.checkTableAndSaveRecursive(obj2, db, handleMap);
            } else {
                this.checkTableAndDeleteRecursive(obj2, db, handleMap);
            }
        }
        String mapTableName = TableManager.getMapTableName(table1, table2);
        this.mTableManager.checkOrCreateMappingTable(db, mapTableName, table1.name, table2.name);
        SQLStatement st = SQLBuilder.buildMappingDeleteSql(mapTableName, key1, table1);
        st.execDelete(db);
        if (insertNew && obj2 != null && (st = SQLBuilder.buildMappingToOneSql(mapTableName, key1, key2 = FieldUtil.get(table2.key.field, obj2), table1, table2)) != null) {
            st.execInsert(db);
        }
    }

    private void handleMapToMany(EntityTable table1, EntityTable table2, Object key1, Collection coll, SQLiteDatabase db, boolean insertNew, HashMap<String, Integer> handleMap) throws Exception {
        ArrayList<SQLStatement> sqlList;
        if (coll != null) {
            for (Object obj2 : coll) {
                if (obj2 == null) continue;
                if (insertNew) {
                    this.checkTableAndSaveRecursive(obj2, db, handleMap);
                    continue;
                }
                this.checkTableAndDeleteRecursive(obj2, db, handleMap);
            }
        }
        String tableName = TableManager.getMapTableName(table1, table2);
        this.mTableManager.checkOrCreateMappingTable(db, tableName, table1.name, table2.name);
        SQLStatement delSql = SQLBuilder.buildMappingDeleteSql(tableName, key1, table1);
        delSql.execDelete(db);
        if (insertNew && !Checker.isEmpty(coll) && !Checker.isEmpty(sqlList = SQLBuilder.buildMappingToManySql(key1, table1, table2, coll))) {
            for (SQLStatement sql : sqlList) {
                sql.execInsert(db);
            }
        }
    }
}

