/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.db.assit;

import com.litesuits.orm.db.TableManager;
import com.litesuits.orm.db.assit.SQLStatement;

public class WhereBuilder {
    public static final String NOTHING = "";
    public static final String WHERE = " WHERE ";
    public static final String EQUAL_HOLDER = "=?";
    public static final String NOT_EQUAL_HOLDER = "!=?";
    public static final String GREATER_THAN_HOLDER = ">?";
    public static final String LESS_THAN_HOLDER = "<?";
    public static final String COMMA_HOLDER = ",?";
    public static final String HOLDER = "?";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String NOT = " NOT ";
    public static final String DELETE = "DELETE FROM ";
    private static final String PARENTHESES_LEFT = "(";
    private static final String PARENTHESES_RIGHT = ")";
    private static final String IN = " IN ";
    protected String where;
    protected Object[] whereArgs;
    protected Class tableClass;

    public WhereBuilder(Class tableClass) {
        this.tableClass = tableClass;
    }

    public WhereBuilder(Class tableClass, String where, Object[] whereArgs) {
        this.where = where;
        this.whereArgs = whereArgs;
        this.tableClass = tableClass;
    }

    public static WhereBuilder create(Class tableClass) {
        return new WhereBuilder(tableClass);
    }

    public static WhereBuilder create(Class tableClass, String where, Object[] whereArgs) {
        return new WhereBuilder(tableClass, where, whereArgs);
    }

    public Class getTableClass() {
        return this.tableClass;
    }

    public WhereBuilder where(String where, Object ... whereArgs) {
        this.where = where;
        this.whereArgs = whereArgs;
        return this;
    }

    public WhereBuilder and(String where, Object ... whereArgs) {
        return this.append(AND, where, whereArgs);
    }

    public WhereBuilder or(String where, Object ... whereArgs) {
        return this.append(OR, where, whereArgs);
    }

    public WhereBuilder and() {
        if (this.where != null) {
            this.where = this.where + AND;
        }
        return this;
    }

    public WhereBuilder or() {
        if (this.where != null) {
            this.where = this.where + OR;
        }
        return this;
    }

    public WhereBuilder not() {
        if (this.where != null) {
            this.where = this.where + NOT;
        }
        return this;
    }

    public WhereBuilder noEquals(String column, Object value) {
        return this.append(null, column + NOT_EQUAL_HOLDER, value);
    }

    public WhereBuilder greaterThan(String column, Object value) {
        return this.append(null, column + GREATER_THAN_HOLDER, value);
    }

    public WhereBuilder lessThan(String column, Object value) {
        return this.append(null, column + LESS_THAN_HOLDER, value);
    }

    public WhereBuilder equals(String column, Object value) {
        return this.append(null, column + EQUAL_HOLDER, value);
    }

    public WhereBuilder orEquals(String column, Object value) {
        return this.append(OR, column + EQUAL_HOLDER, value);
    }

    public WhereBuilder andEquals(String column, Object value) {
        return this.append(AND, column + EQUAL_HOLDER, value);
    }

    public WhereBuilder in(String column, Object ... values) {
        return this.append(null, this.buildWhereIn(column, values.length), values);
    }

    public WhereBuilder orIn(String column, Object ... values) {
        return this.append(OR, this.buildWhereIn(column, values.length), values);
    }

    public WhereBuilder andIn(String column, Object ... values) {
        return this.append(AND, this.buildWhereIn(column, values.length), values);
    }

    public WhereBuilder append(String connect, String whereString, Object ... value) {
        if (this.where == null) {
            this.where = whereString;
            this.whereArgs = value;
        } else {
            if (connect != null) {
                this.where = this.where + connect;
            }
            this.where = this.where + whereString;
            if (this.whereArgs == null) {
                this.whereArgs = value;
            } else {
                Object[] newWhere = new Object[this.whereArgs.length + value.length];
                System.arraycopy(this.whereArgs, 0, newWhere, 0, this.whereArgs.length);
                System.arraycopy(value, 0, newWhere, this.whereArgs.length, value.length);
                this.whereArgs = newWhere;
            }
        }
        return this;
    }

    public String[] transToStringArray() {
        if (this.whereArgs != null && this.whereArgs.length > 0) {
            if (this.whereArgs instanceof String[]) {
                return (String[])this.whereArgs;
            }
            String[] arr = new String[this.whereArgs.length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = String.valueOf(this.whereArgs[i]);
            }
            return arr;
        }
        return null;
    }

    public String createWhereString() {
        if (this.where != null) {
            return WHERE + this.where;
        }
        return NOTHING;
    }

    public SQLStatement createStatementDelete() {
        SQLStatement stmt = new SQLStatement();
        stmt.sql = DELETE + TableManager.getTableName(this.tableClass) + this.createWhereString();
        stmt.bindArgs = this.transToStringArray();
        return stmt;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public Object[] getWhereArgs() {
        return this.whereArgs;
    }

    public void setWhereArgs(Object[] whereArgs) {
        this.whereArgs = whereArgs;
    }

    private String buildWhereIn(String column, int num) {
        StringBuilder sb = new StringBuilder(column).append(IN).append(PARENTHESES_LEFT).append(HOLDER);
        for (int i = 1; i < num; ++i) {
            sb.append(COMMA_HOLDER);
        }
        return sb.append(PARENTHESES_RIGHT).toString();
    }
}

