/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.db.assit;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.os.Build;
import com.litesuits.orm.db.TableManager;
import com.litesuits.orm.db.assit.Checker;
import com.litesuits.orm.db.assit.Querier;
import com.litesuits.orm.db.assit.SQLBuilder;
import com.litesuits.orm.db.assit.Transaction;
import com.litesuits.orm.db.model.ColumnsValue;
import com.litesuits.orm.db.model.EntityTable;
import com.litesuits.orm.db.model.MapInfo;
import com.litesuits.orm.db.model.Property;
import com.litesuits.orm.db.utils.ClassUtil;
import com.litesuits.orm.db.utils.DataUtil;
import com.litesuits.orm.db.utils.FieldUtil;
import com.litesuits.orm.log.OrmLog;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class SQLStatement
implements Serializable {
    public static final short NONE = -1;
    public static final short NORMAL = 0;
    public static final int IN_TOP_LIMIT = 999;
    private static final long serialVersionUID = -3790876762607683712L;
    private static final String TAG = SQLStatement.class.getSimpleName();
    public String sql;
    public Object[] bindArgs;
    private SQLiteStatement mStatement;

    public SQLStatement() {
    }

    public SQLStatement(String sql, Object[] args) {
        this.sql = sql;
        this.bindArgs = args;
    }

    protected void bind(int i, Object o) throws IOException {
        if (o == null) {
            this.mStatement.bindNull(i);
        } else if (o instanceof CharSequence || o instanceof Boolean || o instanceof Character) {
            this.mStatement.bindString(i, String.valueOf(o));
        } else if (o instanceof Float || o instanceof Double) {
            this.mStatement.bindDouble(i, ((Number)o).doubleValue());
        } else if (o instanceof Number) {
            this.mStatement.bindLong(i, ((Number)o).longValue());
        } else if (o instanceof Date) {
            this.mStatement.bindLong(i, ((Date)o).getTime());
        } else if (o instanceof byte[]) {
            this.mStatement.bindBlob(i, (byte[])o);
        } else if (o instanceof Serializable) {
            this.mStatement.bindBlob(i, DataUtil.objectToByte(o));
        } else {
            this.mStatement.bindNull(i);
        }
    }

    public long execInsert(SQLiteDatabase db) throws IOException, IllegalAccessException {
        return this.execInsertWithMapping(db, null, null);
    }

    public long execInsert(SQLiteDatabase db, Object entity) throws IOException, IllegalAccessException {
        return this.execInsertWithMapping(db, entity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execInsertWithMapping(SQLiteDatabase db, Object entity, TableManager tableManager) throws IllegalAccessException, IOException {
        this.printSQL();
        this.mStatement = db.compileStatement(this.sql);
        Object keyObj = null;
        if (!Checker.isEmpty(this.bindArgs)) {
            keyObj = this.bindArgs[0];
            for (int i = 0; i < this.bindArgs.length; ++i) {
                this.bind(i + 1, this.bindArgs[i]);
            }
        }
        long rowID = -1L;
        try {
            rowID = this.mStatement.executeInsert();
        }
        finally {
            this.realease();
        }
        if (OrmLog.isPrint) {
            OrmLog.i(TAG, "SQL Execute Insert RowID --> " + rowID + "    sql: " + this.sql);
        }
        if (entity != null) {
            FieldUtil.setKeyValueIfneed(entity, TableManager.getTable((Object)entity).key, keyObj, rowID);
        }
        if (tableManager != null) {
            this.mapRelationToDb(entity, true, true, db, tableManager);
        }
        return rowID;
    }

    public int execInsertCollection(SQLiteDatabase db, Collection<?> list) {
        return this.execInsertCollectionWithMapping(db, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execInsertCollectionWithMapping(SQLiteDatabase db, Collection<?> list, TableManager tableManager) {
        this.printSQL();
        db.beginTransaction();
        if (OrmLog.isPrint) {
            OrmLog.i(TAG, "----> BeginTransaction[insert col]");
        }
        EntityTable table = null;
        try {
            this.mStatement = db.compileStatement(this.sql);
            Iterator<?> it = list.iterator();
            boolean mapTableCheck = true;
            while (it.hasNext()) {
                this.mStatement.clearBindings();
                Object obj = it.next();
                if (table == null) {
                    table = TableManager.getTable(obj);
                }
                int j = 1;
                Object keyObj = null;
                if (table.key != null) {
                    keyObj = FieldUtil.getAssignedKeyObject(table.key, obj);
                    this.bind(j++, keyObj);
                }
                if (!Checker.isEmpty(table.pmap)) {
                    for (Property p : table.pmap.values()) {
                        this.bind(j++, FieldUtil.get(p.field, obj));
                    }
                }
                long rowID = this.mStatement.executeInsert();
                FieldUtil.setKeyValueIfneed(obj, table.key, keyObj, rowID);
                if (tableManager == null) continue;
                this.mapRelationToDb(obj, true, mapTableCheck, db, tableManager);
                mapTableCheck = false;
            }
            if (OrmLog.isPrint) {
                OrmLog.i(TAG, "Exec insert [" + list.size() + "] rows , SQL: " + this.sql);
            }
            db.setTransactionSuccessful();
            if (OrmLog.isPrint) {
                OrmLog.i(TAG, "----> BeginTransaction[insert col] Successful");
            }
            int n = list.size();
            return n;
        }
        catch (Exception e) {
            if (OrmLog.isPrint) {
                OrmLog.e(TAG, "----> BeginTransaction[insert col] Failling");
            }
            e.printStackTrace();
        }
        finally {
            this.realease();
            db.endTransaction();
        }
        return -1;
    }

    public int execUpdate(SQLiteDatabase db) throws IOException {
        return this.execUpdateWithMapping(db, null, null);
    }

    public int execUpdateWithMapping(SQLiteDatabase db, Object entity, TableManager tableManager) throws IOException {
        this.printSQL();
        this.mStatement = db.compileStatement(this.sql);
        if (!Checker.isEmpty(this.bindArgs)) {
            for (int i = 0; i < this.bindArgs.length; ++i) {
                this.bind(i + 1, this.bindArgs[i]);
            }
        }
        int rows = -1;
        if (Build.VERSION.SDK_INT < 11) {
            this.mStatement.execute();
            rows = 0;
        } else {
            rows = this.mStatement.executeUpdateDelete();
        }
        this.realease();
        if (OrmLog.isPrint) {
            OrmLog.i(TAG, "SQL Execute update, changed rows --> " + rows);
        }
        if (tableManager != null && entity != null) {
            this.mapRelationToDb(entity, true, true, db, tableManager);
        }
        return rows;
    }

    public int execUpdateCollection(SQLiteDatabase db, Collection<?> list, ColumnsValue cvs) {
        return this.execUpdateCollectionWithMapping(db, list, cvs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execUpdateCollectionWithMapping(SQLiteDatabase db, Collection<?> list, ColumnsValue cvs, TableManager tableManager) {
        this.printSQL();
        db.beginTransaction();
        if (OrmLog.isPrint) {
            OrmLog.d(TAG, "----> BeginTransaction[update col]");
        }
        try {
            this.mStatement = db.compileStatement(this.sql);
            Iterator<?> it = list.iterator();
            boolean mapTableCheck = true;
            EntityTable table = null;
            while (it.hasNext()) {
                this.mStatement.clearBindings();
                Object obj = it.next();
                if (table == null) {
                    table = TableManager.getTable(obj);
                }
                this.bindArgs = SQLBuilder.buildUpdateSqlArgsOnly(obj, cvs);
                if (!Checker.isEmpty(this.bindArgs)) {
                    for (int i = 0; i < this.bindArgs.length; ++i) {
                        this.bind(i + 1, this.bindArgs[i]);
                    }
                }
                this.mStatement.execute();
                if (tableManager == null) continue;
                this.mapRelationToDb(obj, true, mapTableCheck, db, tableManager);
                mapTableCheck = false;
            }
            if (OrmLog.isPrint) {
                OrmLog.i(TAG, "Exec update [" + list.size() + "] rows , SQL: " + this.sql);
            }
            db.setTransactionSuccessful();
            if (OrmLog.isPrint) {
                OrmLog.d(TAG, "----> BeginTransaction[update col] Successful");
            }
            int n = list.size();
            return n;
        }
        catch (Exception e) {
            if (OrmLog.isPrint) {
                OrmLog.e(TAG, "----> BeginTransaction[update col] Failling");
            }
            e.printStackTrace();
        }
        finally {
            this.realease();
            db.endTransaction();
        }
        return -1;
    }

    public int execDelete(SQLiteDatabase db) throws IOException {
        return this.execDeleteWithMapping(db, null, null);
    }

    public int execDeleteWithMapping(SQLiteDatabase db, Object entity, TableManager tableManager) throws IOException {
        this.printSQL();
        this.mStatement = db.compileStatement(this.sql);
        if (this.bindArgs != null) {
            for (int i = 0; i < this.bindArgs.length; ++i) {
                this.bind(i + 1, this.bindArgs[i]);
            }
        }
        int nums = -1;
        if (Build.VERSION.SDK_INT < 11) {
            this.mStatement.execute();
            nums = 0;
        } else {
            nums = this.mStatement.executeUpdateDelete();
        }
        if (OrmLog.isPrint) {
            OrmLog.v(TAG, "SQL execute delete, changed rows--> " + nums);
        }
        this.realease();
        if (tableManager != null && entity != null) {
            this.mapRelationToDb(entity, false, false, db, tableManager);
        }
        return nums;
    }

    public int execDeleteCollection(SQLiteDatabase db, Collection<?> collection) throws IOException {
        return this.execDeleteCollectionWithMapping(db, collection, null);
    }

    public int execDeleteCollectionWithMapping(SQLiteDatabase db, final Collection<?> collection, final TableManager tableManager) throws IOException {
        int nums;
        this.printSQL();
        this.mStatement = db.compileStatement(this.sql);
        if (this.bindArgs != null) {
            for (int i = 0; i < this.bindArgs.length; ++i) {
                this.bind(i + 1, this.bindArgs[i]);
            }
        }
        if (Build.VERSION.SDK_INT < 11) {
            this.mStatement.execute();
            nums = collection.size();
        } else {
            nums = this.mStatement.executeUpdateDelete();
        }
        if (OrmLog.isPrint) {
            OrmLog.v(TAG, "SQL execute delete, changed rows --> " + nums);
        }
        this.realease();
        if (tableManager != null) {
            Boolean suc = Transaction.execute(db, new Transaction.Worker<Boolean>(){

                @Override
                public Boolean doTransaction(SQLiteDatabase db) throws Exception {
                    boolean mapTableCheck = true;
                    for (Object o : collection) {
                        SQLStatement.this.mapRelationToDb(o, false, mapTableCheck, db, tableManager);
                        mapTableCheck = false;
                    }
                    return true;
                }
            });
            if (OrmLog.isPrint) {
                OrmLog.i(TAG, "Exec delete collection mapping: " + (suc != null && suc != false ? "\u6210\u529f" : "\u5931\u8d25"));
            }
        }
        return nums;
    }

    public boolean execute(SQLiteDatabase db) {
        this.printSQL();
        try {
            int i;
            this.mStatement = db.compileStatement(this.sql);
            if (this.bindArgs != null) {
                for (i = 0; i < this.bindArgs.length; ++i) {
                    this.bind(i + 1, this.bindArgs[i]);
                }
            }
            this.mStatement.execute();
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.realease();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long queryForLong(SQLiteDatabase db) {
        this.printSQL();
        long count = 0L;
        try {
            this.mStatement = db.compileStatement(this.sql);
            if (this.bindArgs != null) {
                for (int i = 0; i < this.bindArgs.length; ++i) {
                    this.bind(i + 1, this.bindArgs[i]);
                }
            }
            count = this.mStatement.simpleQueryForLong();
            if (OrmLog.isPrint) {
                OrmLog.i(TAG, "SQL execute query for count --> " + count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.realease();
        }
        return count;
    }

    public <T> ArrayList<T> query(SQLiteDatabase db, final Class<T> claxx) {
        this.printSQL();
        final ArrayList list = new ArrayList();
        try {
            final EntityTable table = TableManager.getTable(claxx, false);
            Querier.doQuery(db, this, new Querier.CursorParser(){

                @Override
                public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                    Object t = ClassUtil.newInstance(claxx);
                    DataUtil.injectDataToObject(c, t, table);
                    list.add(t);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public <T> T queryOneEntity(SQLiteDatabase db, final Class<T> claxx) {
        this.printSQL();
        final EntityTable table = TableManager.getTable(claxx, false);
        Object t = Querier.doQuery(db, this, new Querier.CursorParser<T>(){
            T t;

            @Override
            public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                this.t = ClassUtil.newInstance(claxx);
                DataUtil.injectDataToObject(c, this.t, table);
                this.stopParse();
            }

            @Override
            public T returnResult() {
                return this.t;
            }
        });
        return t;
    }

    public String toString() {
        return "SQLStatement [sql=" + this.sql + ", bindArgs=" + Arrays.toString(this.bindArgs) + ", mStatement=" + this.mStatement + "]";
    }

    private void mapRelationToDb(Object entity, final boolean insertNew, final boolean tableCheck, SQLiteDatabase db, final TableManager tableManager) {
        final MapInfo mapTable = SQLBuilder.buildMappingInfo(entity, insertNew, tableManager);
        if (mapTable != null && !mapTable.isEmpty()) {
            Transaction.execute(db, new Transaction.Worker<Boolean>(){

                @Override
                public Boolean doTransaction(SQLiteDatabase db) throws Exception {
                    long rowId;
                    if (insertNew && tableCheck) {
                        for (MapInfo.MapTable table : mapTable.tableList) {
                            tableManager.checkOrCreateMappingTable(db, table.name, table.column1, table.column2);
                        }
                    }
                    if (mapTable.delOldRelationSQL != null) {
                        for (SQLStatement st : mapTable.delOldRelationSQL) {
                            rowId = st.execDelete(db);
                            if (!OrmLog.isPrint) continue;
                            OrmLog.v(TAG, "Exec delete mapping success, nums: " + rowId);
                        }
                    }
                    if (insertNew && mapTable.mapNewRelationSQL != null) {
                        for (SQLStatement st : mapTable.mapNewRelationSQL) {
                            rowId = st.execInsert(db);
                            if (!OrmLog.isPrint) continue;
                            OrmLog.v(TAG, "Exec save mapping success, nums: " + rowId);
                        }
                    }
                    return true;
                }
            });
        }
    }

    private void printSQL() {
        if (OrmLog.isPrint) {
            OrmLog.d(TAG, "SQL Execute: [" + this.sql + "] ARGS--> " + Arrays.toString(this.bindArgs));
        }
    }

    private void realease() {
        if (this.mStatement != null) {
            this.mStatement.close();
        }
        this.bindArgs = null;
        this.mStatement = null;
    }
}

