/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.db.assit;

import com.litesuits.orm.db.TableManager;
import com.litesuits.orm.db.assit.Checker;
import com.litesuits.orm.db.assit.SQLStatement;
import com.litesuits.orm.db.assit.WhereBuilder;
import java.util.regex.Pattern;

public class QueryBuilder<T> {
    public static final String ASC = " ASC";
    public static final String DESC = " DESC";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String GROUP_BY = " GROUP BY ";
    public static final String HAVING = " HAVING ";
    public static final String ORDER_BY = " ORDER BY ";
    public static final String LIMIT = " LIMIT ";
    public static final String SELECT_COUNT = "SELECT COUNT(*) FROM ";
    public static final String SELECT = "SELECT ";
    public static final String DISTINCT = " DISTINCT ";
    public static final String ASTERISK = "*";
    public static final String FROM = " FROM ";
    public static final String EQUAL_HOLDER = "=?";
    public static final String COMMA_HOLDER = ",?";
    public static final String COMMA = ",";
    private static final Pattern limitPattern = Pattern.compile("\\s*\\d+\\s*(,\\s*\\d+\\s*)?");
    protected Class<T> clazz;
    protected Class clazzMapping;
    protected boolean distinct;
    protected String[] columns;
    protected String group;
    protected String having;
    protected String order;
    protected String limit;
    protected WhereBuilder whereBuilder;

    public QueryBuilder(Class<T> claxx) {
        this.clazz = claxx;
        this.whereBuilder = new WhereBuilder(claxx);
    }

    public static <T> QueryBuilder<T> create(Class<T> claxx) {
        return new QueryBuilder<T>(claxx);
    }

    private static void appendClause(StringBuilder s, String name, String clause) {
        if (!Checker.isEmpty(clause)) {
            s.append(name);
            s.append(clause);
        }
    }

    private static void appendColumns(StringBuilder s, String[] columns) {
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            String column = columns[i];
            if (column == null) continue;
            if (i > 0) {
                s.append(COMMA);
            }
            s.append(column);
        }
        s.append(" ");
    }

    public Class<T> getQueryClass() {
        return this.clazz;
    }

    public QueryBuilder<T> where(WhereBuilder builder) {
        this.whereBuilder = builder;
        return this;
    }

    public WhereBuilder getwhereBuilder() {
        return this.whereBuilder;
    }

    public QueryBuilder<T> where(String where, Object ... whereArgs) {
        this.whereBuilder.where(where, whereArgs);
        return this;
    }

    public QueryBuilder<T> whereAppend(String where, Object ... whereArgs) {
        this.whereBuilder.append(null, where, whereArgs);
        return this;
    }

    public QueryBuilder<T> whereAnd(String where, Object ... whereArgs) {
        this.whereBuilder.and(where, whereArgs);
        return this;
    }

    public QueryBuilder<T> whereOr(String where, Object ... whereArgs) {
        this.whereBuilder.or(where, whereArgs);
        return this;
    }

    public QueryBuilder<T> whereAppendAnd() {
        this.whereBuilder.and();
        return this;
    }

    public QueryBuilder<T> whereAppendOr() {
        this.whereBuilder.or();
        return this;
    }

    public QueryBuilder<T> whereAppendNot() {
        this.whereBuilder.not();
        return this;
    }

    public QueryBuilder<T> whereNoEquals(String column, Object value) {
        this.whereBuilder.noEquals(column, value);
        return this;
    }

    public QueryBuilder<T> whereGreaterThan(String column, Object value) {
        this.whereBuilder.greaterThan(column, value);
        return this;
    }

    public QueryBuilder<T> whereLessThan(String column, Object value) {
        this.whereBuilder.lessThan(column, value);
        return this;
    }

    public QueryBuilder<T> whereEquals(String column, Object value) {
        this.whereBuilder.equals(column, value);
        return this;
    }

    public QueryBuilder<T> whereIn(String column, Object ... values) {
        this.whereBuilder.in(column, values);
        return this;
    }

    public QueryBuilder<T> columns(String[] columns) {
        this.columns = columns;
        return this;
    }

    public QueryBuilder<T> appendColumns(String[] columns) {
        if (this.columns != null) {
            String[] newCols = new String[this.columns.length + columns.length];
            System.arraycopy(this.columns, 0, newCols, 0, this.columns.length);
            System.arraycopy(columns, 0, newCols, this.columns.length, columns.length);
            this.columns = newCols;
        } else {
            this.columns = columns;
        }
        return this;
    }

    public QueryBuilder<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public QueryBuilder<T> groupBy(String group) {
        this.group = group;
        return this;
    }

    public QueryBuilder<T> having(String having) {
        this.having = having;
        return this;
    }

    public QueryBuilder<T> orderBy(String order) {
        this.order = order;
        return this;
    }

    public QueryBuilder<T> appendOrderAscBy(String column) {
        this.order = this.order == null ? column + ASC : this.order + ", " + column + ASC;
        return this;
    }

    public QueryBuilder<T> appendOrderDescBy(String column) {
        this.order = this.order == null ? column + DESC : this.order + ", " + column + DESC;
        return this;
    }

    public QueryBuilder<T> limit(String limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder<T> limit(int start, int length) {
        this.limit = start + COMMA + length;
        return this;
    }

    public QueryBuilder<T> queryMappingInfo(Class clazzMapping) {
        this.clazzMapping = clazzMapping;
        return this;
    }

    public SQLStatement createStatement() {
        if (this.clazz == null) {
            throw new IllegalArgumentException("U Must Set A Query Entity Class By queryWho(Class) or QueryBuilder(Class)");
        }
        if (Checker.isEmpty(this.group) && !Checker.isEmpty(this.having)) {
            throw new IllegalArgumentException("HAVING\u4ec5\u5141\u8bb8\u5728\u6709GroupBy\u7684\u65f6\u5019\u4f7f\u7528(HAVING clauses are only permitted when using a groupBy clause)");
        }
        if (!Checker.isEmpty(this.limit) && !limitPattern.matcher(this.limit).matches()) {
            throw new IllegalArgumentException("invalid LIMIT clauses:" + this.limit);
        }
        StringBuilder query = new StringBuilder(120);
        query.append(SELECT);
        if (this.distinct) {
            query.append(DISTINCT);
        }
        if (!Checker.isEmpty(this.columns)) {
            QueryBuilder.appendColumns(query, this.columns);
        } else {
            query.append(ASTERISK);
        }
        query.append(FROM).append(this.getTableName());
        query.append(this.whereBuilder.createWhereString());
        QueryBuilder.appendClause(query, GROUP_BY, this.group);
        QueryBuilder.appendClause(query, HAVING, this.having);
        QueryBuilder.appendClause(query, ORDER_BY, this.order);
        QueryBuilder.appendClause(query, LIMIT, this.limit);
        SQLStatement stmt = new SQLStatement();
        stmt.sql = query.toString();
        stmt.bindArgs = this.whereBuilder.transToStringArray();
        return stmt;
    }

    public SQLStatement createStatementForCount() {
        StringBuilder query = new StringBuilder(120);
        query.append(SELECT_COUNT).append(this.getTableName());
        SQLStatement stmt = new SQLStatement();
        if (this.whereBuilder != null) {
            query.append(this.whereBuilder.createWhereString());
            stmt.bindArgs = this.whereBuilder.transToStringArray();
        }
        stmt.sql = query.toString();
        return stmt;
    }

    public String getTableName() {
        if (this.clazzMapping == null) {
            return TableManager.getTableName(this.clazz);
        }
        return TableManager.getMapTableName(this.clazz, this.clazzMapping);
    }

    private String buildWhereIn(String column, int num) {
        StringBuilder sb = new StringBuilder(column).append(" IN (?");
        for (int i = 1; i < num; ++i) {
            sb.append(COMMA_HOLDER);
        }
        return sb.append(")").toString();
    }
}

