/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.db.assit;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.litesuits.orm.db.assit.SQLStatement;
import com.litesuits.orm.log.OrmLog;

public class Querier {
    private static final String TAG = Querier.class.getSimpleName();

    public static <T> T doQuery(SQLiteDatabase db, SQLStatement st, CursorParser<T> parser) {
        Cursor cursor;
        if (OrmLog.isPrint) {
            OrmLog.d(TAG, "----> Query Start: " + st.toString());
        }
        if ((cursor = db.rawQuery(st.sql, (String[])st.bindArgs)) != null) {
            parser.process(db, cursor);
            if (OrmLog.isPrint) {
                OrmLog.d(TAG, "<---- Query End , cursor size : " + cursor.getCount());
            }
        } else if (OrmLog.isPrint) {
            OrmLog.e(TAG, "<---- Query End : cursor is null");
        }
        return parser.returnResult();
    }

    public static abstract class CursorParser<T> {
        private boolean parse = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void process(SQLiteDatabase db, Cursor cursor) {
            try {
                cursor.moveToFirst();
                while (this.parse && !cursor.isAfterLast()) {
                    this.parseEachCursor(db, cursor);
                    cursor.moveToNext();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public final void stopParse() {
            this.parse = false;
        }

        public T returnResult() {
            return null;
        }

        public abstract void parseEachCursor(SQLiteDatabase var1, Cursor var2) throws Exception;
    }
}

