/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.litesuits.orm.db.annotation.Column;
import com.litesuits.orm.db.annotation.Mapping;
import com.litesuits.orm.db.annotation.PrimaryKey;
import com.litesuits.orm.db.annotation.Table;
import com.litesuits.orm.db.assit.Checker;
import com.litesuits.orm.db.assit.Querier;
import com.litesuits.orm.db.assit.SQLBuilder;
import com.litesuits.orm.db.assit.SQLStatement;
import com.litesuits.orm.db.assit.Transaction;
import com.litesuits.orm.db.enums.AssignType;
import com.litesuits.orm.db.model.EntityTable;
import com.litesuits.orm.db.model.MapProperty;
import com.litesuits.orm.db.model.Primarykey;
import com.litesuits.orm.db.model.Property;
import com.litesuits.orm.db.model.SQLiteColumn;
import com.litesuits.orm.db.model.SQLiteTable;
import com.litesuits.orm.db.utils.DataUtil;
import com.litesuits.orm.db.utils.FieldUtil;
import com.litesuits.orm.log.OrmLog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public final class TableManager {
    private static final String TAG = TableManager.class.getSimpleName();
    private static final String[] ID = new String[]{"id", "_id"};
    private static final HashMap<String, EntityTable> mEntityTableMap = new HashMap();
    private final HashMap<String, SQLiteTable> mSqlTableMap = new HashMap();
    private String dbName = "";

    public TableManager(String dbName, SQLiteDatabase db) {
        this.dbName = dbName;
        this.initSqlTable(db);
    }

    private static EntityTable getEntityTable(String name) {
        return mEntityTableMap.get(name);
    }

    private static EntityTable putEntityTable(String tableName, EntityTable entity) {
        return mEntityTableMap.put(tableName, entity);
    }

    public static EntityTable getTable(Object entity) {
        return TableManager.getTable(entity.getClass(), true);
    }

    public static EntityTable getTable(Class<?> claxx) {
        return TableManager.getTable(claxx, true);
    }

    public static synchronized EntityTable getTable(Class<?> claxx, boolean needPK) {
        EntityTable table = TableManager.getEntityTable(claxx.getName());
        if (table == null) {
            table = new EntityTable();
            table.claxx = claxx;
            table.name = TableManager.getTableName(claxx);
            table.pmap = new LinkedHashMap();
            List<Field> fields = FieldUtil.getAllDeclaredFields(claxx);
            for (Field f : fields) {
                if (FieldUtil.isInvalid(f)) continue;
                Column col = f.getAnnotation(Column.class);
                String column = col != null ? col.value() : f.getName();
                Property p = new Property(column, f);
                PrimaryKey key = f.getAnnotation(PrimaryKey.class);
                if (key != null) {
                    table.key = new Primarykey(p, key.value());
                    TableManager.checkPrimaryKey(table.key);
                    continue;
                }
                Mapping mapping = f.getAnnotation(Mapping.class);
                if (mapping != null) {
                    table.addMapping(new MapProperty(p, mapping.value()));
                    continue;
                }
                table.pmap.put(p.column, p);
            }
            if (table.key == null) {
                for (String col : table.pmap.keySet()) {
                    for (String id : ID) {
                        if (!id.equalsIgnoreCase(col)) continue;
                        Property p = table.pmap.get(col);
                        if (p.field.getType() == String.class) {
                            table.pmap.remove(col);
                            table.key = new Primarykey(p, AssignType.BY_MYSELF);
                            break;
                        }
                        if (!FieldUtil.isNumber(p.field.getType())) continue;
                        table.pmap.remove(col);
                        table.key = new Primarykey(p, AssignType.AUTO_INCREMENT);
                        break;
                    }
                    if (table.key == null) continue;
                    break;
                }
            }
            if (needPK && table.key == null) {
                throw new RuntimeException("\u4f60\u5fc5\u987b\u4e3a[" + table.claxx.getSimpleName() + "]\u8bbe\u7f6e\u4e3b\u952e(you must set the primary key...)\n \u63d0\u793a\uff1a\u5728\u5bf9\u8c61\u7684\u5c5e\u6027\u4e0a\u52a0PrimaryKey\u6ce8\u89e3\u6765\u8bbe\u7f6e\u4e3b\u952e\u3002");
            }
            TableManager.putEntityTable(claxx.getName(), table);
        }
        return table;
    }

    private static void checkPrimaryKey(Primarykey key) {
        if (key.isAssignedBySystem()) {
            if (!FieldUtil.isNumber(key.field.getType())) {
                throw new RuntimeException((Object)((Object)AssignType.AUTO_INCREMENT) + " Auto increment primary key must be a number ...\n \u9519\u8bef\u63d0\u793a\uff1a\u81ea\u589e\u4e3b\u952e\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u6570\u5b57\u7c7b\u578b");
            }
        } else if (key.isAssignedByMyself()) {
            if (String.class != key.field.getType() && !FieldUtil.isNumber(key.field.getType())) {
                throw new RuntimeException((Object)((Object)AssignType.BY_MYSELF) + " Custom primary key must be string or number ...\n \u9519\u8bef\u63d0\u793a\uff1a\u81ea\u5b9a\u4e49\u4e3b\u952e\u503c\u5fc5\u987b\u4e3aString\u6216\u8005Number\u7c7b\u578b");
            }
        } else {
            throw new RuntimeException(" Primary key without Assign Type ...\n \u9519\u8bef\u63d0\u793a\uff1a\u4e3b\u952e\u65e0\u7c7b\u578b");
        }
    }

    public static String getTableName(Class<?> claxx) {
        Table anno = claxx.getAnnotation(Table.class);
        if (anno != null) {
            return anno.value();
        }
        return claxx.getName().replaceAll("\\.", "_");
    }

    public static String getMapTableName(Class c1, Class c2) {
        return TableManager.getMapTableName(TableManager.getTableName(c1), TableManager.getTableName(c2));
    }

    public static String getMapTableName(EntityTable t1, EntityTable t2) {
        return TableManager.getMapTableName(t1.name, t2.name);
    }

    public static String getMapTableName(String tableName1, String tableName2) {
        if (tableName1.compareTo(tableName2) < 0) {
            return tableName1 + "_" + tableName2;
        }
        return tableName2 + "_" + tableName1;
    }

    public void initSqlTable(SQLiteDatabase db) {
        this.initAllTablesFromSQLite(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSqlTable() {
        HashMap<String, SQLiteTable> hashMap = this.mSqlTableMap;
        synchronized (hashMap) {
            this.mSqlTableMap.clear();
        }
    }

    public void release() {
        this.clearSqlTable();
        mEntityTableMap.clear();
    }

    public EntityTable checkOrCreateTable(SQLiteDatabase db, Object entity) {
        return this.checkOrCreateTable(db, entity.getClass());
    }

    public synchronized EntityTable checkOrCreateTable(SQLiteDatabase db, Class claxx) {
        EntityTable table = TableManager.getTable(claxx);
        if (!this.checkExistAndColumns(db, table) && this.createTable(db, table)) {
            this.putNewSqlTableIntoMap(table);
        }
        return table;
    }

    public synchronized void checkOrCreateMappingTable(SQLiteDatabase db, String tableName, String column1, String column2) {
        EntityTable table = this.getMappingTable(tableName, column1, column2);
        if (!this.checkExistAndColumns(db, table) && this.createTable(db, table)) {
            this.putNewSqlTableIntoMap(table);
        }
    }

    public boolean isSQLMapTableCreated(String tableName1, String tableName2) {
        return this.mSqlTableMap.get(TableManager.getMapTableName(tableName1, tableName2)) != null;
    }

    public boolean isSQLTableCreated(String tableName) {
        return this.mSqlTableMap.get(tableName) != null;
    }

    private boolean checkExistAndColumns(SQLiteDatabase db, EntityTable entityTable) {
        SQLiteTable sqlTable = this.mSqlTableMap.get(entityTable.name);
        if (sqlTable != null) {
            if (OrmLog.isPrint) {
                OrmLog.d(TAG, "Table [" + entityTable.name + "] Exist");
            }
            if (!sqlTable.isTableChecked) {
                sqlTable.isTableChecked = true;
                if (OrmLog.isPrint) {
                    OrmLog.i(TAG, "Table [" + entityTable.name + "] check column now.");
                }
                if (entityTable.key != null && sqlTable.columns.get(entityTable.key.column) == null) {
                    SQLStatement stmt = SQLBuilder.buildDropTable(sqlTable.name);
                    stmt.execute(db);
                    if (OrmLog.isPrint) {
                        OrmLog.i(TAG, "Table [" + entityTable.name + "] Primary Key has changed, so drop and recreate it later.");
                    }
                    return false;
                }
                if (entityTable.pmap != null) {
                    ArrayList<String> newColumns = new ArrayList<String>();
                    for (String col : entityTable.pmap.keySet()) {
                        if (sqlTable.columns.get(col) != null) continue;
                        newColumns.add(col);
                    }
                    if (!Checker.isEmpty(newColumns)) {
                        for (String col : newColumns) {
                            sqlTable.columns.put(col, 1);
                        }
                        int sum = this.insertNewColunms(db, entityTable.name, newColumns);
                        if (OrmLog.isPrint) {
                            if (sum > 0) {
                                OrmLog.i(TAG, "Table [" + entityTable.name + "] add " + sum + " new column \uff1a " + newColumns);
                            } else {
                                OrmLog.e(TAG, "Table [" + entityTable.name + "] add " + sum + " new column error \uff1a " + newColumns);
                            }
                        }
                    }
                }
            }
            return true;
        }
        if (OrmLog.isPrint) {
            OrmLog.d(TAG, "Table [" + entityTable.name + "] Not Exist");
        }
        return false;
    }

    private void putNewSqlTableIntoMap(EntityTable table) {
        if (OrmLog.isPrint) {
            OrmLog.i(TAG, "Table [" + table.name + "] Create Success");
        }
        SQLiteTable sqlTable = new SQLiteTable();
        sqlTable.name = table.name;
        sqlTable.columns = new HashMap();
        if (table.key != null) {
            sqlTable.columns.put(table.key.column, 1);
        }
        if (table.pmap != null) {
            for (String col : table.pmap.keySet()) {
                sqlTable.columns.put(col, 1);
            }
        }
        sqlTable.isTableChecked = true;
        this.mSqlTableMap.put(sqlTable.name, sqlTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAllTablesFromSQLite(SQLiteDatabase db) {
        HashMap<String, SQLiteTable> hashMap = this.mSqlTableMap;
        synchronized (hashMap) {
            if (Checker.isEmpty(this.mSqlTableMap)) {
                if (OrmLog.isPrint) {
                    OrmLog.i(TAG, "Initialize SQL table start--------------------->");
                }
                SQLStatement st = SQLBuilder.buildTableObtainAll();
                final EntityTable table = TableManager.getTable(SQLiteTable.class, false);
                Querier.doQuery(db, st, new Querier.CursorParser(){

                    @Override
                    public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                        SQLiteTable sqlTable = new SQLiteTable();
                        DataUtil.injectDataToObject(c, sqlTable, table);
                        ArrayList<String> colS = TableManager.this.getAllColumnsFromSQLite(db, sqlTable.name);
                        if (Checker.isEmpty(colS)) {
                            OrmLog.e(TAG, "\u8bfb\u6570\u636e\u5e93\u5931\u8d25\u4e86\uff0c\u5f00\u59cb\u89e3\u6790\u5efa\u8868\u8bed\u53e5");
                            colS = TableManager.this.transformSqlToColumns(sqlTable.sql);
                        }
                        sqlTable.columns = new HashMap();
                        for (String col : colS) {
                            sqlTable.columns.put(col, 1);
                        }
                        if (OrmLog.isPrint) {
                            OrmLog.i(TAG, "Find One SQL Table: " + sqlTable);
                            OrmLog.i(TAG, "Table Column: " + colS);
                        }
                        TableManager.this.mSqlTableMap.put(sqlTable.name, sqlTable);
                    }
                });
                if (OrmLog.isPrint) {
                    OrmLog.i(TAG, "Initialize SQL table end  ---------------------> " + this.mSqlTableMap.size());
                }
            }
        }
    }

    private int insertNewColunms(SQLiteDatabase db, final String tableName, final List<String> columns) {
        Integer size = null;
        if (!Checker.isEmpty(columns)) {
            size = Transaction.execute(db, new Transaction.Worker<Integer>(){

                @Override
                public Integer doTransaction(SQLiteDatabase db) {
                    for (String c : columns) {
                        SQLStatement stmt = SQLBuilder.buildAddColumnSql(tableName, c);
                        stmt.execute(db);
                    }
                    return columns.size();
                }
            });
        }
        return size == null ? 0 : size;
    }

    private boolean createTable(SQLiteDatabase db, EntityTable table) {
        return SQLBuilder.buildCreateTable(table).execute(db);
    }

    public ArrayList<String> getAllColumnsFromSQLite(SQLiteDatabase db, String tableName) {
        final EntityTable table = TableManager.getTable(SQLiteColumn.class, false);
        final ArrayList<String> list = new ArrayList<String>();
        SQLStatement st = SQLBuilder.buildColumnsObtainAll(tableName);
        Querier.doQuery(db, st, new Querier.CursorParser(){

            @Override
            public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                SQLiteColumn col = new SQLiteColumn();
                DataUtil.injectDataToObject(c, col, table);
                list.add(col.name);
            }
        });
        return list;
    }

    public ArrayList<String> transformSqlToColumns(String sql) {
        if (sql != null) {
            int start = sql.indexOf("(");
            int end = sql.lastIndexOf(")");
            if (start > 0 && end > 0) {
                sql = sql.substring(start + 1, end);
                String[] cloumns = sql.split(",");
                ArrayList<String> colList = new ArrayList<String>();
                for (String col : cloumns) {
                    int endS = (col = col.trim()).indexOf(" ");
                    if (endS > 0) {
                        col = col.substring(0, endS);
                    }
                    colList.add(col);
                }
                OrmLog.e(TAG, "\u964d\u7ea7\uff1a\u8bed\u4e49\u5206\u6790\u8868\u7ed3\u6784\uff08" + colList.toString() + " , Origin SQL is: " + sql);
                return colList;
            }
        }
        return null;
    }

    private EntityTable getMappingTable(String tableName, String column1, String column2) {
        EntityTable table = TableManager.getEntityTable(this.dbName + tableName);
        if (table == null) {
            table = new EntityTable();
            table.name = tableName;
            table.pmap = new LinkedHashMap();
            table.pmap.put(column1, null);
            table.pmap.put(column2, null);
            TableManager.putEntityTable(this.dbName + tableName, table);
        }
        return table;
    }
}

