/*
 * Decompiled with CFR 0.152.
 */
package com.litesuits.orm;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteDatabase;
import com.litesuits.orm.db.DataBase;
import com.litesuits.orm.db.DataBaseConfig;
import com.litesuits.orm.db.TableManager;
import com.litesuits.orm.db.assit.Checker;
import com.litesuits.orm.db.assit.CollSpliter;
import com.litesuits.orm.db.assit.Querier;
import com.litesuits.orm.db.assit.QueryBuilder;
import com.litesuits.orm.db.assit.SQLBuilder;
import com.litesuits.orm.db.assit.SQLStatement;
import com.litesuits.orm.db.assit.SQLiteHelper;
import com.litesuits.orm.db.assit.WhereBuilder;
import com.litesuits.orm.db.impl.CascadeSQLiteImpl;
import com.litesuits.orm.db.impl.SingleSQLiteImpl;
import com.litesuits.orm.db.model.ColumnsValue;
import com.litesuits.orm.db.model.ConflictAlgorithm;
import com.litesuits.orm.db.model.EntityTable;
import com.litesuits.orm.db.model.MapProperty;
import com.litesuits.orm.db.model.RelationKey;
import com.litesuits.orm.db.utils.ClassUtil;
import com.litesuits.orm.db.utils.DataUtil;
import com.litesuits.orm.db.utils.FieldUtil;
import com.litesuits.orm.log.OrmLog;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class LiteOrm
extends SQLiteClosable
implements DataBase {
    public static final String TAG = LiteOrm.class.getSimpleName();
    protected SQLiteHelper mHelper;
    protected DataBaseConfig mConfig;
    protected TableManager mTableManager;
    protected LiteOrm otherDatabase;

    protected LiteOrm(LiteOrm dataBase) {
        this.mHelper = dataBase.mHelper;
        this.mConfig = dataBase.mConfig;
        this.mTableManager = dataBase.mTableManager;
        this.otherDatabase = dataBase;
    }

    protected LiteOrm(DataBaseConfig config) {
        config.context = config.context.getApplicationContext();
        if (config.dbName == null) {
            config.dbName = "liteorm.db";
        }
        if (config.dbVersion <= 0) {
            config.dbVersion = 1;
        }
        this.mConfig = config;
        this.setDebugged(config.debugged);
        this.openOrCreateDatabase();
    }

    public static LiteOrm newSingleInstance(Context context, String dbName) {
        return LiteOrm.newSingleInstance(new DataBaseConfig(context, dbName));
    }

    public static synchronized LiteOrm newSingleInstance(DataBaseConfig config) {
        return SingleSQLiteImpl.newInstance(config);
    }

    public static LiteOrm newCascadeInstance(Context context, String dbName) {
        return LiteOrm.newCascadeInstance(new DataBaseConfig(context, dbName));
    }

    public static synchronized LiteOrm newCascadeInstance(DataBaseConfig config) {
        return CascadeSQLiteImpl.newInstance(config);
    }

    public static int releaseMemory() {
        return SQLiteDatabase.releaseMemory();
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase() {
        this.initDatabasePath(this.mConfig.dbName);
        if (this.mHelper != null) {
            this.justRelease();
        }
        this.mHelper = new SQLiteHelper(this.mConfig.context.getApplicationContext(), this.mConfig.dbName, null, this.mConfig.dbVersion, this.mConfig.onUpdateListener);
        this.mTableManager = new TableManager(this.mConfig.dbName, this.mHelper.getReadableDatabase());
        return this.mHelper.getWritableDatabase();
    }

    private void initDatabasePath(String path) {
        OrmLog.i(TAG, "create  database path: " + path);
        path = this.mConfig.context.getDatabasePath(this.mConfig.dbName).getPath();
        OrmLog.i(TAG, "context database path: " + path);
        File dbp = new File(path).getParentFile();
        if (dbp != null && !dbp.exists()) {
            boolean mks = dbp.mkdirs();
            OrmLog.i(TAG, "create database, parent file mkdirs: " + mks + "  path:" + dbp.getAbsolutePath());
        }
    }

    public abstract LiteOrm single();

    public abstract LiteOrm cascade();

    public void setDebugged(boolean debugged) {
        this.mConfig.debugged = debugged;
        OrmLog.isPrint = debugged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<RelationKey> queryRelation(final Class class1, final Class class2, final List<String> key1List) {
        this.acquireReference();
        final ArrayList<RelationKey> rList = new ArrayList<RelationKey>();
        try {
            final EntityTable table1 = TableManager.getTable(class1);
            final EntityTable table2 = TableManager.getTable(class2);
            if (this.mTableManager.isSQLMapTableCreated(table1.name, table2.name)) {
                CollSpliter.split(key1List, 999, new CollSpliter.Spliter<String>(){

                    @Override
                    public int oneSplit(ArrayList<String> list) throws Exception {
                        SQLStatement stmt = SQLBuilder.buildQueryRelationSql(class1, class2, key1List);
                        Querier.doQuery(LiteOrm.this.mHelper.getReadableDatabase(), stmt, new Querier.CursorParser(){

                            @Override
                            public void parseEachCursor(SQLiteDatabase db, Cursor c) throws Exception {
                                RelationKey relation = new RelationKey();
                                relation.key1 = c.getString(c.getColumnIndex(table1.name));
                                relation.key2 = c.getString(c.getColumnIndex(table2.name));
                                rList.add(relation);
                            }
                        });
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return rList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E, T> boolean mapping(Collection<E> col1, Collection<T> col2) {
        if (Checker.isEmpty(col1) || Checker.isEmpty(col2)) {
            return false;
        }
        this.acquireReference();
        try {
            boolean bl = this.keepMapping(col1, col2) | this.keepMapping(col2, col1);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return false;
    }

    @Override
    public SQLStatement createSQLStatement(String sql, Object[] bindArgs) {
        return new SQLStatement(sql, bindArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(SQLiteDatabase db, SQLStatement statement) {
        this.acquireReference();
        try {
            if (statement != null) {
                boolean bl = statement.execute(db);
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean dropTable(Object entity) {
        return this.dropTable(entity.getClass());
    }

    @Override
    public boolean dropTable(Class<?> claxx) {
        return this.dropTable(TableManager.getTable(claxx, (boolean)false).name);
    }

    @Override
    public boolean dropTable(String tableName) {
        this.acquireReference();
        try {
            boolean bl = SQLBuilder.buildDropTable(tableName).execute(this.mHelper.getWritableDatabase());
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return false;
    }

    @Override
    public <T> long queryCount(Class<T> claxx) {
        return this.queryCount(new QueryBuilder<T>(claxx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryCount(QueryBuilder qb) {
        this.acquireReference();
        try {
            if (this.mTableManager.isSQLTableCreated(qb.getTableName())) {
                SQLiteDatabase db = this.mHelper.getReadableDatabase();
                SQLStatement stmt = qb.createStatementForCount();
                long l = stmt.queryForLong(db);
                return l;
            }
            long db = 0L;
            return db;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(WhereBuilder where, ColumnsValue cvs, ConflictAlgorithm conflictAlgorithm) {
        this.acquireReference();
        try {
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            SQLStatement stmt = SQLBuilder.buildUpdateSql(where, cvs, conflictAlgorithm);
            int n = stmt.execUpdate(db);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return -1;
    }

    @Override
    public synchronized SQLiteDatabase getReadableDatabase() {
        return this.mHelper.getReadableDatabase();
    }

    @Override
    public synchronized SQLiteDatabase getWritableDatabase() {
        return this.mHelper.getWritableDatabase();
    }

    @Override
    public TableManager getTableManager() {
        return this.mTableManager;
    }

    @Override
    public SQLiteHelper getSQLiteHelper() {
        return this.mHelper;
    }

    @Override
    public DataBaseConfig getDataBaseConfig() {
        return this.mConfig;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String path, SQLiteDatabase.CursorFactory factory) {
        path = this.mConfig.context.getDatabasePath(this.mConfig.dbName).getPath();
        return SQLiteDatabase.openOrCreateDatabase((String)path, (SQLiteDatabase.CursorFactory)factory);
    }

    @Override
    public boolean deleteDatabase() {
        String path = this.mHelper.getWritableDatabase().getPath();
        this.justRelease();
        OrmLog.i(TAG, "data has cleared. delete Database path: " + path);
        return this.deleteDatabase(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDatabase(File file) {
        this.acquireReference();
        try {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            boolean deleted = file.delete();
            deleted |= new File(file.getPath() + "-journal").delete();
            deleted |= new File(file.getPath() + "-shm").delete();
            deleted |= new File(file.getPath() + "-wal").delete();
            File dir = file.getParentFile();
            if (dir != null) {
                final String prefix = file.getName() + "-mj";
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File candidate) {
                        return candidate.getName().startsWith(prefix);
                    }
                };
                for (File masterJournal : dir.listFiles(filter)) {
                    deleted |= masterJournal.delete();
                }
            }
            boolean bl = deleted;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseReference();
        }
        return false;
    }

    @Override
    public synchronized void close() {
        this.releaseReference();
    }

    protected void onAllReferencesReleased() {
        this.justRelease();
    }

    protected void justRelease() {
        if (this.mHelper != null) {
            this.mHelper.getWritableDatabase().close();
            this.mHelper.close();
            this.mHelper = null;
        }
        if (this.mTableManager != null) {
            this.mTableManager.release();
            this.mTableManager = null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <E, T> boolean keepMapping(Collection<E> col1, Collection<T> col2) throws IllegalAccessException, InstantiationException {
        Class<?> claxx1 = col1.iterator().next().getClass();
        Class<?> claxx2 = col2.iterator().next().getClass();
        EntityTable table1 = TableManager.getTable(claxx1);
        EntityTable table2 = TableManager.getTable(claxx2);
        if (table1.mappingList == null) return false;
        for (MapProperty mp : table1.mappingList) {
            Class<?> itemClass;
            Class<?> fieldClass = mp.field.getType();
            if (mp.isToMany()) {
                if (ClassUtil.isCollection(fieldClass)) {
                    itemClass = FieldUtil.getGenericType(mp.field);
                } else {
                    if (!fieldClass.isArray()) throw new RuntimeException("OneToMany and ManyToMany Relation, Must use collection or array object");
                    itemClass = FieldUtil.getComponentType(mp.field);
                }
            } else {
                itemClass = fieldClass;
            }
            if (itemClass != claxx2) continue;
            ArrayList<String> key1List = new ArrayList<String>();
            HashMap<String, E> map1 = new HashMap<String, E>();
            for (E o1 : col1) {
                Iterator<T> key1;
                if (o1 == null || (key1 = FieldUtil.get(table1.key.field, o1)) == null) continue;
                key1List.add(key1.toString());
                map1.put(key1.toString(), o1);
            }
            ArrayList<RelationKey> relationKeys = this.queryRelation(claxx1, claxx2, key1List);
            if (Checker.isEmpty(relationKeys)) continue;
            HashMap<String, T> map2 = new HashMap<String, T>();
            for (T o2 : col2) {
                Object object;
                if (o2 == null || (object = FieldUtil.get(table2.key.field, o2)) == null) continue;
                map2.put(object.toString(), o2);
            }
            HashMap collMap = new HashMap();
            for (RelationKey relationKey : relationKeys) {
                Object v = map1.get(relationKey.key1);
                Object obj2 = map2.get(relationKey.key2);
                if (v == null || obj2 == null) continue;
                if (mp.isToMany()) {
                    void var20_26;
                    ArrayList arrayList = (ArrayList)collMap.get(v);
                    if (arrayList == null) {
                        ArrayList arrayList2 = new ArrayList();
                        collMap.put(v, arrayList2);
                    }
                    var20_26.add(obj2);
                    continue;
                }
                FieldUtil.set(mp.field, v, obj2);
            }
            if (Checker.isEmpty(collMap)) return true;
            for (Map.Entry entry : collMap.entrySet()) {
                Object k = entry.getKey();
                Collection tempColl = (Collection)entry.getValue();
                if (ClassUtil.isCollection(itemClass)) {
                    Collection collection = (Collection)FieldUtil.get(mp.field, k);
                    if (collection == null) {
                        FieldUtil.set(mp.field, k, tempColl);
                        continue;
                    }
                    collection.addAll(tempColl);
                    continue;
                }
                if (!ClassUtil.isArray(itemClass)) continue;
                Object[] objectArray = (Object[])ClassUtil.newArray(itemClass, tempColl.size());
                tempColl.toArray(objectArray);
                Object[] array = (Object[])FieldUtil.get(mp.field, k);
                if (array == null) {
                    FieldUtil.set(mp.field, k, objectArray);
                    continue;
                }
                Object[] newArray = DataUtil.concat(array, objectArray);
                FieldUtil.set(mp.field, k, newArray);
            }
            return true;
        }
        return false;
    }
}

