/*
 * Decompiled with CFR 0.152.
 */
package com.lishang.http.lifecycle;

import android.util.SparseArray;
import com.lishang.http.utils.LSLog;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.Call;

public class LSHttpLifecycleCallBacks {
    private ConcurrentMap<String, SparseArray<Call>> map = new ConcurrentHashMap<String, SparseArray<Call>>();

    public void put(String key, Call call) {
        SparseArray calls = (SparseArray)this.map.get(key);
        if (calls == null) {
            calls = new SparseArray();
        }
        calls.put(call.hashCode(), (Object)call);
        this.map.put(key, (SparseArray<Call>)calls);
        LSLog.i("LifecycleCallBacks class:" + key + "call bind success");
    }

    public void remove(String key, Call call) {
        SparseArray calls = (SparseArray)this.map.get(key);
        if (call != null && calls != null) {
            calls.delete(call.hashCode());
            LSLog.i("LifecycleCallBacks class:" + key + "  call " + call.request().url().toString() + " remove success");
        }
    }

    public void destroyed(String key) {
        SparseArray calls = (SparseArray)this.map.get(key);
        if (calls != null) {
            for (int i = 0; i < calls.size(); ++i) {
                Call call = (Call)calls.valueAt(i);
                if (call == null || call.isCanceled()) continue;
                call.cancel();
                LSLog.i("LifecycleCallBacks class:" + key + "  destroyed call " + call.request().url().toString() + " cancel success");
            }
            calls.clear();
            this.map.remove(key);
            LSLog.i("LifecycleCallBacks class:" + key + "  destroyed call remove success");
        }
    }
}

