/*
 * Decompiled with CFR 0.152.
 */
package com.lishang.http.exception;

import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializer;
import java.io.NotSerializableException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.ParseException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;

public class LSHttpException
extends Exception {
    public final int code;
    public String message;
    public int status;

    public LSHttpException(Throwable throwable, int code) {
        this(throwable, code, -1);
    }

    public LSHttpException(Throwable throwable, int code, int status) {
        super(throwable);
        this.code = code;
        this.message = throwable.getMessage();
        this.status = status;
    }

    public LSHttpException(int code, String message) {
        this(code, message, -1);
    }

    public LSHttpException(int code, String message, int status) {
        this.code = code;
        this.message = message;
        this.status = status;
    }

    public static LSHttpException handleException(Throwable e) {
        if (e instanceof SocketTimeoutException) {
            LSHttpException ex = new LSHttpException(e, 1001);
            ex.message = "\u7f51\u7edc\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
            return ex;
        }
        if (e instanceof ConnectException) {
            LSHttpException ex = new LSHttpException(e, 1001);
            ex.message = "\u7f51\u7edc\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
            return ex;
        }
        if (e instanceof ConnectTimeoutException) {
            LSHttpException ex = new LSHttpException(e, 1001);
            ex.message = "\u7f51\u7edc\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
            return ex;
        }
        if (e instanceof UnknownHostException) {
            LSHttpException ex = new LSHttpException(e, 1001);
            ex.message = "\u7f51\u7edc\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
            return ex;
        }
        if (e instanceof NullPointerException) {
            LSHttpException ex = new LSHttpException(e, 1002);
            ex.message = "\u7a7a\u6307\u9488\u5f02\u5e38";
            return ex;
        }
        if (e instanceof SSLHandshakeException) {
            LSHttpException ex = new LSHttpException(e, 1003);
            ex.message = "\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25";
            return ex;
        }
        if (e instanceof ClassCastException) {
            LSHttpException ex = new LSHttpException(e, 1004);
            ex.message = "\u7c7b\u578b\u8f6c\u6362\u9519\u8bef";
            return ex;
        }
        if (e instanceof JsonParseException || e instanceof JSONException || e instanceof JsonSerializer || e instanceof NotSerializableException || e instanceof ParseException) {
            LSHttpException ex = new LSHttpException(e, 1005);
            ex.message = "\u89e3\u6790\u9519\u8bef";
            return ex;
        }
        if (e instanceof IllegalStateException) {
            LSHttpException ex = new LSHttpException(e, 1006);
            ex.message = e.getMessage();
            return ex;
        }
        LSHttpException ex = new LSHttpException(e, 1000);
        ex.message = "\u672a\u77e5\u9519\u8bef";
        return ex;
    }

    public static class ERROR {
        public static final int UNKNOWN = 1000;
        public static final int TIMEOUT_ERROR = 1001;
        public static final int NULL_POINTER_EXCEPTION = 1002;
        public static final int SSL_ERROR = 1003;
        public static final int CAST_ERROR = 1004;
        public static final int PARSE_ERROR = 1005;
        public static final int ILLEGAL_STATE_ERROR = 1006;
        public static final int HTTP_ERROR = 1007;
    }
}

