/*
 * Decompiled with CFR 0.152.
 */
package com.lishang.http;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.lishang.http.https.HttpsUtils;
import com.lishang.http.lifecycle.LSHttpActivityLifecycleCallBacks;
import com.lishang.http.request.DownloadRequest;
import com.lishang.http.request.GetRequest;
import com.lishang.http.request.JsonRequest;
import com.lishang.http.request.MultipartRequest;
import com.lishang.http.request.PostRequest;
import com.lishang.http.utils.LSHttpLoggingInterceptor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class LSHttp {
    private OkHttpClient mClient;
    private Application application;
    private Handler mHandler;
    private LSHttpActivityLifecycleCallBacks lifecycleCallBacks;
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean isShowLog;
    private String baseUrl;

    public static GetRequest get(String url) {
        return (GetRequest)((GetRequest)new GetRequest().url(url)).addHeaders(LSHttp.getInstance().headers);
    }

    public static PostRequest post(String url) {
        return (PostRequest)((PostRequest)new PostRequest().url(url)).addHeaders(LSHttp.getInstance().headers);
    }

    public static DownloadRequest download(String url) {
        return (DownloadRequest)((DownloadRequest)new DownloadRequest(LSHttp.getInstance().mClient.newBuilder()).addHeaders(LSHttp.getInstance().headers)).url(url);
    }

    public static MultipartRequest multipart(String url) {
        return (MultipartRequest)((MultipartRequest)new MultipartRequest().url(url)).addHeaders(LSHttp.getInstance().headers);
    }

    public static JsonRequest json(String url) {
        return (JsonRequest)((JsonRequest)new JsonRequest().url(url)).addHeaders(LSHttp.getInstance().headers);
    }

    public static void cancelAll() {
        if (LSHttp.getInstance().mClient == null) {
            return;
        }
        LSHttp.getInstance().mClient.dispatcher().cancelAll();
    }

    public static void cancel(String tag) {
        if (LSHttp.getInstance().mClient == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return;
        }
        for (Call call : LSHttp.getInstance().mClient.dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : LSHttp.getInstance().mClient.dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public static LSHttp init(Application application) {
        LSHttp http = LSHttp.getInstance();
        if (http.lifecycleCallBacks == null) {
            http.lifecycleCallBacks = new LSHttpActivityLifecycleCallBacks();
        }
        if (http.application != null) {
            http.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)http.lifecycleCallBacks);
        }
        http.application = application;
        http.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)http.lifecycleCallBacks);
        return http;
    }

    public static LSHttp init(Application application, OkHttpClient client) {
        LSHttp http = LSHttp.init(application);
        http.mClient = client;
        return http;
    }

    public static LSHttp getInstance() {
        return Holder.INSTANCE;
    }

    private LSHttp() {
        this.mHandler = new Handler(Looper.getMainLooper());
        HttpsUtils.SSLParams sslParams = HttpsUtils.getSslSocketFactory();
        this.mClient = new OkHttpClient.Builder().writeTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).connectTimeout(15L, TimeUnit.SECONDS).addInterceptor((Interceptor)new LSHttpLoggingInterceptor().setLevel(LSHttpLoggingInterceptor.Level.BODY)).sslSocketFactory(sslParams.sSLSocketFactory, sslParams.trustManager).hostnameVerifier(HttpsUtils.UnSafeHostnameVerifier).build();
    }

    public LSHttp addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public LSHttp addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public LSHttp showLog(boolean show) {
        this.isShowLog = show;
        return this;
    }

    public LSHttp baseUrl(String url) {
        this.baseUrl = url;
        return this;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public OkHttpClient getClient() {
        return this.mClient;
    }

    public LSHttpActivityLifecycleCallBacks getLifecycleCallBacks() {
        return this.lifecycleCallBacks;
    }

    public boolean isShowLog() {
        return this.isShowLog;
    }

    public void runOnMainThread(Runnable runnable) {
        this.mHandler.post(runnable);
    }

    private static class Holder {
        static LSHttp INSTANCE = new LSHttp();

        private Holder() {
        }
    }
}

