/*
 * Decompiled with CFR 0.152.
 */
package com.lishang.http.request;

import android.net.Uri;
import android.text.TextUtils;
import com.lishang.http.callback.DownloadCallBack;
import com.lishang.http.exception.LSHttpException;
import com.lishang.http.request.BaseRequest;
import com.lishang.http.utils.LSLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class DownloadRequest
extends BaseRequest<DownloadRequest> {
    private OkHttpClient mClient;
    private String downFilePath;
    private DownloadCallBack downloadCallBack;
    private DownloadFile downloadFile;
    private long startPos;

    public DownloadRequest(OkHttpClient.Builder builder) {
        final ProgressListener listener = new ProgressListener(){
            boolean firstUpdate = true;

            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
                if (done) {
                    System.out.println("completed");
                    DownloadRequest.this.success(((DownloadRequest)DownloadRequest.this).downloadFile.file.getAbsolutePath());
                    DownloadRequest.this.downloadFile.close();
                } else {
                    if (this.firstUpdate) {
                        this.firstUpdate = false;
                        if (contentLength == -1L) {
                            System.out.println("content-length: unknown");
                        } else {
                            System.out.format("content-length: %d\n", contentLength);
                        }
                        DownloadRequest.this.start();
                    }
                    if (contentLength != -1L) {
                        int progress = (int)(100L * (bytesRead + DownloadRequest.this.startPos) / (contentLength + DownloadRequest.this.startPos));
                        System.out.format("%d%% done\n", progress);
                        DownloadRequest.this.loading(progress);
                    }
                }
            }

            @Override
            public void writeTo(byte[] bytes, int off, int len) {
                try {
                    DownloadRequest.this.downloadFile.write(bytes, off, len);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    DownloadRequest.this.downloadFile.cancel();
                    DownloadRequest.this.error(new LSHttpException(1007, "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25"));
                }
            }
        };
        this.mClient = builder.addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                if (originalResponse.isSuccessful()) {
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), listener)).build();
                }
                return originalResponse;
            }
        }).build();
    }

    public DownloadRequest path(String path) {
        this.downFilePath = path;
        return this;
    }

    @Override
    public Request generateRequest(Request.Builder builder) {
        this.startPos = this.downloadFile.size();
        builder.addHeader("RANGE", "bytes=" + this.startPos + "-");
        return builder.build();
    }

    @Override
    public void execute(final Object obj) {
        this.checkUrl();
        if (this.getCallBack() != null) {
            this.downloadCallBack = (DownloadCallBack)this.getCallBack();
        }
        if (TextUtils.isEmpty((CharSequence)this.downFilePath)) {
            this.downloadCallBack.onFail(new LSHttpException(1000, "\u4e0b\u8f7d\u8def\u5f84\u4e3a\u7a7a"));
            return;
        }
        try {
            this.downloadFile = new DownloadFile(this.downFilePath, this.url);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.downloadCallBack.onFail(new LSHttpException(1000, "\u4e0b\u8f7d\u8def\u5f84\u4e3a\u7a7a"));
            return;
        }
        Call call = this.mClient.newCall(this.generateRequest(this.request()));
        this.downloadFile.setCall(call);
        this.bindLifecycle(obj, call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                if (call.isCanceled()) {
                    System.out.println("call is canceled");
                    return;
                }
                DownloadRequest.this.error(LSHttpException.handleException(e));
                DownloadRequest.this.removeLifecycle(obj, call);
            }

            public void onResponse(Call call, Response response) throws IOException {
                DownloadRequest.this.removeLifecycle(obj, call);
                if (response.body().contentLength() == 0L) {
                    DownloadRequest.this.success(((DownloadRequest)DownloadRequest.this).downloadFile.file.getAbsolutePath());
                    return;
                }
                if (!response.isSuccessful()) {
                    DownloadRequest.this.error(new LSHttpException(1007, "\u8bf7\u6c42\u5931\u8d25\uff0c\u670d\u52a1\u5668\u5f00\u5c0f\u5dee...", response.code()));
                    return;
                }
            }
        });
    }

    private void start() {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (DownloadRequest.this.downloadCallBack != null) {
                    DownloadRequest.this.downloadCallBack.onStart();
                }
            }
        });
    }

    private void loading(final int progress) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (DownloadRequest.this.downloadCallBack != null) {
                    DownloadRequest.this.downloadCallBack.onLoading(progress);
                }
            }
        });
    }

    private void success(final String path) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (DownloadRequest.this.downloadCallBack != null) {
                    DownloadRequest.this.downloadCallBack.onSuccess(path);
                }
            }
        });
    }

    private void error(final Exception e) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (DownloadRequest.this.downloadCallBack != null) {
                    if (e instanceof LSHttpException) {
                        DownloadRequest.this.downloadCallBack.onFail((LSHttpException)e);
                    } else {
                        DownloadRequest.this.downloadCallBack.onFail(LSHttpException.handleException(e));
                    }
                }
            }
        });
    }

    private class DownloadFile {
        RandomAccessFile randomAccessFile;
        File file;
        Call call;

        public DownloadFile(String path, String url) throws FileNotFoundException {
            this.file = new File(path);
            if (!this.file.exists() && !path.contains(".")) {
                this.file.mkdirs();
            }
            if (this.file.isDirectory()) {
                List list = Uri.parse((String)url).getPathSegments();
                String name = list.size() != 0 ? (String)list.get(list.size() - 1) : System.currentTimeMillis() + "";
                this.file = new File(path, name);
            }
            this.randomAccessFile = new RandomAccessFile(this.file, "rwd");
            if (this.file.exists()) {
                this.seek(this.size());
            }
        }

        public void setCall(Call call) {
            this.call = call;
        }

        public void seek(long pos) {
            try {
                this.randomAccessFile.seek(pos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.randomAccessFile.write(bytes, off, len);
        }

        public void close() {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public long size() {
            if (this.file != null) {
                return this.file.length();
            }
            return 0L;
        }

        public void cancel() {
            this.call.cancel();
        }
    }

    static interface ProgressListener {
        public void update(long var1, long var3, boolean var5);

        public void writeTo(byte[] var1, int var2, int var3);
    }

    private static class ProgressResponseBody
    extends ResponseBody {
        private final ResponseBody responseBody;
        private final ProgressListener progressListener;
        private BufferedSource bufferedSource;

        ProgressResponseBody(ResponseBody responseBody, ProgressListener progressListener) {
            this.responseBody = responseBody;
            this.progressListener = progressListener;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() {
            return this.responseBody.contentLength();
        }

        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long totalBytesRead;
                {
                    this.totalBytesRead = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    boolean done;
                    long bytesRead = super.read(sink, byteCount);
                    boolean bl = done = bytesRead == -1L;
                    if (!done) {
                        byte[] bytes = sink.readByteArray();
                        ProgressResponseBody.this.progressListener.writeTo(bytes, 0, bytes.length);
                    }
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    LSLog.i("read size:" + this.totalBytesRead);
                    ProgressResponseBody.this.progressListener.update(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength(), done);
                    return bytesRead;
                }
            };
        }
    }
}

