/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat.ui.widgets;

import android.content.Context;
import android.content.Intent;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.v4.app.Fragment;
import android.support.v7.preference.Preference;
import android.text.TextUtils;

public class SoundTonePreference
extends Preference
implements Preference.OnPreferenceChangeListener {
    public static final int REQUEST_CODE_ALERT_RINGTONE = 1371;
    private final Fragment mParent;
    private String mValue;
    private boolean mValueSet;

    public SoundTonePreference(Context context, Fragment parent) {
        super(context);
        super.setPersistent(true);
        this.mParent = parent;
        this.updateSummary(this.getValue());
        this.setOnPreferenceChangeListener(this);
    }

    protected void onClick() {
        super.onClick();
        Intent intent = new Intent("android.intent.action.RINGTONE_PICKER");
        intent.putExtra("android.intent.extra.ringtone.TITLE", "Select Sound");
        intent.putExtra("android.intent.extra.ringtone.TYPE", 2);
        intent.putExtra("android.intent.extra.ringtone.SHOW_DEFAULT", true);
        intent.putExtra("android.intent.extra.ringtone.SHOW_SILENT", true);
        intent.putExtra("android.intent.extra.ringtone.DEFAULT_URI", (Parcelable)Settings.System.DEFAULT_NOTIFICATION_URI);
        String existingValue = this.getValue();
        if (existingValue != null) {
            if (existingValue.length() == 0) {
                intent.putExtra("android.intent.extra.ringtone.EXISTING_URI", (Parcelable)((Uri)null));
            } else {
                intent.putExtra("android.intent.extra.ringtone.EXISTING_URI", (Parcelable)Uri.parse((String)existingValue));
            }
        } else {
            intent.putExtra("android.intent.extra.ringtone.EXISTING_URI", (Parcelable)Settings.System.DEFAULT_NOTIFICATION_URI);
        }
        this.mParent.startActivityForResult(intent, 1371);
    }

    public boolean onPreferenceChange(Preference preference, Object o) {
        this.updateSummary((String)o);
        return true;
    }

    public void handleActivityResult(Intent data) {
        if (data != null) {
            Uri ringtone = (Uri)data.getParcelableExtra("android.intent.extra.ringtone.PICKED_URI");
            this.setValue(ringtone.toString());
            this.updateSummary(this.getValue());
        }
    }

    void updateSummary(String ringtone) {
        this.setSummary(ringtone == null ? "" : this.getToneTitle(Uri.parse((String)ringtone)));
    }

    public String getValue() {
        return this.mValue;
    }

    public void setValue(String value) {
        boolean changed;
        boolean bl = changed = !TextUtils.equals((CharSequence)this.mValue, (CharSequence)value);
        if (changed || !this.mValueSet) {
            this.mValue = value;
            this.mValueSet = true;
            this.persistString(value);
            if (changed) {
                this.notifyChanged();
            }
        }
    }

    protected void onSetInitialValue(Object defaultValue) {
        this.setValue(this.getPersistedString((String)defaultValue));
        this.updateSummary(this.getValue());
    }

    private String getToneTitle(Uri ringtone) {
        Ringtone tone;
        String title = "";
        if (ringtone != null && (tone = RingtoneManager.getRingtone((Context)this.getContext(), (Uri)ringtone)) != null) {
            title = tone.getTitle(this.getContext());
        }
        return title;
    }
}

