/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat.ui;

import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import android.support.v14.preference.SwitchPreference;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceCategory;
import android.support.v7.preference.PreferenceFragmentCompat;
import android.support.v7.preference.PreferenceManager;
import android.support.v7.preference.PreferenceScreen;
import android.support.v7.view.ContextThemeWrapper;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelCompat;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelGroupCompat;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelManagerHelper;
import com.lionscribe.open.notificationchannelcompat.R;
import com.lionscribe.open.notificationchannelcompat.ui.PreferencesChannelsSubFragment;
import com.lionscribe.open.notificationchannelcompat.ui.widgets.MasterCheckBoxPreference;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PreferencesChannelsMainFragment
extends PreferenceFragmentCompat {
    MasterCheckBoxPreference _openedChannelPref;

    public void onCreatePreferences(Bundle savedInstance, String rootPreferenceKey) {
        FragmentActivity activityContext = this.getActivity();
        PreferenceManager preferenceManager = this.getPreferenceManager();
        preferenceManager.setSharedPreferencesName("com.lionscribe.open.notificationchannelcompat_channel_prefs");
        PreferenceScreen preferenceScreen = preferenceManager.createPreferenceScreen((Context)activityContext);
        this.setPreferenceScreen(preferenceScreen);
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)activityContext, R.style.PreferenceThemeOverlay);
        PreferenceCategory preferenceCategory = new PreferenceCategory((Context)contextThemeWrapper);
        this.getPreferenceScreen().addPreference((Preference)preferenceCategory);
        SwitchPreference showNotificationsAll = new SwitchPreference((Context)contextThemeWrapper);
        showNotificationsAll.setTitle(R.string.app_notifications_switch_label);
        showNotificationsAll.setKey("channels_all_enabled");
        showNotificationsAll.setDefaultValue((Object)true);
        preferenceCategory.addPreference((Preference)showNotificationsAll);
        NotificationChannelManagerHelper notificationManagerHelper = new NotificationChannelManagerHelper(this.getContext(), (NotificationManager)this.getContext().getSystemService("notification"));
        List<NotificationChannelGroupCompat> groups = notificationManagerHelper.getNotificationChannelGroups();
        Collections.sort(groups, new Comparator<NotificationChannelGroupCompat>(){

            @Override
            public int compare(NotificationChannelGroupCompat obj1, NotificationChannelGroupCompat obj2) {
                return obj1.getName().toString().compareToIgnoreCase(obj2.getName().toString());
            }
        });
        List<NotificationChannelCompat> channels = notificationManagerHelper.getNotificationChannels();
        Collections.sort(channels, new Comparator<NotificationChannelCompat>(){

            @Override
            public int compare(NotificationChannelCompat obj1, NotificationChannelCompat obj2) {
                return obj1.getName().toString().compareToIgnoreCase(obj2.getName().toString());
            }
        });
        for (int g = 0; g <= groups.size(); ++g) {
            NotificationChannelGroupCompat group = g < groups.size() ? groups.get(g) : null;
            PreferenceCategory preferenceGroupCategory = null;
            for (NotificationChannelCompat channel : channels) {
                if (group != null ? !group.getId().equals(channel.getGroup()) : channel.getGroup() != null) continue;
                if (preferenceGroupCategory == null) {
                    preferenceGroupCategory = new PreferenceCategory((Context)contextThemeWrapper);
                    preferenceGroupCategory.setTitle(group == null ? this.getString(R.string.notification_channels_other) : group.getName());
                    this.getPreferenceScreen().addPreference((Preference)preferenceGroupCategory);
                    preferenceGroupCategory.setDependency("channels_all_enabled");
                    if (group != null) {
                        SwitchPreference showNotificationsGroup = new SwitchPreference((Context)contextThemeWrapper);
                        showNotificationsGroup.setTitle(R.string.app_notifications_switch_label);
                        showNotificationsGroup.setKey(NotificationChannelManagerHelper.makeKey("group_enabled_%s", group.getId()));
                        showNotificationsGroup.setDefaultValue((Object)true);
                        preferenceGroupCategory.addPreference((Preference)showNotificationsGroup);
                    }
                }
                final String channelId = channel.getId();
                MasterCheckBoxPreference channelPref = new MasterCheckBoxPreference((Context)contextThemeWrapper);
                channelPref.setTitle(channel.getName());
                channelPref.setKey(NotificationChannelManagerHelper.makeKey("channel_enabled_%s", channelId));
                channelPref.setDefaultValue(true);
                channelPref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                    public boolean onPreferenceClick(Preference preference) {
                        PreferencesChannelsMainFragment.this.getActivity().getSupportFragmentManager().beginTransaction().setTransition(4097).replace(R.id.settings_container, (Fragment)PreferencesChannelsSubFragment.newInstance(channelId), "ChannelsSubFragment").addToBackStack(null).commit();
                        PreferencesChannelsMainFragment.this._openedChannelPref = (MasterCheckBoxPreference)preference;
                        return true;
                    }
                });
                preferenceGroupCategory.addPreference((Preference)channelPref);
                if (group == null) continue;
                channelPref.setDependency(NotificationChannelManagerHelper.makeKey("group_enabled_%s", group.getId()));
            }
        }
    }

    public void onResume() {
        super.onResume();
        if (this._openedChannelPref != null) {
            this._openedChannelPref.setChecked(this.getPreferenceManager().getSharedPreferences().getBoolean(this._openedChannelPref.getKey(), true));
            this._openedChannelPref = null;
        }
    }
}

