/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelCompat;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelGroupCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class NotificationChannelManagerHelper {
    public static final String SHARED_PREFERENCE_NAME = "com.lionscribe.open.notificationchannelcompat_channel_prefs";
    public static final String PREF_KEY_CHANNELS_ALL_ENABLED = "channels_all_enabled";
    public static final String PREF_KEY_CHANNELS_IDS = "channels_ids";
    public static final String PREF_KEY_CHANNEL_NAME = "channel_name_%s";
    public static final String PREF_KEY_CHANNEL_DESCRIPTION = "channel_description_%s";
    public static final String PREF_KEY_CHANNEL_ENABLED = "channel_enabled_%s";
    public static final String PREF_KEY_CHANNEL_IMPORTANCE = "channel_importance_%s";
    public static final String PREF_KEY_CHANNEL_LOCKSCREENVISIBILITY = "channel_lockscreenVisibility_%s";
    public static final String PREF_KEY_CHANNEL_SOUND = "channel_sound_%s";
    public static final String PREF_KEY_CHANNEL_LIGHTS = "channel_lights_%s";
    public static final String PREF_KEY_CHANNEL_LIGHTCOLOR = "channel_lightColor_%s";
    public static final String PREF_KEY_CHANNEL_VIBRATION = "channel_vibration_%s";
    public static final String PREF_KEY_CHANNEL_VIBRATIONENABLED = "channel_vibrationEnabled_%s";
    public static final String PREF_KEY_CHANNEL_GROUP = "channel_group_%s";
    public static final String PREF_KEY_CHANNEL_AUDIOATTRIBUTESCONTENTTYPE = "channel_audioAttributes_ContentType%s";
    public static final String PREF_KEY_CHANNEL_AUDIOATTRIBUTESFLAGS = "channel_audioAttributesFlags_%s";
    public static final String PREF_KEY_CHANNEL_AUDIOATTRIBUTESUSAGE = "channel_audioAttributesUsage_%s";
    public static final String PREF_KEY_CHANNEL_AUDIOSTREAMTYPE = "channel_audioStreamTYpe_%s";
    public static final String PREF_KEY_GROUPS_IDS = "groups_ids";
    public static final String PREF_KEY_GROUP_NAME = "group_name_%s";
    public static final String PREF_KEY_GROUP_DESCRIPTION = "group_description_%s";
    public static final String PREF_KEY_GROUP_ENABLED = "group_enabled_%s";
    final NotificationManager _manager;
    final SharedPreferences _prefs;
    Set<String> _channelIds;
    Set<String> _groupIds;

    public NotificationChannelManagerHelper(Context context, NotificationManager manager) {
        this._manager = manager;
        this._prefs = context.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
        this._channelIds = this._prefs.getStringSet(PREF_KEY_CHANNELS_IDS, null);
        this._groupIds = this._prefs.getStringSet(PREF_KEY_GROUPS_IDS, null);
        if (this._channelIds == null) {
            this._channelIds = new ArraySet();
        }
        if (this._groupIds == null) {
            this._groupIds = new ArraySet();
        }
    }

    public static String makeKey(String pref, String id) {
        return String.format(pref, id);
    }

    @RequiresApi(api=26)
    private static List<NotificationChannelCompat> convertChannelListToCompat(List<NotificationChannel> originals) {
        ArrayList<NotificationChannelCompat> channels = new ArrayList<NotificationChannelCompat>(originals.size());
        for (NotificationChannel origin : originals) {
            channels.add(new NotificationChannelCompat(origin));
        }
        return channels;
    }

    @RequiresApi(api=26)
    private static List<NotificationChannel> convertChannelCompatToList(List<NotificationChannelCompat> originals) {
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>(originals.size());
        for (NotificationChannelCompat origin : originals) {
            channels.add(origin.getOreoVersion());
        }
        return channels;
    }

    @RequiresApi(api=26)
    private static List<NotificationChannelGroupCompat> convertGroupListToCompat(List<NotificationChannelGroup> originals) {
        ArrayList<NotificationChannelGroupCompat> channels = new ArrayList<NotificationChannelGroupCompat>(originals.size());
        for (NotificationChannelGroup origin : originals) {
            channels.add(new NotificationChannelGroupCompat(origin));
        }
        return channels;
    }

    @RequiresApi(api=26)
    private static List<NotificationChannelGroup> convertGroupCompatToList(List<NotificationChannelGroupCompat> originals) {
        ArrayList<NotificationChannelGroup> channels = new ArrayList<NotificationChannelGroup>(originals.size());
        for (NotificationChannelGroupCompat origin : originals) {
            channels.add(origin.getOreoVersion());
        }
        return channels;
    }

    public boolean isNotificationsEnabled() {
        return this._prefs.getBoolean(PREF_KEY_CHANNELS_ALL_ENABLED, true);
    }

    public void createNotificationChannelGroup(@NonNull NotificationChannelGroupCompat group) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._manager.createNotificationChannelGroup(group.getOreoVersion());
            return;
        }
        String groupId = group.getId();
        SharedPreferences.Editor editor = this._prefs.edit();
        if (!this._groupIds.contains(groupId)) {
            this._groupIds.add(groupId);
            editor.putStringSet(PREF_KEY_GROUPS_IDS, this._groupIds);
        }
        editor.putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_GROUP_NAME, groupId), group.getName().toString());
        editor.putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_GROUP_DESCRIPTION, groupId), group.getDescription());
        if (!this._prefs.contains(NotificationChannelManagerHelper.makeKey(PREF_KEY_GROUP_ENABLED, groupId))) {
            editor.putBoolean(NotificationChannelManagerHelper.makeKey(PREF_KEY_GROUP_ENABLED, groupId), group.isEnabled());
        }
        editor.apply();
    }

    public void createNotificationChannelGroups(@NonNull List<NotificationChannelGroupCompat> groups) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._manager.createNotificationChannelGroups(NotificationChannelManagerHelper.convertGroupCompatToList(groups));
            return;
        }
        for (NotificationChannelGroupCompat g : groups) {
            this.createNotificationChannelGroup(g);
        }
    }

    public void createNotificationChannel(@NonNull NotificationChannelCompat channel) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._manager.createNotificationChannel(channel.getOreoVersion());
            return;
        }
        String channelId = channel.getId();
        if (this._channelIds.contains(channelId)) {
            if (!channel.getName().equals(this.prefsGetString(PREF_KEY_CHANNEL_NAME, channelId, "Error"))) {
                this._prefs.edit().putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_NAME, channelId), channel.getName().toString()).apply();
            }
            if (!channel.getDescription().equals(this.prefsGetString(PREF_KEY_CHANNEL_DESCRIPTION, channelId, "Error"))) {
                this._prefs.edit().putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_DESCRIPTION, channelId), channel.getDescription()).apply();
            }
            return;
        }
        SharedPreferences.Editor editor = this._prefs.edit();
        this._channelIds.add(channelId);
        editor.putStringSet(PREF_KEY_CHANNELS_IDS, this._channelIds);
        editor.putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_NAME, channelId), channel.getName().toString());
        editor.putBoolean(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_ENABLED, channelId), channel.isEnabled());
        editor.putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_IMPORTANCE, channelId), Integer.toString(channel.getImportance()));
        editor.putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_DESCRIPTION, channelId), channel.getDescription());
        editor.putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_GROUP, channelId), channel.getGroup());
        editor.putInt(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_LOCKSCREENVISIBILITY, channelId), channel.getLockscreenVisibility());
        editor.putBoolean(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_LIGHTS, channelId), channel.shouldShowLights());
        editor.putInt(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_LIGHTCOLOR, channelId), channel.getLightColor());
        editor.putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_SOUND, channelId), channel.getSound().toString());
        if (Build.VERSION.SDK_INT >= 21 && this._prefs.contains(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_AUDIOATTRIBUTESCONTENTTYPE, channelId))) {
            editor.putInt(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_AUDIOATTRIBUTESCONTENTTYPE, channelId), channel.getAudioAttributes().getContentType());
            editor.putInt(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_AUDIOATTRIBUTESFLAGS, channelId), channel.getAudioAttributes().getFlags());
            editor.putInt(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_AUDIOATTRIBUTESUSAGE, channelId), channel.getAudioAttributes().getUsage());
        }
        editor.putInt(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_AUDIOSTREAMTYPE, channelId), channel.getAudioStreamType());
        editor.putBoolean(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_VIBRATIONENABLED, channelId), channel.shouldVibrate());
        long[] vibrationPattern = channel.getVibrationPattern();
        String vibrationPatternStr = null;
        if (vibrationPattern != null) {
            StringBuilder vibrationPatternBldr = new StringBuilder(vibrationPattern.length * 4);
            for (long val : vibrationPattern) {
                vibrationPatternBldr.append(Long.toString(val));
                vibrationPatternBldr.append(',');
            }
            vibrationPatternStr = vibrationPatternBldr.toString();
        }
        editor.putString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_VIBRATION, channelId), vibrationPatternStr);
        editor.apply();
    }

    public void createNotificationChannels(@NonNull List<NotificationChannelCompat> channels) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._manager.createNotificationChannels(NotificationChannelManagerHelper.convertChannelCompatToList(channels));
            return;
        }
        for (NotificationChannelCompat c : channels) {
            this.createNotificationChannel(c);
        }
    }

    public NotificationChannelCompat getNotificationChannel(String channelId) {
        Uri soundUri;
        if (Build.VERSION.SDK_INT >= 26) {
            return new NotificationChannelCompat(this._manager.getNotificationChannel(channelId));
        }
        if (!this._channelIds.contains(channelId)) {
            return null;
        }
        int importance = Integer.parseInt(this.prefsGetString(PREF_KEY_CHANNEL_IMPORTANCE, channelId, Integer.toString(3)));
        NotificationChannelCompat channel = new NotificationChannelCompat(channelId, this.prefsGetString(PREF_KEY_CHANNEL_NAME, channelId, "Error"), importance);
        channel.setDescription(this.prefsGetString(PREF_KEY_CHANNEL_DESCRIPTION, channelId, "None"));
        channel.setEnabled(this.prefsGetBoolean(PREF_KEY_CHANNEL_ENABLED, channelId, channel.isEnabled()));
        channel.setGroup(this.prefsGetString(PREF_KEY_CHANNEL_GROUP, channelId, null));
        channel.setLockscreenVisibility(this.prefsGetInt(PREF_KEY_CHANNEL_LOCKSCREENVISIBILITY, channelId, channel.getLockscreenVisibility()));
        channel.enableLights(this.prefsGetBoolean(PREF_KEY_CHANNEL_LIGHTS, channelId, channel.shouldShowLights()));
        channel.setLightColor(this.prefsGetInt(PREF_KEY_CHANNEL_LIGHTCOLOR, channelId, channel.getLightColor()));
        String soundUriStr = this.prefsGetString(PREF_KEY_CHANNEL_SOUND, channelId, null);
        Uri uri = soundUri = TextUtils.isEmpty((CharSequence)soundUriStr) ? null : Uri.parse((String)soundUriStr);
        if (Build.VERSION.SDK_INT >= 21 && this._prefs.contains(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_AUDIOATTRIBUTESCONTENTTYPE, channelId))) {
            AudioAttributes.Builder audioBuilder = new AudioAttributes.Builder();
            audioBuilder.setContentType(this.prefsGetInt(PREF_KEY_CHANNEL_AUDIOATTRIBUTESCONTENTTYPE, channelId, 0));
            audioBuilder.setFlags(this.prefsGetInt(PREF_KEY_CHANNEL_AUDIOATTRIBUTESFLAGS, channelId, 0));
            audioBuilder.setUsage(this.prefsGetInt(PREF_KEY_CHANNEL_AUDIOATTRIBUTESUSAGE, channelId, 0));
            channel.setSound(soundUri, audioBuilder.build());
        }
        channel.setSound(soundUri, this.prefsGetInt(PREF_KEY_CHANNEL_AUDIOSTREAMTYPE, channelId, channel.getAudioStreamType()));
        channel.enableVibration(this.prefsGetBoolean(PREF_KEY_CHANNEL_VIBRATIONENABLED, channelId, channel.shouldVibrate()));
        String vibrationPatternStr = this.prefsGetString(PREF_KEY_CHANNEL_VIBRATION, channelId, null);
        if (vibrationPatternStr != null) {
            String[] vibrationPatternStrArray = vibrationPatternStr.split(",");
            int length = vibrationPatternStrArray.length;
            long[] vibrationPattern = new long[length];
            for (int i = 0; i < length; ++i) {
                vibrationPattern[i] = Long.parseLong(vibrationPatternStrArray[i]);
            }
            channel.setVibrationPattern(vibrationPattern);
        }
        return channel;
    }

    public List<NotificationChannelCompat> getNotificationChannels() {
        if (Build.VERSION.SDK_INT >= 26) {
            return NotificationChannelManagerHelper.convertChannelListToCompat(this._manager.getNotificationChannels());
        }
        ArrayList<NotificationChannelCompat> list = new ArrayList<NotificationChannelCompat>(this._channelIds.size());
        for (String channelId : this._channelIds) {
            list.add(this.getNotificationChannel(channelId));
        }
        return list;
    }

    public void deleteNotificationChannel(String channelId) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._manager.deleteNotificationChannel(channelId);
            return;
        }
        if (this._channelIds.contains(channelId)) {
            this._channelIds.remove(channelId);
            this._prefs.edit().putStringSet(PREF_KEY_CHANNELS_IDS, this._channelIds).apply();
        }
    }

    public NotificationChannelGroupCompat getNotificationChannelGroup(String channelGroupId) {
        if (Build.VERSION.SDK_INT >= 28) {
            return new NotificationChannelGroupCompat(this._manager.getNotificationChannelGroup(channelGroupId));
        }
        if (Build.VERSION.SDK_INT >= 26) {
            for (NotificationChannelGroup group : this._manager.getNotificationChannelGroups()) {
                if (!group.getId().equals(channelGroupId)) continue;
                return new NotificationChannelGroupCompat(group);
            }
            return null;
        }
        if (!this._groupIds.contains(channelGroupId)) {
            return null;
        }
        NotificationChannelGroupCompat group = new NotificationChannelGroupCompat(channelGroupId, this.prefsGetString(PREF_KEY_GROUP_NAME, channelGroupId, "Error"));
        group.setEnabled(this.prefsGetBoolean(PREF_KEY_GROUP_ENABLED, channelGroupId, true));
        return group;
    }

    public List<NotificationChannelGroupCompat> getNotificationChannelGroups() {
        if (Build.VERSION.SDK_INT >= 26) {
            return NotificationChannelManagerHelper.convertGroupListToCompat(this._manager.getNotificationChannelGroups());
        }
        ArrayList<NotificationChannelGroupCompat> list = new ArrayList<NotificationChannelGroupCompat>(this._groupIds.size());
        for (String groupId : this._groupIds) {
            list.add(this.getNotificationChannelGroup(groupId));
        }
        return list;
    }

    public void deleteNotificationChannelGroup(String groupId) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._manager.deleteNotificationChannelGroup(groupId);
            return;
        }
        if (this._groupIds.contains(groupId)) {
            SharedPreferences.Editor editor = this._prefs.edit();
            for (String channelId : this._channelIds) {
                if (!this._prefs.getString(NotificationChannelManagerHelper.makeKey(PREF_KEY_CHANNEL_GROUP, channelId), "").equals(groupId)) continue;
                this._channelIds.remove(channelId);
            }
            this._groupIds.remove(groupId);
            editor.putStringSet(PREF_KEY_GROUPS_IDS, this._groupIds);
            editor.putStringSet(PREF_KEY_CHANNELS_IDS, this._channelIds);
            editor.apply();
        }
    }

    private String prefsGetString(String prefs, String id, String defaultValue) {
        return this._prefs.getString(NotificationChannelManagerHelper.makeKey(prefs, id), defaultValue);
    }

    private boolean prefsGetBoolean(String prefs, String id, boolean defaultValue) {
        return this._prefs.getBoolean(NotificationChannelManagerHelper.makeKey(prefs, id), defaultValue);
    }

    private int prefsGetInt(String prefs, String id, int defaultValue) {
        return this._prefs.getInt(NotificationChannelManagerHelper.makeKey(prefs, id), defaultValue);
    }
}

