/*
 * Decompiled with CFR 0.152.
 */
package com.lionscribe.open.notificationchannelcompat;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.res.Resources;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.CheckResult;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelGroupCompat;
import com.lionscribe.open.notificationchannelcompat.NotificationChannelManagerHelper;
import java.lang.reflect.Field;
import java.util.Arrays;

public final class NotificationChannelCompat
implements Parcelable {
    public static final Parcelable.Creator<NotificationChannelCompat> CREATOR = new Parcelable.Creator<NotificationChannelCompat>(){

        public NotificationChannelCompat createFromParcel(Parcel in) {
            return new NotificationChannelCompat(in);
        }

        public NotificationChannelCompat[] newArray(int size) {
            return new NotificationChannelCompat[size];
        }
    };
    static final String TAG = "ChannelsCompat";
    private static final int MAX_TEXT_LENGTH = 500;
    private static final int DEFAULT_LIGHT_COLOR = 0;
    private static final int DEFAULT_VISIBILITY = 0;
    private static final int DEFAULT_IMPORTANCE = -1000;
    private final String mId;
    private NotificationChannel _oreoNotificationChannel;
    private String mName;
    private String mDesc;
    private boolean mChannelEnabled = true;
    private int mImportance = -1000;
    private int mLockscreenVisibility = 0;
    private Uri mSound = Settings.System.DEFAULT_NOTIFICATION_URI;
    private boolean mLights;
    private int mLightColor = 0;
    private long[] mVibration;
    private boolean mVibrationEnabled;
    private String mGroup;
    private AudioAttributes mAudioAttributes = null;
    private int mAudioStreamType = -1;

    public NotificationChannelCompat(String id, CharSequence name, int importance) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel = new NotificationChannel(id, name, importance);
            this.mId = null;
        } else {
            this.mId = this.getTrimmedString(id);
            this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
            this.mImportance = importance;
        }
    }

    @RequiresApi(api=26)
    protected NotificationChannelCompat(NotificationChannel original) {
        this._oreoNotificationChannel = original;
        this.mId = null;
    }

    protected NotificationChannelCompat(Parcel in) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel = (NotificationChannel)in.readParcelable(NotificationChannel.class.getClassLoader());
            this.mId = null;
            return;
        }
        this.mId = in.readByte() != 0 ? in.readString() : null;
        this.mName = in.readByte() != 0 ? in.readString() : null;
        this.mDesc = in.readByte() != 0 ? in.readString() : null;
        this.mChannelEnabled = in.readByte() != 0;
        this.mImportance = in.readInt();
        this.mLockscreenVisibility = in.readInt();
        this.mSound = in.readByte() != 0 ? (Uri)Uri.CREATOR.createFromParcel(in) : null;
        this.mLights = in.readByte() != 0;
        this.mVibration = in.createLongArray();
        this.mVibrationEnabled = in.readByte() != 0;
        this.mGroup = in.readByte() != 0 ? in.readString() : null;
        boolean readAudioAttributes = in.readInt() > 0;
        this.mAudioAttributes = readAudioAttributes && Build.VERSION.SDK_INT >= 21 ? (AudioAttributes)AudioAttributes.CREATOR.createFromParcel(in) : null;
        this.mAudioStreamType = in.readInt();
        this.mLightColor = in.readInt();
    }

    @CheckResult
    public static boolean applyChannel(Context context, Notification notif, String channelId) {
        boolean permissionGrantedVibrate;
        NotificationChannelGroupCompat group;
        if (TextUtils.isEmpty((CharSequence)channelId)) {
            Log.w((String)TAG, (String)"Cannot create notification without channel set!");
            return false;
        }
        if (Build.VERSION.SDK_INT > 26) {
            if (!channelId.equals(notif.getChannelId())) {
                try {
                    Field f1 = notif.getClass().getSuperclass().getDeclaredField("mChannelId");
                    f1.setAccessible(true);
                    f1.set(notif, channelId);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"Must set Notification channel correctly before call to applyChannel");
                    return false;
                }
            }
            return true;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        NotificationChannelManagerHelper notificationManagerHelper = new NotificationChannelManagerHelper(context, notificationManager);
        if (!notificationManagerHelper.isNotificationsEnabled()) {
            Log.d((String)TAG, (String)"Notifications are disabled. Showing no notification!");
            return false;
        }
        NotificationChannelCompat channel = notificationManagerHelper.getNotificationChannel(channelId);
        if (channel == null) {
            Log.w((String)TAG, (String)("Cannot create notification with unknown channel \"" + channelId + "\"!"));
            return false;
        }
        if (!channel.isEnabled() || channel.getImportance() == 0) {
            Log.d((String)TAG, (String)"Channel is disabled. Showing no notification!");
            return false;
        }
        if (channel.getGroup() != null && (group = notificationManagerHelper.getNotificationChannelGroup(channel.getGroup())) != null && group.isBlocked()) {
            Log.d((String)TAG, (String)"Group is disabled. Showing no notification!");
            return false;
        }
        notif.defaults = 0;
        Uri uri = notif.sound = channel.getImportance() >= 3 ? channel.getSound() : null;
        if (Build.VERSION.SDK_INT >= 21 && channel.getAudioAttributes() != null) {
            notif.audioAttributes = channel.getAudioAttributes();
        } else {
            notif.audioStreamType = channel.getAudioStreamType();
        }
        boolean bl = permissionGrantedVibrate = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.VIBRATE") == 0;
        if (channel.shouldVibrate()) {
            if (channel.getVibrationPattern() != null && permissionGrantedVibrate) {
                notif.vibrate = channel.getVibrationPattern();
            } else if (permissionGrantedVibrate || Build.VERSION.SDK_INT >= 17) {
                notif.defaults += 2;
            } else {
                notif.vibrate = null;
            }
        } else if (Build.VERSION.SDK_INT >= 21 && channel.getImportance() == 4 && notif.sound == null) {
            if (permissionGrantedVibrate) {
                notif.vibrate = new long[0];
            } else {
                notif.defaults += 2;
            }
        } else {
            notif.vibrate = null;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            notif.priority = channel.getImportance() - 3;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            notif.visibility = channel.getLockscreenVisibility();
        }
        if (channel.shouldShowLights()) {
            notif.ledARGB = channel.getLightColor();
            if (notif.ledARGB == 0) {
                notif.defaults += 4;
            } else {
                try {
                    Resources resources = context.getResources();
                    Resources systemResources = Resources.getSystem();
                    notif.ledOnMS = resources.getInteger(systemResources.getIdentifier("config_defaultNotificationLedOn", "integer", "android"));
                    notif.ledOffMS = resources.getInteger(systemResources.getIdentifier("config_defaultNotificationLedOff", "integer", "android"));
                }
                catch (Exception e) {
                    notif.ledOnMS = 500;
                    notif.ledOffMS = 2000;
                }
            }
            notif.flags |= 1;
        } else {
            notif.flags &= 0xFFFFFFFE;
        }
        return true;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.writeToParcel(dest, flags);
            return;
        }
        if (this.mId != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mId);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mName != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mName);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mDesc != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mDesc);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeByte(this.mChannelEnabled ? (byte)1 : 0);
        dest.writeInt(this.mImportance);
        dest.writeInt(this.mLockscreenVisibility);
        if (this.mSound != null) {
            dest.writeByte((byte)1);
            this.mSound.writeToParcel(dest, 0);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeByte(this.mLights ? (byte)1 : 0);
        dest.writeLongArray(this.mVibration);
        dest.writeByte(this.mVibrationEnabled ? (byte)1 : 0);
        if (this.mGroup != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mGroup);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mAudioAttributes != null && Build.VERSION.SDK_INT >= 21) {
            dest.writeInt(1);
            this.mAudioAttributes.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mAudioStreamType);
        dest.writeInt(this.mLightColor);
    }

    private String getTrimmedString(String input) {
        if (input != null && input.length() > 500) {
            return input.substring(0, 500);
        }
        return input;
    }

    public void setShowBadge(boolean showBadge) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setShowBadge(showBadge);
        }
    }

    public void setSound(Uri sound, int streamType) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setSound(sound, null);
            return;
        }
        this.mSound = sound;
        this.mAudioStreamType = streamType;
    }

    @RequiresApi(api=21)
    public void setSound(Uri sound, AudioAttributes audioAttributes) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setSound(sound, audioAttributes);
            return;
        }
        this.mSound = sound;
        this.mAudioAttributes = audioAttributes;
    }

    public void enableLights(boolean lights) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.enableLights(lights);
            return;
        }
        this.mLights = lights;
    }

    public void enableVibration(boolean vibration) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.enableVibration(vibration);
            return;
        }
        this.mVibrationEnabled = vibration;
    }

    public void setBypassDnd(boolean bypassDnd) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setBypassDnd(bypassDnd);
        }
    }

    public String getId() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getId();
        }
        return this.mId;
    }

    public CharSequence getName() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getName();
        }
        return this.mName;
    }

    public void setName(CharSequence name) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setName(name);
            return;
        }
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
    }

    public String getDescription() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getDescription();
        }
        return this.mDesc;
    }

    public void setDescription(String description) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setDescription(description);
            return;
        }
        this.mDesc = this.getTrimmedString(description);
    }

    public int getImportance() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getImportance();
        }
        return this.mImportance;
    }

    public void setImportance(int importance) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setImportance(importance);
            return;
        }
        this.mImportance = importance;
    }

    public boolean canBypassDnd() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.canBypassDnd();
        }
        return false;
    }

    public Uri getSound() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getSound();
        }
        return this.mSound;
    }

    public void setSound(Uri sound) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setSound(sound, null);
            return;
        }
        this.mSound = sound;
        this.mAudioAttributes = null;
        this.mAudioStreamType = -1;
    }

    public int getAudioStreamType() {
        return this.mAudioStreamType;
    }

    public AudioAttributes getAudioAttributes() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getAudioAttributes();
        }
        return this.mAudioAttributes;
    }

    public boolean isEnabled() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getImportance() != 0;
        }
        return this.mChannelEnabled;
    }

    protected void setEnabled(boolean enabled) {
        this.mChannelEnabled = enabled;
    }

    public boolean shouldShowLights() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.shouldShowLights();
        }
        return this.mLights;
    }

    public int getLightColor() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getLightColor();
        }
        return this.mLightColor;
    }

    public void setLightColor(int argb) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setLightColor(argb);
            return;
        }
        this.mLightColor = argb;
    }

    public boolean shouldVibrate() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.shouldVibrate();
        }
        return this.mVibrationEnabled;
    }

    public long[] getVibrationPattern() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getVibrationPattern();
        }
        return this.mVibration;
    }

    public void setVibrationPattern(long[] vibrationPattern) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setVibrationPattern(vibrationPattern);
            return;
        }
        this.mVibrationEnabled = vibrationPattern != null && vibrationPattern.length > 0;
        this.mVibration = vibrationPattern;
    }

    public int getLockscreenVisibility() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getLockscreenVisibility();
        }
        return this.mLockscreenVisibility;
    }

    public void setLockscreenVisibility(int lockscreenVisibility) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setLockscreenVisibility(lockscreenVisibility);
            return;
        }
        this.mLockscreenVisibility = lockscreenVisibility;
    }

    public boolean canShowBadge() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.canShowBadge();
        }
        return false;
    }

    public String getGroup() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.getGroup();
        }
        return this.mGroup;
    }

    public void setGroup(String groupId) {
        if (Build.VERSION.SDK_INT >= 26) {
            this._oreoNotificationChannel.setGroup(groupId);
            return;
        }
        this.mGroup = groupId;
    }

    public int describeContents() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.describeContents();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannelCompat that = (NotificationChannelCompat)o;
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.equals((Object)that._oreoNotificationChannel);
        }
        if (this.getImportance() != that.getImportance()) {
            return false;
        }
        if (this.getLockscreenVisibility() != that.getLockscreenVisibility()) {
            return false;
        }
        if (this.mLights != that.mLights) {
            return false;
        }
        if (this.getLightColor() != that.getLightColor()) {
            return false;
        }
        if (this.mVibrationEnabled != that.mVibrationEnabled) {
            return false;
        }
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getDescription() != null ? !this.getDescription().equals(that.getDescription()) : that.getDescription() != null) {
            return false;
        }
        if (this.getSound() != null ? !this.getSound().equals((Object)that.getSound()) : that.getSound() != null) {
            return false;
        }
        if (!Arrays.equals(this.mVibration, that.mVibration)) {
            return false;
        }
        if (this.getGroup() != null ? !this.getGroup().equals(that.getGroup()) : that.getGroup() != null) {
            return false;
        }
        return this.getAudioAttributes() != null ? this.getAudioAttributes().equals((Object)that.getAudioAttributes()) : that.getAudioAttributes() == null;
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.hashCode();
        }
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = 31 * result + this.getImportance();
        result = 31 * result + this.getLockscreenVisibility();
        result = 31 * result + (this.getSound() != null ? this.getSound().hashCode() : 0);
        result = 31 * result + (this.mLights ? 1 : 0);
        result = 31 * result + this.getLightColor();
        result = 31 * result + Arrays.hashCode(this.mVibration);
        result = 31 * result + (this.mVibrationEnabled ? 1 : 0);
        result = 31 * result + (this.getGroup() != null ? this.getGroup().hashCode() : 0);
        result = 31 * result + (this.getAudioAttributes() != null ? this.getAudioAttributes().hashCode() : 0);
        return result;
    }

    public String toString() {
        if (Build.VERSION.SDK_INT >= 26) {
            return this._oreoNotificationChannel.toString();
        }
        return "NotificationChannelCompat{mId='" + this.mId + '\'' + ", mName=" + this.mName + ", mDescription=" + (!TextUtils.isEmpty((CharSequence)this.mDesc) ? "hasDescription " : "") + ", mImportance=" + this.mImportance + ", mLockscreenVisibility=" + this.mLockscreenVisibility + ", mSound=" + this.mSound + ", mLights=" + this.mLights + ", mLightColor=" + this.mLightColor + ", mVibration=" + Arrays.toString(this.mVibration) + ", mVibrationEnabled=" + this.mVibrationEnabled + ", mGroup='" + this.mGroup + '\'' + ", mAudioAttributes=" + this.mAudioAttributes + ", mAudioStreamType=" + this.mAudioStreamType + '}';
    }

    @RequiresApi(api=26)
    NotificationChannel getOreoVersion() {
        return this._oreoNotificationChannel;
    }
}

