/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls.detection;

import com.linkedin.urls.detection.CharUtils;

public class InputTextReader {
    protected static final int MAX_BACKTRACK_MULTIPLIER = 10;
    private final char[] _content;
    private int _index = 0;
    private int _backtracked = 0;
    private static final int MINIMUM_BACKTRACK_LENGTH = 20;

    public InputTextReader(String content) {
        this._content = content.toCharArray();
    }

    public char read() {
        char chr;
        return CharUtils.isWhiteSpace(chr = this._content[this._index++]) ? (char)' ' : chr;
    }

    public String peek(int numberChars) {
        return new String(this._content, this._index, numberChars);
    }

    public char peekChar(int offset) {
        if (!this.canReadChars(offset)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._content[this._index + offset];
    }

    public boolean canReadChars(int numberChars) {
        return this._content.length >= this._index + numberChars;
    }

    public boolean eof() {
        return this._content.length <= this._index;
    }

    public int getPosition() {
        return this._index;
    }

    public int getBacktrackedCount() {
        return this._backtracked;
    }

    public void seek(int position) {
        int backtrackLength = Math.max(this._index - position, 0);
        this._backtracked += backtrackLength;
        this._index = position;
        this.checkBacktrackLoop(backtrackLength);
    }

    public void goBack() {
        ++this._backtracked;
        --this._index;
        this.checkBacktrackLoop(1);
    }

    private void checkBacktrackLoop(int backtrackLength) {
        if (this._backtracked > this._content.length * 10) {
            int start;
            if (backtrackLength < 20) {
                backtrackLength = 20;
            }
            if ((start = Math.max(this._index, 0)) + backtrackLength > this._content.length) {
                backtrackLength = this._content.length - start;
            }
            String badText = new String(this._content, start, backtrackLength);
            throw new NegativeArraySizeException("Backtracked max amount of characters. Endless loop detected. Bad Text: '" + badText + "'");
        }
    }
}

