/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls.detection;

import com.linkedin.urls.detection.CharUtils;
import com.linkedin.urls.detection.InputTextReader;
import com.linkedin.urls.detection.UrlDetectorOptions;

public class DomainNameReader {
    private static final int MIN_TOP_LEVEL_DOMAIN = 2;
    private static final int MAX_TOP_LEVEL_DOMAIN = 22;
    private static final long MAX_NUMERIC_DOMAIN_VALUE = 0xFFFFFFFFL;
    private static final long MIN_NUMERIC_DOMAIN_VALUE = 0x1010100L;
    private static final int MIN_IP_PART = 0;
    private static final int MAX_IP_PART = 255;
    private static final int INTERNATIONAL_CHAR_START = 192;
    private static final int MAX_LABEL_LENGTH = 64;
    private static final int MAX_NUMBER_LABELS = 127;
    private static final int MAX_DOMAIN_LENGTH = 255;
    private static final String HEX_ENCODED_DOT = "2e";
    private StringBuilder _buffer;
    private String _current;
    private UrlDetectorOptions _options;
    private int _dots = 0;
    private int _currentLabelLength = 0;
    private int _topLevelLength = 0;
    private int _startDomainName = 0;
    private boolean _numeric = false;
    private boolean _seenBracket = false;
    private boolean _seenCompleteBracketSet = false;
    private boolean _zoneIndex = false;
    private final InputTextReader _reader;
    private final CharacterHandler _characterHandler;

    public DomainNameReader(InputTextReader reader, StringBuilder buffer, String current, UrlDetectorOptions options, CharacterHandler characterHandler) {
        this._buffer = buffer;
        this._current = current;
        this._reader = reader;
        this._options = options;
        this._characterHandler = characterHandler;
    }

    private ReaderNextState readCurrent() {
        if (this._current != null) {
            if (this._current.length() == 1 && CharUtils.isDot(this._current.charAt(0))) {
                return ReaderNextState.InvalidDomainName;
            }
            if (this._current.length() == 3 && this._current.equalsIgnoreCase("%2e")) {
                return ReaderNextState.InvalidDomainName;
            }
            this._startDomainName = this._buffer.length() - this._current.length();
            this._numeric = true;
            int newStart = 0;
            char[] currArray = this._current.toCharArray();
            int length = currArray.length;
            boolean isAllHexSoFar = length > 2 && currArray[0] == '0' && (currArray[1] == 'x' || currArray[1] == 'X');
            boolean done = false;
            for (int index = isAllHexSoFar ? 2 : 0; index < length && !done; ++index) {
                char curr = currArray[index];
                this._topLevelLength = ++this._currentLabelLength;
                if (this._currentLabelLength > 64) {
                    return ReaderNextState.InvalidDomainName;
                }
                if (CharUtils.isDot(curr)) {
                    ++this._dots;
                    this._currentLabelLength = 0;
                    continue;
                }
                if (curr == '[') {
                    this._seenBracket = true;
                    this._numeric = false;
                    continue;
                }
                if (curr == '%' && index + 2 < length && CharUtils.isHex(currArray[index + 1]) && CharUtils.isHex(currArray[index + 2])) {
                    if (currArray[index + 1] == '2' && currArray[index + 2] == 'e') {
                        ++this._dots;
                        this._currentLabelLength = 0;
                    } else {
                        this._numeric = false;
                    }
                    index += 2;
                    continue;
                }
                if (isAllHexSoFar) {
                    if (CharUtils.isHex(curr)) continue;
                    this._numeric = false;
                    isAllHexSoFar = false;
                    --index;
                    continue;
                }
                if (CharUtils.isAlpha(curr) || curr == '-' || curr >= '\u00c0') {
                    this._numeric = false;
                    continue;
                }
                if (CharUtils.isNumeric(curr) || this._options.hasFlag(UrlDetectorOptions.ALLOW_SINGLE_LEVEL_DOMAIN)) continue;
                newStart = index + 1;
                this._currentLabelLength = 0;
                this._topLevelLength = 0;
                this._numeric = true;
                this._dots = 0;
                done = true;
            }
            if (newStart > 0) {
                if (newStart < this._current.length()) {
                    this._buffer.replace(0, this._buffer.length(), this._current.substring(newStart));
                    this._startDomainName = 0;
                }
                if (newStart >= this._current.length() || this._buffer.toString().equals(".")) {
                    return ReaderNextState.InvalidDomainName;
                }
            }
        } else {
            this._startDomainName = this._buffer.length();
        }
        return ReaderNextState.ValidDomainName;
    }

    public ReaderNextState readDomainName() {
        if (this.readCurrent() == ReaderNextState.InvalidDomainName) {
            return ReaderNextState.InvalidDomainName;
        }
        boolean done = false;
        while (!done && !this._reader.eof()) {
            char curr = this._reader.read();
            if (curr == '/') {
                return this.checkDomainNameValid(ReaderNextState.ReadPath, Character.valueOf(curr));
            }
            if (curr == ':' && (!this._seenBracket || this._seenCompleteBracketSet)) {
                return this.checkDomainNameValid(ReaderNextState.ReadPort, Character.valueOf(curr));
            }
            if (curr == '?') {
                return this.checkDomainNameValid(ReaderNextState.ReadQueryString, Character.valueOf(curr));
            }
            if (curr == '#') {
                return this.checkDomainNameValid(ReaderNextState.ReadFragment, Character.valueOf(curr));
            }
            if (CharUtils.isDot(curr) || curr == '%' && this._reader.canReadChars(2) && this._reader.peek(2).equalsIgnoreCase(HEX_ENCODED_DOT)) {
                if (this._currentLabelLength < 1) {
                    done = true;
                    continue;
                }
                this._buffer.append(curr);
                if (!CharUtils.isDot(curr)) {
                    this._buffer.append(this._reader.read());
                    this._buffer.append(this._reader.read());
                }
                if (!this._zoneIndex) {
                    ++this._dots;
                    this._currentLabelLength = 0;
                }
                if (this._currentLabelLength < 64) continue;
                return ReaderNextState.InvalidDomainName;
            }
            if (this._seenBracket && (CharUtils.isHex(curr) || curr == ':' || curr == '[' || curr == ']' || curr == '%') && !this._seenCompleteBracketSet) {
                switch (curr) {
                    case ':': {
                        this._currentLabelLength = 0;
                        break;
                    }
                    case '[': {
                        this._reader.goBack();
                        return ReaderNextState.InvalidDomainName;
                    }
                    case ']': {
                        this._seenCompleteBracketSet = true;
                        this._zoneIndex = false;
                        break;
                    }
                    case '%': {
                        this._zoneIndex = true;
                        break;
                    }
                    default: {
                        ++this._currentLabelLength;
                    }
                }
                this._numeric = false;
                this._buffer.append(curr);
                continue;
            }
            if (CharUtils.isAlphaNumeric(curr) || curr == '-' || curr >= '\u00c0') {
                if (this._seenCompleteBracketSet) {
                    this._reader.goBack();
                    done = true;
                    continue;
                }
                if (curr != 'x' && curr != 'X' && !CharUtils.isNumeric(curr)) {
                    this._numeric = false;
                }
                this._buffer.append(curr);
                this._topLevelLength = ++this._currentLabelLength;
                continue;
            }
            if (curr == '[' && !this._seenBracket) {
                this._seenBracket = true;
                this._numeric = false;
                this._buffer.append(curr);
                continue;
            }
            if (curr == '[' && this._seenCompleteBracketSet) {
                this._reader.goBack();
                done = true;
                continue;
            }
            if (curr == '%' && this._reader.canReadChars(2) && CharUtils.isHex(this._reader.peekChar(0)) && CharUtils.isHex(this._reader.peekChar(1))) {
                this._buffer.append(curr);
                this._buffer.append(this._reader.read());
                this._buffer.append(this._reader.read());
                this._currentLabelLength += 3;
                this._topLevelLength = this._currentLabelLength;
                continue;
            }
            this._characterHandler.addCharacter(curr);
            done = true;
        }
        return this.checkDomainNameValid(ReaderNextState.ValidDomainName, null);
    }

    private ReaderNextState checkDomainNameValid(ReaderNextState validState, Character lastChar) {
        boolean valid = false;
        int lastDotLength = this._buffer.length() > 3 && this._buffer.substring(this._buffer.length() - 3).equalsIgnoreCase("%2e") ? 3 : 1;
        int domainLength = this._buffer.length() - this._startDomainName + (this._currentLabelLength > 0 ? lastDotLength : 0);
        int dotCount = this._dots + (this._currentLabelLength > 0 ? 1 : 0);
        if (domainLength >= 255 || dotCount > 127) {
            valid = false;
        } else if (this._numeric) {
            String testDomain = this._buffer.substring(this._startDomainName).toLowerCase();
            valid = this.isValidIpv4(testDomain);
        } else if (this._seenBracket) {
            String testDomain = this._buffer.substring(this._startDomainName).toLowerCase();
            valid = this.isValidIpv6(testDomain);
        } else if (this._currentLabelLength > 0 && this._dots >= 1 || this._dots >= 2 && this._currentLabelLength == 0 || this._options.hasFlag(UrlDetectorOptions.ALLOW_SINGLE_LEVEL_DOMAIN) && this._dots == 0) {
            String topLevelStart;
            int topStart = this._buffer.length() - this._topLevelLength;
            if (this._currentLabelLength == 0) {
                --topStart;
            }
            boolean bl = valid = (topLevelStart = this._buffer.substring(topStart = Math.max(topStart, 0), topStart + Math.min(4, this._buffer.length() - topStart))).equalsIgnoreCase("xn--") || this._topLevelLength >= 2 && this._topLevelLength <= 22;
        }
        if (valid) {
            if (lastChar != null) {
                this._buffer.append(lastChar);
            }
            return validState;
        }
        this._reader.goBack();
        return ReaderNextState.InvalidDomainName;
    }

    private boolean isValidIpv4(String testDomain) {
        boolean valid = false;
        if (testDomain.length() > 0) {
            if (this._dots == 0) {
                try {
                    long value = testDomain.length() > 2 && testDomain.charAt(0) == '0' && testDomain.charAt(1) == 'x' ? Long.parseLong(testDomain.substring(2), 16) : (testDomain.charAt(0) == '0' ? Long.parseLong(testDomain.substring(1), 8) : Long.parseLong(testDomain));
                    valid = value <= 0xFFFFFFFFL && value >= 0x1010100L;
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
            } else if (this._dots == 3) {
                String[] parts = CharUtils.splitByDot(testDomain);
                valid = true;
                for (int i = 0; i < parts.length && valid; ++i) {
                    String part = parts[i];
                    if (part.length() > 0) {
                        Integer section;
                        int base;
                        String parsedNum;
                        if (part.length() > 2 && part.charAt(0) == '0' && part.charAt(1) == 'x') {
                            parsedNum = part.substring(2);
                            base = 16;
                        } else if (part.charAt(0) == '0') {
                            parsedNum = part.substring(1);
                            base = 8;
                        } else {
                            parsedNum = part;
                            base = 10;
                        }
                        if (parsedNum.length() == 0) {
                            section = 0;
                        } else {
                            try {
                                section = Integer.parseInt(parsedNum, base);
                            }
                            catch (NumberFormatException e) {
                                return false;
                            }
                        }
                        if (section >= 0 && section <= 255) continue;
                        valid = false;
                        continue;
                    }
                    valid = false;
                }
            }
        }
        return valid;
    }

    private boolean isValidIpv6(String testDomain) {
        char[] domainArray = testDomain.toCharArray();
        if (domainArray.length < 3 || domainArray[domainArray.length - 1] != ']' || domainArray[0] != '[' || domainArray[1] == ':' && domainArray[2] != ':') {
            return false;
        }
        int numSections = 1;
        int hexDigits = 0;
        int prevChar = 0;
        StringBuilder lastSection = new StringBuilder();
        Boolean hexSection = true;
        boolean zoneIndiceMode = false;
        boolean doubleColonFlag = false;
        for (int index = 0; index < domainArray.length; ++index) {
            switch (domainArray[index]) {
                case '[': {
                    break;
                }
                case '%': 
                case ']': {
                    if (domainArray[index] == '%') {
                        if (domainArray.length - index >= 2 && domainArray[index + 1] == '2' && domainArray[index + 2] == 'e') {
                            lastSection.append("%2e");
                            index += 2;
                            hexSection = false;
                            break;
                        }
                        zoneIndiceMode = true;
                    }
                    if (hexSection.booleanValue() || zoneIndiceMode && domainArray[index] != '%') break;
                    if (this.isValidIpv4(lastSection.toString())) {
                        ++numSections;
                        break;
                    }
                    return false;
                }
                case ':': {
                    if (prevChar == 58) {
                        if (doubleColonFlag) {
                            return false;
                        }
                        doubleColonFlag = true;
                    }
                    if (!hexSection.booleanValue()) {
                        return false;
                    }
                    hexSection = true;
                    hexDigits = 0;
                    ++numSections;
                    lastSection.delete(0, lastSection.length());
                    break;
                }
                default: {
                    if (zoneIndiceMode) {
                        if (CharUtils.isUnreserved(domainArray[index])) break;
                        return false;
                    }
                    lastSection.append(domainArray[index]);
                    if (hexSection.booleanValue() && CharUtils.isHex(domainArray[index])) {
                        ++hexDigits;
                        break;
                    }
                    hexSection = false;
                }
            }
            if (hexDigits > 4 || numSections > 8) {
                return false;
            }
            prevChar = domainArray[index];
        }
        return numSections != 1 && (numSections >= 8 || doubleColonFlag);
    }

    static interface CharacterHandler {
        public void addCharacter(char var1);
    }

    public static enum ReaderNextState {
        InvalidDomainName,
        ValidDomainName,
        ReadFragment,
        ReadPath,
        ReadPort,
        ReadQueryString;

    }
}

