/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls.detection;

import com.linkedin.urls.detection.InputTextReader;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class CharUtils {
    public static boolean isHex(char a) {
        return a >= '0' && a <= '9' || a >= 'a' && a <= 'f' || a >= 'A' && a <= 'F';
    }

    public static boolean isAlpha(char a) {
        return a >= 'a' && a <= 'z' || a >= 'A' && a <= 'Z';
    }

    public static boolean isNumeric(char a) {
        return a >= '0' && a <= '9';
    }

    public static boolean isAlphaNumeric(char a) {
        return CharUtils.isAlpha(a) || CharUtils.isNumeric(a);
    }

    public static boolean isUnreserved(char a) {
        return CharUtils.isAlphaNumeric(a) || a == '-' || a == '.' || a == '_' || a == '~';
    }

    public static boolean isDot(char a) {
        return a == '.' || a == '\u3002' || a == '\uff0e' || a == '\uff61';
    }

    public static boolean isWhiteSpace(char a) {
        return a == '\n' || a == '\t' || a == '\r' || a == ' ';
    }

    public static String[] splitByDot(String input) {
        ArrayList<String> splitList = new ArrayList<String>();
        StringBuilder section = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)input)) {
            return new String[]{""};
        }
        InputTextReader reader = new InputTextReader(input);
        while (!reader.eof()) {
            char curr = reader.read();
            if (CharUtils.isDot(curr)) {
                splitList.add(section.toString());
                section.setLength(0);
                continue;
            }
            if (curr == '%' && reader.canReadChars(2) && reader.peek(2).equalsIgnoreCase("2e")) {
                reader.read();
                reader.read();
                splitList.add(section.toString());
                section.setLength(0);
                continue;
            }
            section.append(curr);
        }
        splitList.add(section.toString());
        return splitList.toArray(new String[splitList.size()]);
    }

    private CharUtils() {
    }
}

