/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls;

import com.linkedin.urls.HostNormalizer;
import com.linkedin.urls.PathNormalizer;
import com.linkedin.urls.Url;
import com.linkedin.urls.UrlMarker;
import java.net.MalformedURLException;

public class NormalizedUrl
extends Url {
    private boolean _isPopulated = false;
    private byte[] _hostBytes;

    public NormalizedUrl(UrlMarker urlMarker) {
        super(urlMarker);
    }

    public static NormalizedUrl create(String url) throws MalformedURLException {
        return Url.create(url).normalize();
    }

    @Override
    public String getHost() {
        if (this.getRawHost() == null) {
            this.populateHostAndHostBytes();
        }
        return this.getRawHost();
    }

    @Override
    public String getPath() {
        if (this.getRawPath() == null) {
            this.setRawPath(new PathNormalizer().normalizePath(super.getPath()));
        }
        return this.getRawPath();
    }

    @Override
    public byte[] getHostBytes() {
        if (this._hostBytes == null) {
            this.populateHostAndHostBytes();
        }
        return this._hostBytes;
    }

    private void populateHostAndHostBytes() {
        if (!this._isPopulated) {
            HostNormalizer hostNormalizer = new HostNormalizer(super.getHost());
            this.setRawHost(hostNormalizer.getNormalizedHost());
            this._hostBytes = hostNormalizer.getBytes();
            this._isPopulated = true;
        }
    }
}

