/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls;

import com.linkedin.urls.UrlUtil;
import com.linkedin.urls.detection.CharUtils;
import java.net.IDN;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class HostNormalizer {
    private static final long MAX_NUMERIC_DOMAIN_VALUE = 0xFFFFFFFFL;
    private static final int MAX_IPV4_PART = 255;
    private static final int MIN_IP_PART = 0;
    private static final int MAX_IPV6_PART = 65535;
    private static final int IPV4_MAPPED_IPV6_START_OFFSET = 12;
    private static final int NUMBER_BYTES_IN_IPV4 = 4;
    private byte[] _bytes;
    private String _host;
    private String _normalizedHost;

    public HostNormalizer(String host) {
        this._host = host;
        this._bytes = null;
        this.normalizeHost();
    }

    private void normalizeHost() {
        String host;
        if (StringUtils.isEmpty((CharSequence)this._host)) {
            return;
        }
        try {
            host = IDN.toASCII(this._host);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        host = host.toLowerCase();
        host = UrlUtil.decode(host);
        this._bytes = this.tryDecodeHostToIp(host);
        if (this._bytes != null) {
            try {
                InetAddress address = InetAddress.getByAddress(this._bytes);
                String ipAddress = address.getHostAddress();
                host = address instanceof Inet6Address ? "[" + ipAddress + "]" : ipAddress;
            }
            catch (UnknownHostException e) {
                return;
            }
        }
        if (StringUtils.isEmpty((CharSequence)host)) {
            return;
        }
        host = UrlUtil.removeExtraDots(host);
        this._normalizedHost = UrlUtil.encode(host).replace("\\x", "%");
    }

    private byte[] tryDecodeHostToIp(String host) {
        if (host.startsWith("[") && host.endsWith("]")) {
            return this.tryDecodeHostToIPv6(host);
        }
        return this.tryDecodeHostToIPv4(host);
    }

    private byte[] tryDecodeHostToIPv4(String host) {
        String[] parts = CharUtils.splitByDot(host);
        int numParts = parts.length;
        if (numParts != 4 && numParts != 1) {
            return null;
        }
        byte[] bytes = new byte[16];
        bytes[10] = -1;
        bytes[11] = -1;
        for (int i = 0; i < parts.length; ++i) {
            Long section;
            int base;
            String parsedNum;
            if (parts[i].startsWith("0x")) {
                parsedNum = parts[i].substring(2);
                base = 16;
            } else if (parts[i].startsWith("0")) {
                parsedNum = parts[i].substring(1);
                base = 8;
            } else {
                parsedNum = parts[i];
                base = 10;
            }
            try {
                section = parsedNum.isEmpty() ? 0L : Long.parseLong(parsedNum, base);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (numParts == 4 && section > 255L || numParts == 1 && section > 0xFFFFFFFFL || section < 0L) {
                return null;
            }
            if (numParts != 4) {
                int index = 12;
                bytes[index++] = (byte)(section >> 24 & 0xFFL);
                bytes[index++] = (byte)(section >> 16 & 0xFFL);
                bytes[index++] = (byte)(section >> 8 & 0xFFL);
                bytes[index] = (byte)(section & 0xFFL);
                return bytes;
            }
            bytes[12 + i] = section.byteValue();
        }
        return bytes;
    }

    private byte[] tryDecodeHostToIPv6(String host) {
        String ip = host.substring(1, host.length() - 1);
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(ip.split(":", -1)));
        if (parts.size() < 3) {
            return null;
        }
        String lastPart = (String)parts.get(parts.size() - 1);
        int zoneIndexStart = lastPart.lastIndexOf("%");
        String lastPartWithoutZoneIndex = zoneIndexStart == -1 ? lastPart : lastPart.substring(0, zoneIndexStart);
        byte[] ipv4Address = null;
        if (!HostNormalizer.isHexSection(lastPartWithoutZoneIndex)) {
            ipv4Address = this.tryDecodeHostToIPv4(lastPartWithoutZoneIndex);
        }
        byte[] bytes = new byte[16];
        int totalSize = ipv4Address == null ? 8 : 6;
        int numberOfFilledZeroes = 0;
        int size = ipv4Address == null ? parts.size() : parts.size() - 1;
        for (int i = 0; i < size; ++i) {
            Integer section;
            int lenPart = ((String)parts.get(i)).length();
            if (lenPart == 0 && i != 0 && i != parts.size() - 1) {
                numberOfFilledZeroes = totalSize - size;
                for (int k = i; k < numberOfFilledZeroes + i; ++k) {
                    System.arraycopy(HostNormalizer.sectionToTwoBytes(0), 0, bytes, k * 2, 2);
                }
            }
            try {
                section = lenPart == 0 ? 0 : Integer.parseInt((String)parts.get(i), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (section > 65535 || section < 0) {
                return null;
            }
            System.arraycopy(HostNormalizer.sectionToTwoBytes(section), 0, bytes, (numberOfFilledZeroes + i) * 2, 2);
        }
        if (ipv4Address != null) {
            System.arraycopy(ipv4Address, 12, bytes, 12, 4);
        }
        return bytes;
    }

    private static boolean isHexSection(String section) {
        for (int i = 0; i < section.length(); ++i) {
            if (CharUtils.isHex(section.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static byte[] sectionToTwoBytes(int section) {
        byte[] bytes = new byte[]{(byte)(section >> 8 & 0xFF), (byte)(section & 0xFF)};
        return bytes;
    }

    protected byte[] getBytes() {
        return this._bytes;
    }

    protected String getNormalizedHost() {
        return this._normalizedHost;
    }
}

