/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.wheel.internal;

import com.linkedin.gradle.python.wheel.AbiDetails;
import com.linkedin.gradle.python.wheel.EditablePythonAbiContainer;
import com.linkedin.gradle.python.wheel.PythonAbiContainer;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DefaultPythonAbiContainer
implements EditablePythonAbiContainer,
PythonAbiContainer,
Serializable {
    private static final Logger logger = Logging.getLogger(PythonAbiContainer.class);
    private List<AbiDetails> supportedAbis = new ArrayList<AbiDetails>();

    @Override
    public void addSupportedAbi(AbiDetails triple) {
        this.supportedAbis.add(triple);
        logger.debug("Available ABI's: {}", this.supportedAbis);
    }

    @Override
    public boolean matchesSupportedVersion(File pythonExecutable, String pythonTag, String abiTag, String platformTag) {
        String[] pythonTags = pythonTag.split("\\.");
        String[] abiTags = abiTag.split("\\.");
        String[] platformTags = platformTag.split("\\.");
        return this.supportedAbis.stream().filter(it -> Objects.equals(it.getPythonExecutable().getAbsolutePath(), pythonExecutable.getAbsolutePath())).anyMatch(it -> DefaultPythonAbiContainer.contains(it, pythonTags, abiTags, platformTags));
    }

    @Override
    public EditablePythonAbiContainer copy() {
        DefaultPythonAbiContainer container = new DefaultPythonAbiContainer();
        container.supportedAbis = new ArrayList<AbiDetails>(this.supportedAbis);
        return container;
    }

    private static boolean contains(AbiDetails triple, String[] pythonTags, String[] abiTags, String[] platformTags) {
        return DefaultPythonAbiContainer.contains(triple.getPythonTag(), pythonTags) && DefaultPythonAbiContainer.contains(triple.getAbiTag(), abiTags) && DefaultPythonAbiContainer.contains(triple.getPlatformTag(), platformTags);
    }

    private static boolean contains(String needle, String[] haystack) {
        for (String s : haystack) {
            if (!Objects.equals(needle, s)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PythonAbiContainer{supportedAbis=" + this.supportedAbis + '}';
    }
}

