/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.wheel;

import java.io.File;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonWheelDetails {
    private static final String WHEEL_FILE_FORMAT = "(?<dist>.+?)-(?<version>\\d.*?)(-(\\d.*?))?-(?<pythonTag>.+?)-(?<abiTag>.+?)-(?<platformTag>.+?).whl";
    private static final Pattern WHEEL_PATTERN = Pattern.compile("(?<dist>.+?)-(?<version>\\d.*?)(-(\\d.*?))?-(?<pythonTag>.+?)-(?<abiTag>.+?)-(?<platformTag>.+?).whl");
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("_(?<snapshot>[A-Z]+)$");
    private final File file;
    private final String dist;
    private final String version;
    private final String pythonTag;
    private final String abiTag;
    private final String platformTag;

    private PythonWheelDetails(File wheelFile, Matcher matcher) {
        this.file = wheelFile;
        this.dist = matcher.group("dist");
        String matchedVersion = matcher.group("version");
        this.pythonTag = matcher.group("pythonTag");
        this.abiTag = matcher.group("abiTag");
        this.platformTag = matcher.group("platformTag");
        Matcher snapshotMatcher = SNAPSHOT_PATTERN.matcher(matchedVersion);
        this.version = snapshotMatcher.find() ? snapshotMatcher.replaceFirst("-" + snapshotMatcher.group("snapshot")) : matchedVersion;
    }

    public File getFile() {
        return this.file;
    }

    public String getDist() {
        return this.dist;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPythonTag() {
        return this.pythonTag;
    }

    public String getAbiTag() {
        return this.abiTag;
    }

    public String getPlatformTag() {
        return this.platformTag;
    }

    public String toString() {
        return "PythonWheelDetails{file=" + this.file + ", dist='" + this.dist + '\'' + ", version='" + this.version + '\'' + ", pythonTag='" + this.pythonTag + '\'' + ", abiTag='" + this.abiTag + '\'' + ", platformTag='" + this.platformTag + '\'' + '}';
    }

    public static Optional<PythonWheelDetails> fromFile(File file) {
        Matcher matcher = WHEEL_PATTERN.matcher(file.getName());
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(new PythonWheelDetails(file, matcher));
    }
}

