/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.pip;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.PackageInfo;
import com.linkedin.gradle.python.util.StandardTextValues;
import com.linkedin.gradle.python.util.pip.PipFreezeOutputParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;

public class PipFreezeAction {
    private final Project project;

    public PipFreezeAction(Project project) {
        this.project = project;
    }

    public Map<String, String> getDependencies() {
        PythonExtension settings = ExtensionUtils.getPythonExtension(this.project);
        Set<String> developmentDependencies = PipFreezeAction.configurationToSet(this.project, StandardTextValues.CONFIGURATION_SETUP_REQS.getValue());
        developmentDependencies.addAll(PipFreezeAction.configurationToSet(this.project, StandardTextValues.CONFIGURATION_BUILD_REQS.getValue()));
        developmentDependencies.addAll(PipFreezeAction.configurationToSet(this.project, StandardTextValues.CONFIGURATION_TEST.getValue()));
        developmentDependencies.removeAll(PipFreezeAction.configurationToSet(this.project, StandardTextValues.CONFIGURATION_PYTHON.getValue()));
        ByteArrayOutputStream requirements = new ByteArrayOutputStream();
        this.project.exec(execSpec -> {
            execSpec.environment(settings.getEnvironment());
            execSpec.commandLine(new Object[]{settings.getDetails().getVirtualEnvInterpreter(), settings.getDetails().getVirtualEnvironment().getPip(), "freeze", "--all", "--disable-pip-version-check"});
            execSpec.setStandardOutput((OutputStream)requirements);
        });
        Map<String, String> dependencies = PipFreezeOutputParser.getDependencies(developmentDependencies, requirements);
        dependencies.put(this.project.getName(), this.project.getVersion().toString());
        return dependencies;
    }

    private static Set<String> configurationToSet(Project project, String configurationName) {
        return PipFreezeAction.configurationToSet(project.getConfigurations().getByName(configurationName).getFiles());
    }

    private static Set<String> configurationToSet(Collection<File> files) {
        HashSet<String> configNames = new HashSet<String>();
        for (File file : files) {
            PackageInfo packageInfo = PackageInfo.fromPath(file);
            configNames.add(packageInfo.getName());
        }
        return configNames;
    }
}

