/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.plugin.PythonHelpers;
import com.linkedin.gradle.python.tasks.supports.SupportsPackageFiltering;
import com.linkedin.gradle.python.tasks.supports.SupportsPackageInfoSettings;
import com.linkedin.gradle.python.util.PackageInfo;
import com.linkedin.gradle.python.util.PackageSettings;
import com.linkedin.gradle.python.util.StandardTextValues;
import com.linkedin.gradle.python.util.internal.TaskTimer;
import com.linkedin.gradle.python.wheel.WheelCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.process.ExecResult;

public class ParallelWheelGenerationTask
extends DefaultTask
implements SupportsPackageInfoSettings,
SupportsPackageFiltering {
    private static final Logger logger = Logging.getLogger(ParallelWheelGenerationTask.class);
    private WheelCache wheelCache;
    private Set<String> currentPackages = Collections.newSetFromMap(new ConcurrentHashMap());
    private FileCollection filesToConvert;
    private File cacheDir;
    private PythonExtension extension;
    private AtomicInteger counter = new AtomicInteger();
    private PackageSettings<PackageInfo> packageSettings;
    private Spec<PackageInfo> packageFilter;

    public ParallelWheelGenerationTask() {
        this.onlyIf(task -> {
            ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
            this.getProject().exec(execSpec -> {
                execSpec.setExecutable((Object)this.getPythonDetails().getVirtualEnvInterpreter());
                execSpec.args(new Object[]{this.getPythonDetails().getVirtualEnvironment().getPip(), "freeze", "--all"});
                execSpec.setStandardOutput((OutputStream)stdOut);
            });
            Configuration requiredDependencies = this.getProject().getConfigurations().getByName(StandardTextValues.CONFIGURATION_SETUP_REQS.getValue());
            Set setupRequiresDependencies = requiredDependencies.getIncoming().getDependencies().stream().flatMap(it -> Stream.of(it.getName(), it.getName().replace("-", "_"))).collect(Collectors.toSet());
            Set extraDependencies = Arrays.stream(stdOut.toString().trim().split(System.lineSeparator())).filter(it -> it.contains("==")).map(it -> it.split("==")[0]).filter(it -> !setupRequiresDependencies.contains(it)).collect(Collectors.toSet());
            if (!extraDependencies.isEmpty()) {
                logger.info("Extra dependencies found ({}). Skipping parallel wheel building.", extraDependencies);
            }
            return extraDependencies.isEmpty();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void buildWheels() {
        ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)this.getServices().get(ProgressLoggerFactory.class);
        ProgressLogger progressLogger = progressLoggerFactory.newOperation(ParallelWheelGenerationTask.class);
        progressLogger.setDescription("Building wheels");
        progressLogger.started();
        TaskTimer taskTimer = new TaskTimer();
        ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors() / 2 + 1);
        Set files = this.getFilesToConvert().getFiles();
        int totalSize = files.size();
        try {
            ((ForkJoinTask)forkJoinPool.submit(() -> ((Stream)files.stream().parallel()).forEach(file -> {
                PackageInfo packageInfo = PackageInfo.fromPath(file);
                this.currentPackages.add(packageInfo.getName());
                this.counter.incrementAndGet();
                this.updateStatusLine(progressLogger, totalSize, this.counter.get());
                TaskTimer.TickingClock clock = taskTimer.start(packageInfo.getName() + "-" + packageInfo.getVersion());
                if (!this.packageSettings.requiresSourceBuild(packageInfo)) {
                    this.makeWheelFromSdist(packageInfo);
                }
                this.currentPackages.remove(packageInfo.getName());
                this.updateStatusLine(progressLogger, totalSize, this.counter.get());
                clock.stop();
            }))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Unable to pre-build some dependencies");
        }
        finally {
            forkJoinPool.shutdown();
        }
        try {
            FileUtils.write((File)this.getBuildReport(), (CharSequence)taskTimer.buildReport());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        progressLogger.completed();
    }

    private void makeWheelFromSdist(PackageInfo packageInfo) {
        if (packageInfo.getPackageFile().getName().endsWith(".whl")) {
            return;
        }
        if (this.packageFilter != null && this.packageFilter.isSatisfiedBy((Object)packageInfo)) {
            if (PythonHelpers.isPlainOrVerbose(this.getProject())) {
                logger.lifecycle("Skipping building {} wheel - Excluded", new Object[]{packageInfo.toShortHand()});
            }
            return;
        }
        Optional<File> cachedWheel = this.wheelCache.findWheel(packageInfo.getName(), packageInfo.getVersion(), this.getPythonDetails());
        if (cachedWheel.isPresent()) {
            if (PythonHelpers.isPlainOrVerbose(this.getProject())) {
                logger.lifecycle("Wheel for {}-{} was found: {}", new Object[]{packageInfo.getName(), packageInfo.getVersion(), cachedWheel.get()});
            }
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ExecResult results = this.getProject().exec(exec -> {
            exec.commandLine(new Object[]{this.getPythonDetails().getVirtualEnvInterpreter(), this.getPythonDetails().getVirtualEnvironment().getPip(), "wheel", "--disable-pip-version-check", "--wheel-dir", this.cacheDir, "--no-deps", packageInfo.getPackageFile().getAbsoluteFile().getAbsolutePath()});
            exec.setStandardOutput((OutputStream)stream);
            exec.setErrorOutput((OutputStream)stream);
            exec.setIgnoreExitValue(true);
        });
        if (results.getExitValue() != 0) {
            logger.info("Unable to build wheel for {}-{}", (Object)packageInfo.getName(), (Object)packageInfo.getVersion());
            File resultDir = new File(this.getProject().getBuildDir(), this.getName() + "-" + packageInfo.getName() + "-" + packageInfo.getVersion() + ".txt");
            try {
                FileUtils.write((File)resultDir, (CharSequence)stream.toString());
            }
            catch (IOException iOException) {}
        } else if (PythonHelpers.isPlainOrVerbose(this.getProject())) {
            logger.lifecycle("Wheel was built for {}-{}", new Object[]{packageInfo.getName(), packageInfo.getVersion()});
        }
    }

    private void updateStatusLine(ProgressLogger progressLogger, int totalSize, int currentPackageCount) {
        String packagesBeingBuilt = this.currentPackages.stream().collect(Collectors.joining(", "));
        progressLogger.progress(String.format("Building wheel(s) [ %s ] %d of %d", packagesBeingBuilt, currentPackageCount, totalSize));
    }

    @Internal
    public PythonExtension getExtension() {
        if (null == this.extension) {
            this.extension = (PythonExtension)this.getProject().getExtensions().getByType(PythonExtension.class);
        }
        return this.extension;
    }

    @Override
    @Internal
    public PythonDetails getPythonDetails() {
        return this.getExtension().getDetails();
    }

    @OutputFile
    public File getBuildReport() {
        return new File(this.getProject().getBuildDir(), "wheel-build.txt");
    }

    @OutputDirectory
    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @InputFiles
    public FileCollection getFilesToConvert() {
        return this.filesToConvert;
    }

    public void setFilesToConvert(FileCollection filesToConvert) {
        this.filesToConvert = filesToConvert;
    }

    @Input
    public WheelCache getWheelCache() {
        return this.wheelCache;
    }

    public void setWheelCache(WheelCache wheelCache) {
        this.wheelCache = wheelCache;
    }

    @Override
    public void setPackageSettings(PackageSettings<PackageInfo> settings) {
        this.packageSettings = settings;
    }

    @Override
    public PackageSettings<PackageInfo> getPackageSettings() {
        return this.packageSettings;
    }

    @Override
    @Nullable
    public Spec<PackageInfo> getPackageExcludeFilter() {
        return this.packageFilter;
    }

    @Override
    public void setPackageExcludeFilter(Spec<PackageInfo> filter) {
        this.packageFilter = filter;
    }
}

