/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin.internal;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.BlackExtension;
import com.linkedin.gradle.python.extension.CoverageExtension;
import com.linkedin.gradle.python.extension.IsortExtension;
import com.linkedin.gradle.python.extension.MypyExtension;
import com.linkedin.gradle.python.tasks.AbstractPythonMainSourceDefaultTask;
import com.linkedin.gradle.python.tasks.AbstractPythonTestSourceDefaultTask;
import com.linkedin.gradle.python.tasks.BlackTask;
import com.linkedin.gradle.python.tasks.CheckStyleGeneratorTask;
import com.linkedin.gradle.python.tasks.Flake8Task;
import com.linkedin.gradle.python.tasks.IsortTask;
import com.linkedin.gradle.python.tasks.MypyTask;
import com.linkedin.gradle.python.tasks.PyCoverageTask;
import com.linkedin.gradle.python.tasks.PyTestTask;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import java.util.function.BiPredicate;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ValidationPlugin
implements Plugin<Project> {
    private static final Logger LOG = Logging.getLogger(ValidationPlugin.class);

    public void apply(Project project) {
        PythonExtension settings = ExtensionUtils.getPythonExtension(project);
        project.getTasks().withType(AbstractPythonMainSourceDefaultTask.class, task -> task.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_INSTALL_BUILD_REQS.getValue())}));
        project.getTasks().withType(AbstractPythonTestSourceDefaultTask.class, task -> task.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_INSTALL_PROJECT.getValue())}));
        CoverageExtension cov = ExtensionUtils.maybeCreate(project, StandardTextValues.TASK_COVERAGE.getValue(), CoverageExtension.class, new Object[0]);
        BiPredicate<String, Boolean> pytestOrCoverage = (taskName, covShouldBeEnabled) -> project.file((Object)settings.testDir).exists() && (cov.isRun() == covShouldBeEnabled.booleanValue() || project.getGradle().getStartParameter().getTaskNames().contains(taskName));
        project.getTasks().create(StandardTextValues.TASK_PYTEST.getValue(), PyTestTask.class, task -> task.onlyIf(it -> {
            boolean shouldRun = pytestOrCoverage.test(StandardTextValues.TASK_PYTEST.getValue(), false);
            if (!shouldRun) {
                LOG.info("Skipping pytest task; Either you don't have tests written or coverage is enabled and pytests will be run during the coverage task instead.");
            }
            return shouldRun;
        }));
        project.getTasks().getByName(StandardTextValues.TASK_CHECK.getValue()).dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_PYTEST.getValue())});
        project.getTasks().create(StandardTextValues.TASK_COVERAGE.getValue(), PyCoverageTask.class, task -> task.onlyIf(it -> pytestOrCoverage.test(StandardTextValues.TASK_COVERAGE.getValue(), true)));
        project.getTasks().getByName(StandardTextValues.TASK_CHECK.getValue()).dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_COVERAGE.getValue())});
        project.getTasks().create(StandardTextValues.TASK_FLAKE.getValue(), Flake8Task.class, task -> task.onlyIf(it -> project.file((Object)settings.srcDir).exists() || project.file((Object)settings.testDir).exists()));
        MypyExtension mypy = ExtensionUtils.maybeCreate(project, "mypy", MypyExtension.class, new Object[0]);
        project.getTasks().create(StandardTextValues.TASK_MYPY.getValue(), MypyTask.class, task -> task.onlyIf(it -> project.file((Object)settings.srcDir).exists() && mypy.isRun()));
        project.getTasks().getByName(StandardTextValues.TASK_CHECK.getValue()).dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_MYPY.getValue())});
        IsortExtension isort = ExtensionUtils.maybeCreate(project, "isort", IsortExtension.class, new Object[0]);
        project.getTasks().create(StandardTextValues.TASK_ISORT.getValue(), IsortTask.class, task -> task.onlyIf(it -> project.file((Object)settings.srcDir).exists() && isort.isRun()));
        project.getTasks().getByName(StandardTextValues.TASK_CHECK.getValue()).dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_ISORT.getValue())});
        BlackExtension black = ExtensionUtils.maybeCreate(project, "black", BlackExtension.class, new Object[0]);
        project.getTasks().create(StandardTextValues.TASK_BLACK.getValue(), BlackTask.class, task -> task.onlyIf(it -> project.file((Object)settings.srcDir).exists() && black.isRun()));
        project.getTasks().getByName(StandardTextValues.TASK_CHECK.getValue()).dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_BLACK.getValue())});
        project.getTasks().create(StandardTextValues.TASK_CHECKSTYLE.getValue(), CheckStyleGeneratorTask.class);
        project.getTasks().getByName(StandardTextValues.TASK_CHECK.getValue()).dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_FLAKE.getValue())});
    }
}

