/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import com.linkedin.gradle.python.extension.DeployableExtension;
import com.linkedin.gradle.python.extension.PexExtension;
import com.linkedin.gradle.python.plugin.PythonBasePlugin;
import com.linkedin.gradle.python.plugin.PythonContainerPlugin;
import com.linkedin.gradle.python.tasks.BuildWebAppTask;
import com.linkedin.gradle.python.util.ExtensionUtils;
import java.io.File;
import org.gradle.api.Project;

public class PythonWebApplicationPlugin
extends PythonBasePlugin {
    public static final String TASK_BUILD_WEB_APPLICATION = "buildWebApplication";
    public static final String TASK_PACKAGE_WEB_APPLICATION = "packageWebApplication";
    public static final String GUNICORN_ENTRYPOINT = "gunicorn.app.wsgiapp:run";
    public static final String GUNICORN = "gunicorn";

    @Override
    public void applyTo(Project project) {
        project.getPlugins().apply(PythonContainerPlugin.class);
        DeployableExtension deployableExtension = ExtensionUtils.maybeCreateDeployableExtension(project);
        new PexExtension(project).addDependencies(project);
        project.getTasks().create(TASK_BUILD_WEB_APPLICATION, BuildWebAppTask.class, task -> {
            task.setDescription("Build a web app, by default using gunicorn, but it's configurable.");
            task.mustRunAfter(new Object[]{"assembleContainers"});
            task.setExecutable(new File(deployableExtension.getDeployableBinDir(), GUNICORN));
            task.setEntryPoint(GUNICORN_ENTRYPOINT);
        });
        project.getTasks().getByName("packageDeployable").dependsOn(new Object[]{project.getTasks().getByName(TASK_BUILD_WEB_APPLICATION)});
        project.getTasks().create(TASK_PACKAGE_WEB_APPLICATION, task -> {
            task.setDescription("Backward compatibility place-holder task for packaging web app");
            task.dependsOn(new Object[]{project.getTasks().getByName(TASK_BUILD_WEB_APPLICATION)});
            task.setEnabled(false);
        });
        project.getTasks().getByName("packageDeployable").dependsOn(new Object[]{project.getTasks().getByName(TASK_PACKAGE_WEB_APPLICATION)});
    }
}

