/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.plugin.LayeredWheelCachePlugin;
import com.linkedin.gradle.python.plugin.PyGradleDependencyResolveDetails;
import com.linkedin.gradle.python.plugin.internal.DocumentationPlugin;
import com.linkedin.gradle.python.plugin.internal.InstallDependenciesPlugin;
import com.linkedin.gradle.python.plugin.internal.ValidationPlugin;
import com.linkedin.gradle.python.tasks.CleanSaveVenvTask;
import com.linkedin.gradle.python.tasks.GenerateSetupPyTask;
import com.linkedin.gradle.python.tasks.GetProbedTagsTask;
import com.linkedin.gradle.python.tasks.InstallVirtualEnvironmentTask;
import com.linkedin.gradle.python.tasks.PinRequirementsTask;
import com.linkedin.gradle.python.tasks.provides.ProvidesVenv;
import com.linkedin.gradle.python.tasks.supports.SupportsPackageFiltering;
import com.linkedin.gradle.python.tasks.supports.SupportsPackageInfoSettings;
import com.linkedin.gradle.python.util.DefaultPackageSettings;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.FileSystemUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import com.linkedin.gradle.python.util.internal.PyPiRepoUtil;
import com.linkedin.gradle.python.wheel.EditablePythonAbiContainer;
import com.linkedin.gradle.python.wheel.internal.DefaultPythonAbiContainer;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class PythonPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        PythonExtension settings = (PythonExtension)project.getExtensions().create("python", PythonExtension.class, new Object[]{project});
        EditablePythonAbiContainer supportedWheelFormats = ExtensionUtils.maybeCreate(settings, EditablePythonAbiContainer.class.getName(), DefaultPythonAbiContainer.class, new Object[0]);
        project.getTasks().withType(ProvidesVenv.class, it -> it.setEditablePythonAbiContainer(supportedWheelFormats));
        project.getPlugins().apply("base");
        PythonPlugin.createConfigurations(project);
        PythonPlugin.configureVendedDependencies(project, settings);
        project.getTasks().withType(SupportsPackageFiltering.class, action -> action.getOutputs().doNotCacheIf("When package packageFilter is set", task -> ((SupportsPackageFiltering)task).getPackageExcludeFilter() != null));
        DefaultPackageSettings packageSettings = new DefaultPackageSettings(project.getProjectDir());
        project.getTasks().withType(SupportsPackageInfoSettings.class, it -> it.setPackageSettings(packageSettings));
        PyGradleDependencyResolveDetails dependencyResolveDetails = new PyGradleDependencyResolveDetails(settings.forcedVersions);
        project.getConfigurations().forEach(configuration -> configuration.getResolutionStrategy().eachDependency((Action)dependencyResolveDetails));
        PinRequirementsTask pinRequirementsTask = (PinRequirementsTask)project.getTasks().create(StandardTextValues.TASK_PIN_REQUIREMENTS.getValue(), PinRequirementsTask.class);
        project.getTasks().create(StandardTextValues.TASK_VENV_CREATE.getValue(), InstallVirtualEnvironmentTask.class, task -> {
            task.dependsOn(new Object[]{pinRequirementsTask});
            task.setPythonDetails(settings.getDetails());
        });
        project.getTasks().create(StandardTextValues.TASK_GET_PROBED_TAGS.getValue(), GetProbedTagsTask.class, task -> {
            task.dependsOn(new Object[]{StandardTextValues.TASK_VENV_CREATE.getValue()});
            task.setPythonDetails(settings.getDetails());
        });
        project.getTasks().create(StandardTextValues.TASK_SETUP_LINKS.getValue(), task -> {
            task.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_VENV_CREATE.getValue())});
            task.dependsOn(new Object[]{project.getTasks().getByName(StandardTextValues.TASK_GET_PROBED_TAGS.getValue())});
            task.getOutputs().file((Object)settings.getDetails().getActivateLink());
            task.doLast(it -> {
                File activateLinkSource = settings.getDetails().getVirtualEnvironment().getScript("activate");
                File activateLink = settings.getDetails().getActivateLink();
                FileSystemUtils.makeSymLinkUnchecked(activateLinkSource, activateLink);
            });
        });
        project.getTasks().create(StandardTextValues.TASK_CLEAN_SAVE_VENV.getValue(), CleanSaveVenvTask.class, task -> task.setGroup("build"));
        project.getTasks().create(StandardTextValues.TASK_SETUP_PY_WRITER.getValue(), GenerateSetupPyTask.class);
        project.getPlugins().apply(InstallDependenciesPlugin.class);
        project.getPlugins().apply(ValidationPlugin.class);
        project.getPlugins().apply(DocumentationPlugin.class);
        project.getPlugins().apply(LayeredWheelCachePlugin.class);
        PyPiRepoUtil.setupPyGradleRepo(project);
    }

    private static void createConfigurations(Project project) {
        Configuration pythonConf = (Configuration)project.getConfigurations().create(StandardTextValues.CONFIGURATION_PYTHON.getValue());
        project.getConfigurations().getByName("default").extendsFrom(new Configuration[]{pythonConf});
        project.getConfigurations().create(StandardTextValues.CONFIGURATION_BOOTSTRAP_REQS.getValue());
        project.getConfigurations().create(StandardTextValues.CONFIGURATION_SETUP_REQS.getValue());
        Configuration buildReq = (Configuration)project.getConfigurations().create(StandardTextValues.CONFIGURATION_BUILD_REQS.getValue());
        project.getConfigurations().create(StandardTextValues.CONFIGURATION_PYDOCS.getValue());
        project.getConfigurations().create(StandardTextValues.CONFIGURATION_TEST.getValue());
        project.getConfigurations().create(StandardTextValues.CONFIGURATION_VENV.getValue());
        project.getConfigurations().create(StandardTextValues.CONFIGURATION_WHEEL.getValue());
        Configuration flake8 = (Configuration)project.getConfigurations().create("flake8");
        buildReq.extendsFrom(new Configuration[]{flake8});
    }

    private static void configureVendedDependencies(Project project, PythonExtension settings) {
        project.getDependencies().add(StandardTextValues.CONFIGURATION_BOOTSTRAP_REQS.getValue(), settings.forcedVersions.get("virtualenv"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_SETUP_REQS.getValue(), settings.forcedVersions.get("setuptools"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_SETUP_REQS.getValue(), settings.forcedVersions.get("wheel"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_SETUP_REQS.getValue(), settings.forcedVersions.get("pip"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_SETUP_REQS.getValue(), settings.forcedVersions.get("setuptools-git"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_BUILD_REQS.getValue(), settings.forcedVersions.get("flake8"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_BUILD_REQS.getValue(), settings.forcedVersions.get("Sphinx"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_TEST.getValue(), settings.forcedVersions.get("pytest"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_TEST.getValue(), settings.forcedVersions.get("pytest-cov"));
        project.getDependencies().add(StandardTextValues.CONFIGURATION_TEST.getValue(), settings.forcedVersions.get("pytest-xdist"));
    }
}

