/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import com.linkedin.gradle.python.extension.DeployableExtension;
import com.linkedin.gradle.python.plugin.PythonWebApplicationPlugin;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.FileSystemUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import java.io.File;
import java.nio.file.Paths;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.Copy;

public class PythonFlyerPlugin
implements Plugin<Project> {
    public static final String TASK_SETUP_RESOURCE_LINK = "setupResourceLink";
    public static final String TASK_PACKAGE_RESOURCE_FILES = "packageResourceFiles";

    public void apply(Project project) {
        project.getPlugins().apply(PythonWebApplicationPlugin.class);
        Configuration resourceConf = (Configuration)project.getConfigurations().create("resource");
        project.getTasks().create(TASK_SETUP_RESOURCE_LINK, task -> {
            task.dependsOn(new Object[]{resourceConf});
            task.doLast(it -> {
                if (!Paths.get(project.getProjectDir().getAbsolutePath(), "resource").toFile().exists()) {
                    project.getLogger().lifecycle("Making the Symlink: {}{}resource --> {}", new Object[]{project.getProjectDir(), Character.valueOf(File.separatorChar), String.valueOf(resourceConf.getSingleFile())});
                    FileSystemUtils.makeSymLinkUnchecked(resourceConf.getSingleFile(), new File(project.getProjectDir(), "resource"));
                }
            });
        });
        project.getTasks().getByName(StandardTextValues.TASK_INSTALL_PROJECT.getValue()).dependsOn(new Object[]{project.getTasks().getByName(TASK_SETUP_RESOURCE_LINK)});
        project.getTasks().create(TASK_PACKAGE_RESOURCE_FILES, Copy.class, copy -> {
            DeployableExtension deployableExtension = ExtensionUtils.maybeCreateDeployableExtension(project);
            copy.dependsOn(new Object[]{project.getTasks().getByName("buildWebApplication")});
            copy.from(new Object[]{resourceConf});
            copy.into((Object)deployableExtension.getDeployableBuildDir().toPath().resolve("resource"));
        });
        project.getTasks().getByName("packageDeployable").dependsOn(new Object[]{project.getTasks().getByName(TASK_PACKAGE_RESOURCE_FILES)});
    }
}

