/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.extension;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.ZipappContainerExtension;
import com.linkedin.gradle.python.tasks.BuildPexTask;
import com.linkedin.gradle.python.util.ApplicationContainer;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import java.io.File;
import org.gradle.api.Project;

public class PexExtension
implements ApplicationContainer {
    public static final String TASK_BUILD_PEX = "realBuildPex";
    public static final String TASK_BUILD_NOOP_PEX = "buildPex";
    private File cache;
    private boolean pythonWrapper = true;
    private Project project;

    public PexExtension(Project project) {
        this.cache = new File(project.getBuildDir(), "pex-cache");
        this.project = project;
    }

    public File getPexCache() {
        return this.cache;
    }

    public void setPexCache(File pexCache) {
        this.cache = pexCache;
    }

    public boolean isPythonWrapper() {
        return this.pythonWrapper;
    }

    public void setPythonWrapper(boolean pythonWrapper) {
        this.pythonWrapper = pythonWrapper;
    }

    public File getCache() {
        return this.cache;
    }

    public void setCache(File cache) {
        this.cache = cache;
    }

    @Override
    public void addExtensions(Project project) {
        ExtensionUtils.maybeCreatePexExtension(project);
    }

    @Override
    public void addDependencies(Project project) {
        PythonExtension extension = ExtensionUtils.getPythonExtension(project);
        project.getDependencies().add(StandardTextValues.CONFIGURATION_BUILD_REQS.getValue(), extension.forcedVersions.get("pex"));
    }

    @Override
    public void makeTasks(Project project) {
        project.getTasks().maybeCreate(TASK_BUILD_PEX, BuildPexTask.class);
    }

    @Deprecated
    public boolean isFatPex() {
        return ExtensionUtils.getPythonComponentExtension(this.project, ZipappContainerExtension.class).isFat();
    }

    @Deprecated
    public void setFatPex(boolean fatPex) {
        ExtensionUtils.getPythonComponentExtension(this.project, ZipappContainerExtension.class).setIsFat(fatPex);
    }

    @Deprecated
    public boolean isFat() {
        return ExtensionUtils.getPythonComponentExtension(this.project, ZipappContainerExtension.class).isFat();
    }

    @Deprecated
    public void setIsFat(boolean isFat) {
        ExtensionUtils.getPythonComponentExtension(this.project, ZipappContainerExtension.class).setIsFat(isFat);
    }
}

