/*
 * Copyright 2016 LinkedIn Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.linkedin.gradle.python.tasks;

import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

import java.io.File;


public class CleanSaveVenvTask extends DefaultTask {

    @TaskAction
    public void cleanProject() throws Exception {
        File buildDir = getProject().getBuildDir();
        File[] directoryListing = buildDir.listFiles();
        if (directoryListing != null) {
            for (File f : directoryListing) {
                if (!f.getName().equals("venv")) {
                    f.delete();
                }
            }
        }
    }
}
