/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security.trustedproxy;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.security.spnego.SpnegoSecurityProvider;
import com.linkedin.kafka.cruisecontrol.servlet.security.trustedproxy.TrustedProxyLoginService;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.ConfigurableSpnegoAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedProxySecurityProvider
extends SpnegoSecurityProvider {
    private List<String> _trustedProxyServices;
    private String _trustedProxyServicesIpRegex;
    private static final Logger LOG = LoggerFactory.getLogger(TrustedProxySecurityProvider.class);

    @Override
    public void init(KafkaCruiseControlConfig config) {
        super.init(config);
        this._trustedProxyServices = config.getList("trusted.proxy.services");
        String ipWhitelistRegex = config.getString("trusted.proxy.services.ip.regex");
        if (ipWhitelistRegex != null) {
            this._trustedProxyServicesIpRegex = ipWhitelistRegex;
        }
        LOG.info("Setting up authentication for trusted proxy list [{}] with keytab {} and spnego principal {} with IP whitelist regex {}", new Object[]{String.join((CharSequence)",", this._trustedProxyServices), this._keyTabPath, this._spnegoPrincipal, this._trustedProxyServicesIpRegex});
    }

    @Override
    public LoginService loginService() {
        TrustedProxyLoginService loginService = new TrustedProxyLoginService(this._spnegoPrincipal.realm(), this.authorizationService(), this._trustedProxyServices, this._trustedProxyServicesIpRegex);
        loginService.setServiceName(this._spnegoPrincipal.serviceName());
        loginService.setHostName(this._spnegoPrincipal.hostName());
        loginService.setKeyTabPath(Paths.get(this._keyTabPath, new String[0]));
        return loginService;
    }

    @Override
    public Authenticator authenticator() {
        return new ConfigurableSpnegoAuthenticator();
    }
}

